/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mangopill.customized.common.block.entity.AbstractPlateBlockEntity;
import mangopill.customized.common.block.state.PlateState;
import mangopill.customized.common.item.AbstractPlateItem;
import mangopill.customized.common.registry.ModParticleTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.level.storage.loot.parameters.LootContextParams;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractPlateBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<PlateState> DRIVE = EnumProperty.m_61587_((String)"drive", PlateState.class);

    protected AbstractPlateBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_(DRIVE, (Comparable)((Object)PlateState.WITHOUT_DRIVE)));
    }

    public abstract VoxelShape setShapeWithoutDrive();

    public abstract VoxelShape setShapeWithDrive();

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult hitResult) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractPlateBlockEntity) {
            AbstractPlateBlockEntity plateBlockEntity = (AbstractPlateBlockEntity)blockEntity;
            plateBlockEntity.eatFood(level, player, state, pos);
        }
        return super.m_6227_(state, level, pos, player, hand, hitResult);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        builder.m_61104_(new Property[]{DRIVE});
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((PlateState)((Object)state.m_61143_(DRIVE))) {
            default -> throw new IncompatibleClassChangeError();
            case PlateState.WITHOUT_DRIVE -> this.setShapeWithoutDrive();
            case PlateState.WITH_DRIVE -> this.setShapeWithDrive();
        };
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((PlateState)((Object)state.m_61143_(DRIVE))) {
            default -> throw new IncompatibleClassChangeError();
            case PlateState.WITHOUT_DRIVE -> this.setShapeWithoutDrive();
            case PlateState.WITH_DRIVE -> this.setShapeWithDrive();
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean hasWater = context.m_43725_().m_6425_(context.m_8083_()).m_76152_().m_6212_((Fluid)Fluids.f_76193_);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(hasWater))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_())).m_61124_(DRIVE, (Comparable)((Object)PlateState.WITHOUT_DRIVE));
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_214162_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractPlateBlockEntity && ((PlateState)((Object)state.m_61143_(DRIVE))).equals((Object)PlateState.WITH_DRIVE) && random.m_188501_() <= 0.3f) {
            double x = (double)pos.m_123341_() + 0.2 + random.m_188500_() * 0.3;
            double y = (double)pos.m_123342_() + 0.2;
            double z = (double)pos.m_123343_() + 0.2 + random.m_188500_() * 0.3;
            level.m_7106_((ParticleOptions)ModParticleTypeRegistry.AROMA.get(), x, y, z, 0.0, 0.0, 0.0);
        }
    }

    public void m_6402_(@Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState state, @Nullable LivingEntity placer, @Nonnull ItemStack stack) {
        super.m_6402_(level, pos, state, placer, stack);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractPlateBlockEntity) {
            AbstractPlateBlockEntity plateEntity = (AbstractPlateBlockEntity)blockEntity;
            plateEntity.m_6596_();
        }
    }

    @Nonnull
    public ItemStack m_7397_(@Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull BlockState state) {
        ItemStack itemStack;
        ItemStack stack = super.m_7397_(level, pos, state);
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractPlateBlockEntity) {
            AbstractPlateBlockEntity plateBlockEntity = (AbstractPlateBlockEntity)blockEntity;
            itemStack = plateBlockEntity.getCloneItemStack(stack);
        } else {
            itemStack = stack;
        }
        return itemStack;
    }

    @Nonnull
    public List<ItemStack> m_49635_(@Nonnull BlockState state, @Nonnull LootParams.Builder builder) {
        List drops = super.m_49635_(state, builder);
        BlockEntity blockEntity = (BlockEntity)builder.m_287261_(LootContextParams.f_81462_);
        if (blockEntity instanceof AbstractPlateBlockEntity) {
            AbstractPlateBlockEntity plateEntity = (AbstractPlateBlockEntity)blockEntity;
            for (ItemStack stack : drops) {
                if (!(stack.m_41720_() instanceof AbstractPlateItem)) continue;
                stack.m_41751_(plateEntity.m_5995_());
            }
        }
        return drops;
    }
}

