/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block;

import javax.annotation.Nonnull;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.state.PotState;
import mangopill.customized.common.block.strategy.base.PotStrategyHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.EnumProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;

public abstract class AbstractPotBlock
extends BaseEntityBlock
implements SimpleWaterloggedBlock {
    public static final EnumProperty<PotState> LID = EnumProperty.m_61587_((String)"lid", PotState.class);

    protected AbstractPotBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_(LID, (Comparable)((Object)PotState.WITHOUT_LID)));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult result) {
        return PotStrategyHandler.getInstance().useByRegistry(this.m_7705_(), player.m_21120_(hand), state, level, pos, player, hand, result);
    }

    public abstract VoxelShape setShapeWithoutLid();

    public abstract VoxelShape setShapeWithLid();

    public abstract VoxelShape setShapeWithDrive();

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61362_});
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        builder.m_61104_(new Property[]{LID});
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter getter, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((PotState)((Object)state.m_61143_(LID))) {
            default -> throw new IncompatibleClassChangeError();
            case PotState.WITHOUT_LID -> this.setShapeWithoutLid();
            case PotState.WITH_LID -> this.setShapeWithLid();
            case PotState.WITH_DRIVE -> this.setShapeWithDrive();
        };
    }

    @Nonnull
    public VoxelShape m_5939_(BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return switch ((PotState)((Object)state.m_61143_(LID))) {
            default -> throw new IncompatibleClassChangeError();
            case PotState.WITHOUT_LID -> this.setShapeWithoutLid();
            case PotState.WITH_LID -> this.setShapeWithLid();
            case PotState.WITH_DRIVE -> this.setShapeWithDrive();
        };
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        boolean hasWater = context.m_43725_().m_6425_(context.m_8083_()).m_76152_().m_6212_((Fluid)Fluids.f_76193_);
        return (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(hasWater))).m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_())).m_61124_(LID, (Comparable)((Object)PotState.WITHOUT_LID));
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean movedByPiston) {
        if (state.m_60734_() == newState.m_60734_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractPotBlockEntity) {
            AbstractPotBlockEntity potBlockEntity = (AbstractPotBlockEntity)blockEntity;
            NonNullList stackNonNullList = NonNullList.m_122779_();
            stackNonNullList.addAll(potBlockEntity.getItemStackListInPot(false, true));
            Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)stackNonNullList);
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }
}

