/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block;

import javax.annotation.Nonnull;
import mangopill.customized.common.block.entity.BrewingBarrelBlockEntity;
import mangopill.customized.common.registry.ModBlockEntityTypeRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.NonNullList;
import net.minecraft.world.Containers;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.BaseEntityBlock;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.RenderShape;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import org.checkerframework.checker.nullness.qual.Nullable;

public class BrewingBarrelBlock
extends BaseEntityBlock {
    public static final IntegerProperty PROGRESS = IntegerProperty.m_61631_((String)"progress", (int)0, (int)12);

    public BrewingBarrelBlock(BlockBehaviour.Properties properties) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)Direction.NORTH)).m_61124_((Property)PROGRESS, (Comparable)Integer.valueOf(0)));
    }

    @Nonnull
    public InteractionResult m_6227_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull Player player, @Nonnull InteractionHand hand, @Nonnull BlockHitResult result) {
        if (level.f_46443_) {
            return InteractionResult.SUCCESS;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BrewingBarrelBlockEntity) {
            BrewingBarrelBlockEntity barrelBlockEntity = (BrewingBarrelBlockEntity)blockEntity;
            barrelBlockEntity.interact(player.m_21120_(hand), player, level, pos);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.SUCCESS;
    }

    public void m_6810_(@Nonnull BlockState state, @Nonnull Level level, @Nonnull BlockPos pos, @Nonnull BlockState newState, boolean movedByPiston) {
        if (state.m_60734_() == newState.m_60734_()) {
            return;
        }
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof BrewingBarrelBlockEntity) {
            BrewingBarrelBlockEntity brewingBarrelBlockEntity = (BrewingBarrelBlockEntity)blockEntity;
            NonNullList stackNonNullList = NonNullList.m_122779_();
            stackNonNullList.addAll(brewingBarrelBlockEntity.getItemStackListInBrewingBarrel(false));
            Containers.m_19010_((Level)level, (BlockPos)pos, (NonNullList)stackNonNullList);
            level.m_46717_(pos, (Block)this);
        }
        super.m_6810_(state, level, pos, newState, movedByPiston);
    }

    public <T extends BlockEntity> @Nullable BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> blockEntityType) {
        if (level.f_46443_) {
            return null;
        }
        return BrewingBarrelBlock.m_152132_(blockEntityType, ModBlockEntityTypeRegistry.BREWING_BARREL.get(), BrewingBarrelBlockEntity::cookingTick);
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{BlockStateProperties.f_61374_});
        builder.m_61104_(new Property[]{PROGRESS});
    }

    @Nonnull
    public RenderShape m_7514_(@Nonnull BlockState state) {
        return RenderShape.MODEL;
    }

    public BlockState m_5573_(BlockPlaceContext context) {
        return (BlockState)((BlockState)this.m_49966_().m_61124_((Property)BlockStateProperties.f_61374_, (Comparable)context.m_8125_())).m_61124_((Property)PROGRESS, (Comparable)Integer.valueOf(0));
    }

    public @Nullable BlockEntity m_142194_(@Nonnull BlockPos blockPos, @Nonnull BlockState blockState) {
        return ModBlockEntityTypeRegistry.BREWING_BARREL.get().m_155264_(blockPos, blockState);
    }
}

