/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block;

import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mangopill.customized.common.block.AbstractPotBlock;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.entity.CasseroleBlockEntity;
import mangopill.customized.common.block.record.PotRecord;
import mangopill.customized.common.block.state.PotState;
import mangopill.customized.common.registry.ModItemRegistry;
import mangopill.customized.common.registry.ModSoundRegistry;
import net.minecraft.core.BlockPos;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityTicker;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.storage.loot.LootParams;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;

public class CasseroleBlock
extends AbstractPotBlock {
    protected static final VoxelShape BLOCK_SHAPE_WITHOUT_LID = Shapes.m_83124_((VoxelShape)Block.m_49796_((double)13.0, (double)1.0, (double)3.0, (double)14.0, (double)3.0, (double)13.0), (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)1.0, (double)3.0, (double)2.0, (double)2.0, (double)8.0, (double)14.0), Block.m_49796_((double)0.5, (double)8.0, (double)2.0, (double)1.5, (double)9.0, (double)14.0), Block.m_49796_((double)1.0, (double)8.0, (double)1.0, (double)2.0, (double)9.0, (double)2.0), Block.m_49796_((double)1.0, (double)8.0, (double)14.0, (double)2.0, (double)9.0, (double)15.0), Block.m_49796_((double)14.0, (double)8.0, (double)14.0, (double)15.0, (double)9.0, (double)15.0), Block.m_49796_((double)14.0, (double)8.0, (double)1.0, (double)15.0, (double)9.0, (double)2.0), Block.m_49796_((double)14.5, (double)8.0, (double)2.0, (double)15.5, (double)9.0, (double)14.0), Block.m_49796_((double)14.0, (double)3.0, (double)2.0, (double)15.0, (double)8.0, (double)14.0), Block.m_49796_((double)2.0, (double)8.0, (double)0.5, (double)14.0, (double)9.0, (double)1.5), Block.m_49796_((double)2.0, (double)8.0, (double)14.5, (double)14.0, (double)9.0, (double)15.5), Block.m_49796_((double)3.0, (double)1.0, (double)2.0, (double)13.0, (double)3.0, (double)3.0), Block.m_49796_((double)2.0, (double)3.0, (double)1.0, (double)14.0, (double)8.0, (double)2.0), Block.m_49796_((double)2.0, (double)3.0, (double)14.0, (double)14.0, (double)8.0, (double)15.0), Block.m_49796_((double)3.0, (double)1.0, (double)13.0, (double)13.0, (double)3.0, (double)14.0), Block.m_49796_((double)2.0, (double)1.0, (double)3.0, (double)3.0, (double)3.0, (double)13.0), Block.m_49796_((double)3.0, (double)0.0, (double)3.0, (double)13.0, (double)1.0, (double)13.0), Block.m_49796_((double)2.0, (double)2.0, (double)2.0, (double)3.0, (double)3.0, (double)3.0), Block.m_49796_((double)2.0, (double)2.0, (double)13.0, (double)3.0, (double)3.0, (double)14.0), Block.m_49796_((double)13.0, (double)2.0, (double)13.0, (double)14.0, (double)3.0, (double)14.0), Block.m_49796_((double)13.0, (double)2.0, (double)2.0, (double)14.0, (double)3.0, (double)3.0)});
    protected static final VoxelShape BLOCK_SHAPE_WITH_LID = Shapes.m_83124_((VoxelShape)BLOCK_SHAPE_WITHOUT_LID, (VoxelShape[])new VoxelShape[]{Block.m_49796_((double)12.0, (double)8.0, (double)4.0, (double)14.0, (double)8.5, (double)12.0), Block.m_49796_((double)2.0, (double)8.0, (double)2.0, (double)14.0, (double)8.5, (double)4.0), Block.m_49796_((double)4.0, (double)8.5, (double)4.0, (double)12.0, (double)9.0, (double)12.0), Block.m_49796_((double)2.0, (double)8.0, (double)4.0, (double)4.0, (double)8.5, (double)12.0), Block.m_49796_((double)2.0, (double)8.0, (double)12.0, (double)14.0, (double)8.5, (double)14.0), Block.m_49796_((double)6.5, (double)9.5, (double)6.5, (double)9.5, (double)10.0, (double)9.5), Block.m_49796_((double)7.0, (double)9.5, (double)7.0, (double)9.0, (double)10.5, (double)9.0), Block.m_49796_((double)7.0, (double)9.0, (double)7.0, (double)9.0, (double)9.5, (double)9.0)});

    public CasseroleBlock(BlockBehaviour.Properties properties) {
        super(properties);
    }

    public void m_214162_(@Nonnull BlockState state, Level level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        CasseroleBlockEntity cookingPotEntity;
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof CasseroleBlockEntity && (cookingPotEntity = (CasseroleBlockEntity)blockEntity).isHeated() && !((PotState)((Object)state.m_61143_((Property)LID))).equals((Object)PotState.WITHOUT_LID)) {
            double x = (double)pos.m_123341_() + 0.4;
            double y = pos.m_123342_();
            double z = (double)pos.m_123343_() + 0.4;
            if (random.m_188503_(8) == 0) {
                SoundEvent sound = ((PotState)((Object)state.m_61143_((Property)LID))).equals((Object)PotState.WITH_LID) ? ModSoundRegistry.BOILING_WATER_WITH_LID.get() : ModSoundRegistry.BOILING_WATER_WITHOUT_LID.get();
                level.m_7785_(x, y, z, sound, SoundSource.BLOCKS, random.m_188501_() * 0.4f + 0.3f, 0.8f, false);
            }
        }
    }

    @Nullable
    public <T extends BlockEntity> BlockEntityTicker<T> m_142354_(@Nonnull Level level, @Nonnull BlockState state, @Nonnull BlockEntityType<T> blockEntityType) {
        if (!((PotState)((Object)state.m_61143_((Property)LID))).equals((Object)PotState.WITHOUT_LID)) {
            if (level.f_46443_) {
                return CasseroleBlock.m_152132_(blockEntityType, PotRecord.CASSEROLE.entityType(), AbstractPotBlockEntity::animationTick);
            }
            return CasseroleBlock.m_152132_(blockEntityType, PotRecord.CASSEROLE.entityType(), AbstractPotBlockEntity::cookingTick);
        }
        return null;
    }

    @Nullable
    public BlockEntity m_142194_(@Nonnull BlockPos pos, @Nonnull BlockState state) {
        return PotRecord.CASSEROLE.entityType().m_155264_(pos, state);
    }

    @Nonnull
    public List<ItemStack> m_49635_(@Nonnull BlockState state, @Nonnull LootParams.Builder builder) {
        if (((PotState)((Object)state.m_61143_((Property)LID))).equals((Object)PotState.WITH_LID)) {
            List getDrops = super.m_49635_(state, builder);
            getDrops.add(new ItemStack((ItemLike)ModItemRegistry.CASSEROLE_ILD.get()));
            return getDrops;
        }
        return super.m_49635_(state, builder);
    }

    @Override
    @Nonnull
    public VoxelShape setShapeWithoutLid() {
        return BLOCK_SHAPE_WITHOUT_LID;
    }

    @Override
    @Nonnull
    public VoxelShape setShapeWithLid() {
        return BLOCK_SHAPE_WITH_LID;
    }

    @Override
    @Nonnull
    public VoxelShape setShapeWithDrive() {
        return BLOCK_SHAPE_WITHOUT_LID;
    }
}

