/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block;

import javax.annotation.Nonnull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.tags.FluidTags;
import net.minecraft.util.Mth;
import net.minecraft.util.RandomSource;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BonemealableBlock;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.SimpleWaterloggedBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.FluidState;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.common.ForgeHooks;

public abstract class TallWaterloggedCropBlock
extends BushBlock
implements BonemealableBlock,
SimpleWaterloggedBlock {
    public static final IntegerProperty AGE = BlockStateProperties.f_61409_;
    public static final BooleanProperty GROW_PLACED = BooleanProperty.m_61465_((String)"grow_placed");
    private final int topMaxAge = 7;
    private final int bottomMaxAge;

    public TallWaterloggedCropBlock(BlockBehaviour.Properties properties, int bottomMaxAge) {
        super(properties);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(0))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(true))).m_61124_((Property)GROW_PLACED, (Comparable)Boolean.valueOf(false)));
        this.bottomMaxAge = bottomMaxAge;
    }

    public abstract VoxelShape[] setShapeByAge();

    public abstract int setGrowChance(BlockState var1, BlockGetter var2, BlockPos var3);

    public void m_213898_(@Nonnull BlockState state, @Nonnull ServerLevel level, @Nonnull BlockPos pos, @Nonnull RandomSource random) {
        super.m_213897_(state, level, pos, random);
        if (level.m_45524_(pos.m_7494_(), 0) < 6 || !level.isAreaLoaded(pos, 1)) {
            return;
        }
        if (!ForgeHooks.onCropsGrowPre((Level)level, (BlockPos)pos, (BlockState)state, (random.m_188503_(this.setGrowChance(state, (BlockGetter)level, pos)) == 0 ? 1 : 0) != 0)) {
            return;
        }
        if (this.isTop(state)) {
            int topAge = (Integer)state.m_61143_((Property)AGE);
            if (topAge >= 7) {
                return;
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(topAge + 1)));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        } else {
            int age = (Integer)state.m_61143_((Property)AGE);
            if (age >= this.bottomMaxAge) {
                if (!level.m_46859_(pos.m_7494_())) {
                    return;
                }
                level.m_46597_(pos.m_7494_(), (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(this.bottomMaxAge + 1))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GROW_PLACED, (Comparable)Boolean.valueOf(true)));
                return;
            }
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)AGE, (Comparable)Integer.valueOf(age + 1)));
            ForgeHooks.onCropsGrowPost((Level)level, (BlockPos)pos, (BlockState)state);
        }
    }

    public boolean m_7370_(@Nonnull LevelReader levelReader, @Nonnull BlockPos blockPos, @Nonnull BlockState blockState, boolean var4) {
        if (this.isTop(blockState)) {
            return (Integer)blockState.m_61143_((Property)AGE) < 7;
        }
        BlockState stateAbove = levelReader.m_8055_(blockPos.m_7494_());
        return stateAbove.m_60734_() == this ? (Integer)stateAbove.m_61143_((Property)AGE) != 7 : (Integer)blockState.m_61143_((Property)AGE) <= this.bottomMaxAge;
    }

    public boolean m_214167_(@Nonnull Level level, @Nonnull RandomSource randomSource, @Nonnull BlockPos blockPos, @Nonnull BlockState blockState) {
        return true;
    }

    public void m_214148_(@Nonnull ServerLevel serverLevel, @Nonnull RandomSource randomSource, @Nonnull BlockPos blockPos, @Nonnull BlockState blockState) {
        int bottomAge = (Integer)blockState.m_61143_((Property)AGE);
        int newBottomAge = Math.min(bottomAge + Mth.m_216271_((RandomSource)randomSource, (int)1, (int)3), this.bottomMaxAge);
        if (!this.isTop(blockState) && bottomAge < this.bottomMaxAge) {
            serverLevel.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newBottomAge)));
        } else if (this.isTop(blockState)) {
            int topAge = (Integer)blockState.m_61143_((Property)AGE);
            int newTopAge = Math.min(topAge + Mth.m_216271_((RandomSource)randomSource, (int)1, (int)3), 7);
            serverLevel.m_46597_(blockPos, (BlockState)blockState.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newTopAge)));
        } else {
            BlockPos posAbove = blockPos.m_7494_();
            BlockState stateAbove = serverLevel.m_8055_(posAbove);
            if (serverLevel.m_46859_(posAbove)) {
                serverLevel.m_46597_(posAbove, (BlockState)((BlockState)((BlockState)this.m_49966_().m_61124_((Property)AGE, (Comparable)Integer.valueOf(this.bottomMaxAge + 1))).m_61124_((Property)BlockStateProperties.f_61362_, (Comparable)Boolean.valueOf(false))).m_61124_((Property)GROW_PLACED, (Comparable)Boolean.valueOf(true)));
            } else if (stateAbove.m_60734_() == this) {
                int newTopAge = Math.min(Math.max((Integer)stateAbove.m_61143_((Property)AGE), this.bottomMaxAge) + Mth.m_216271_((RandomSource)randomSource, (int)1, (int)(7 - this.bottomMaxAge)), 7);
                serverLevel.m_46597_(posAbove, (BlockState)stateAbove.m_61124_((Property)AGE, (Comparable)Integer.valueOf(newTopAge)));
            }
        }
    }

    @Nonnull
    public VoxelShape m_5940_(@Nonnull BlockState state, @Nonnull BlockGetter level, @Nonnull BlockPos pos, @Nonnull CollisionContext context) {
        return this.setShapeByAge()[(Integer)state.m_61143_((Property)AGE)];
    }

    public boolean m_7898_(@Nonnull BlockState state, LevelReader level, @Nonnull BlockPos pos) {
        FluidState fluid = level.m_6425_(pos);
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        if (stateBelow.m_60734_() instanceof TallWaterloggedCropBlock && ((Boolean)state.m_61143_((Property)GROW_PLACED)).booleanValue()) {
            return !this.isTop(stateBelow);
        }
        return super.m_7898_(state, level, pos) && fluid.m_205070_(FluidTags.f_13131_) && fluid.m_76170_();
    }

    protected void m_7926_(@Nonnull StateDefinition.Builder<Block, BlockState> builder) {
        super.m_7926_(builder);
        builder.m_61104_(new Property[]{AGE, BlockStateProperties.f_61362_, GROW_PLACED});
    }

    @Nonnull
    public FluidState m_5888_(BlockState state) {
        return (Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_) != false ? Fluids.f_76193_.m_76068_(false) : super.m_5888_(state);
    }

    @Nonnull
    public BlockState m_7417_(@Nonnull BlockState state, @Nonnull Direction facing, @Nonnull BlockState facingState, @Nonnull LevelAccessor level, @Nonnull BlockPos currentPos, @Nonnull BlockPos facingPos) {
        if (((Boolean)state.m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
            level.m_186469_(currentPos, (Fluid)Fluids.f_76193_, Fluids.f_76193_.m_6718_((LevelReader)level));
        }
        return super.m_7417_(state, facing, facingState, level, currentPos, facingPos);
    }

    public boolean isTop(BlockState state) {
        return (Integer)state.m_61143_((Property)AGE) > this.bottomMaxAge;
    }
}

