/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.entity;

import com.mojang.datafixers.util.Pair;
import java.util.List;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mangopill.customized.common.FoodValue;
import mangopill.customized.common.block.AbstractPlateBlock;
import mangopill.customized.common.block.state.PlateState;
import mangopill.customized.common.item.AbstractPlateItem;
import mangopill.customized.common.util.CreateItemStackHandler;
import mangopill.customized.common.util.ModItemStackHandlerHelper;
import mangopill.customized.common.util.PlateComponentUtil;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.effect.MobEffects;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractPlateBlockEntity
extends BlockEntity
implements CreateItemStackHandler {
    private final int ingredientInput;
    private final int seasoningInput;
    private static final int SPICE_INPUT = 1;
    private final int allSlot;
    private final ItemStackHandler itemStackHandler;
    private final ItemStackHandler initialItemStackHandler;
    private FoodProperties foodProperty;
    private int consumptionCount;
    private int consumptionCountTotal;

    public AbstractPlateBlockEntity(BlockEntityType<? extends AbstractPlateBlockEntity> type, BlockPos pos, BlockState blockState, int ingredientInput, int seasoningInput) {
        super(type, pos, blockState);
        this.ingredientInput = ingredientInput;
        this.seasoningInput = seasoningInput;
        this.foodProperty = FoodValue.NULL;
        this.allSlot = ingredientInput + seasoningInput + 1;
        this.itemStackHandler = this.createItemStackHandler(this.allSlot);
        this.initialItemStackHandler = this.createItemStackHandler(this.allSlot);
    }

    @Override
    public void itemStackHandlerChanged() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public boolean hasInput() {
        return ModItemStackHandlerHelper.hasInput(this.itemStackHandler, this.allSlot);
    }

    public List<ItemStack> getItemStackListInPlate(boolean includeSeasoningAndSpice) {
        return includeSeasoningAndSpice ? ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.allSlot) : ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.ingredientInput);
    }

    public void eatFood(@Nonnull Level level, @Nonnull Player player, @Nonnull BlockState state, @Nonnull BlockPos pos) {
        if (this.consumptionCount >= 1) {
            level.m_5594_(null, pos, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
            player.m_36324_().m_38707_(this.foodProperty.m_38744_(), this.foodProperty.m_38745_());
            AbstractPlateBlockEntity.addEffect((LivingEntity)player, this.foodProperty);
            AbstractPlateItem.plateAdvancement((LivingEntity)player, this.foodProperty);
            if (this.consumptionCount > 1) {
                ModItemStackHandlerHelper.reduceItemStackCountByDivision(this.itemStackHandler, this.initialItemStackHandler, this.consumptionCountTotal);
            } else {
                ModItemStackHandlerHelper.clearAllSlot(this.itemStackHandler);
                ModItemStackHandlerHelper.clearAllSlot(this.initialItemStackHandler);
                this.clearFoodPropertyAndCountTotal();
                level.m_46597_(pos, (BlockState)state.m_61124_(AbstractPlateBlock.DRIVE, (Comparable)((Object)PlateState.WITHOUT_DRIVE)));
            }
            --this.consumptionCount;
            player.m_146850_(GameEvent.f_157806_);
            this.itemStackHandlerChanged();
        }
    }

    public static void addEffect(LivingEntity livingEntity, FoodProperties foodProperties) {
        if (!livingEntity.m_9236_().m_5776_()) {
            for (Pair possibleeffect : foodProperties.m_38749_()) {
                if (!(livingEntity.m_217043_().m_188501_() < ((Float)possibleeffect.getSecond()).floatValue())) continue;
                livingEntity.m_7292_((MobEffectInstance)possibleeffect.getFirst());
            }
            if (!foodProperties.m_38747_()) {
                livingEntity.m_7292_(new MobEffectInstance(MobEffects.f_19604_, 500, 1));
            }
        }
    }

    public void clearFoodPropertyAndCountTotal() {
        this.foodProperty = FoodValue.NULL;
        this.consumptionCountTotal = 0;
    }

    @Nonnull
    public ItemStack getCloneItemStack(ItemStack stack) {
        ItemStack itemStack = new ItemStack((ItemLike)stack.m_41720_(), stack.m_41613_());
        this.m_6596_();
        itemStack.m_41751_(this.m_5995_());
        return itemStack;
    }

    public void setFoodProperty(@Nullable FoodProperties foodProperty) {
        this.foodProperty = foodProperty != null ? foodProperty : FoodValue.NULL;
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.consumptionCount = compound.m_128451_("ConsumptionCount");
        this.consumptionCountTotal = compound.m_128451_("ConsumptionCountTotal");
        this.itemStackHandler.deserializeNBT(compound.m_128469_("ItemStackHandler"));
        this.initialItemStackHandler.deserializeNBT(compound.m_128469_("InitialItemStackHandler"));
        this.setFoodProperty(PlateComponentUtil.deserializeFoodProperties(compound.m_128469_("FoodProperty")));
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("ConsumptionCount", this.consumptionCount);
        compound.m_128405_("ConsumptionCountTotal", this.consumptionCountTotal);
        compound.m_128365_("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT());
        compound.m_128365_("InitialItemStackHandler", (Tag)this.initialItemStackHandler.serializeNBT());
        compound.m_128365_("FoodProperty", (Tag)PlateComponentUtil.serializeFoodProperties(this.foodProperty));
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        super.m_183515_(tag);
        tag.m_128405_("ConsumptionCount", this.consumptionCount);
        tag.m_128405_("ConsumptionCountTotal", this.consumptionCountTotal);
        tag.m_128365_("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT());
        tag.m_128365_("InitialItemStackHandler", (Tag)this.initialItemStackHandler.serializeNBT());
        tag.m_128365_("FoodProperty", (Tag)PlateComponentUtil.serializeFoodProperties(this.foodProperty));
        return tag;
    }

    public int getIngredientInput() {
        return this.ingredientInput;
    }

    public int getSeasoningInput() {
        return this.seasoningInput;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public ItemStackHandler getInitialItemStackHandler() {
        return this.initialItemStackHandler;
    }

    public FoodProperties getFoodProperty() {
        return this.foodProperty;
    }

    public int getConsumptionCountTotal() {
        return this.consumptionCountTotal;
    }

    public int getConsumptionCount() {
        return this.consumptionCount;
    }
}

