/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mangopill.customized.common.CustomizedConfig;
import mangopill.customized.common.block.AbstractPotBlock;
import mangopill.customized.common.block.handler.PotFluidHandler;
import mangopill.customized.common.block.handler.PotItemHandler;
import mangopill.customized.common.block.state.PotState;
import mangopill.customized.common.recipe.AbstractPotRecipe;
import mangopill.customized.common.registry.ModAdvancementRegistry;
import mangopill.customized.common.tag.ModTag;
import mangopill.customized.common.util.CreateItemStackHandler;
import mangopill.customized.common.util.ModItemStackHandlerHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.world.Container;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.item.ItemEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.CampfireCookingRecipe;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public abstract class AbstractPotBlockEntity
extends BlockEntity
implements CreateItemStackHandler {
    private final int ingredientInput;
    private final int seasoningInput;
    private static final int SPICE_INPUT = 1;
    private static final int OUTPUT = 1;
    private final int allSlot;
    private final ItemStackHandler itemStackHandler;
    private final LazyOptional<IItemHandler> inputHandler;
    private final LazyOptional<IItemHandler> outputHandler;
    private final LazyOptional<IFluidHandler> fluidHandler;
    private final RecipeManager.CachedCheck<RecipeWrapper, ? extends AbstractPotRecipe> potCheck;
    private final RecipeManager.CachedCheck<Container, CampfireCookingRecipe> campfireCheck;
    private int cookingTime;
    private int cookingCompletionTime;

    public AbstractPotBlockEntity(BlockEntityType<? extends AbstractPotBlockEntity> type, BlockPos pos, BlockState blockState, int ingredientCount, int seasoningCount, RecipeManager.CachedCheck<RecipeWrapper, ? extends AbstractPotRecipe> potCheck) {
        super(type, pos, blockState);
        this.ingredientInput = ingredientCount;
        this.seasoningInput = seasoningCount;
        this.allSlot = this.ingredientInput + this.seasoningInput + 1 + 1;
        this.campfireCheck = RecipeManager.m_220267_((RecipeType)RecipeType.f_44111_);
        this.itemStackHandler = this.createItemStackHandler(this.allSlot);
        this.inputHandler = LazyOptional.of(() -> new PotItemHandler((IItemHandler)this.itemStackHandler, Direction.UP, ingredientCount, seasoningCount));
        this.outputHandler = LazyOptional.of(() -> new PotItemHandler((IItemHandler)this.itemStackHandler, Direction.DOWN, ingredientCount, seasoningCount));
        this.fluidHandler = LazyOptional.of(() -> new PotFluidHandler(this.f_58857_, pos));
        this.potCheck = potCheck;
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    @Override
    public void itemStackHandlerChanged() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, AbstractPotBlockEntity potBlockEntity) {
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)potBlockEntity.itemStackHandler);
        Optional<? extends AbstractPotRecipe> potMatchRecipe = potBlockEntity.getPotMatchRecipe(wrapper);
        if (!potBlockEntity.isHeated(level, pos)) {
            potBlockEntity.clearCookingTime();
            return;
        }
        if (potMatchRecipe.isPresent() && potBlockEntity.canCookRecipe(potMatchRecipe.get(), wrapper)) {
            if (!((Boolean)CustomizedConfig.RECIPE_COOKING.get()).booleanValue()) {
                return;
            }
            potBlockEntity.cookRecipe(potMatchRecipe.get(), pos, state);
        } else {
            if (!((Boolean)CustomizedConfig.CUSTOM_COOKING.get()).booleanValue()) {
                return;
            }
            potBlockEntity.cookCustomized(level, pos, state);
        }
    }

    public static void animationTick(Level level, BlockPos pos, BlockState state, AbstractPotBlockEntity potBlockEntity) {
        if (potBlockEntity.isHeated(level, pos)) {
            potBlockEntity.particleTick(level, pos, potBlockEntity);
        }
    }

    public abstract void particleTick(Level var1, BlockPos var2, AbstractPotBlockEntity var3);

    protected Optional<? extends AbstractPotRecipe> getPotMatchRecipe(RecipeWrapper recipeWrapper) {
        return this.hasInput() && this.f_58857_ != null ? this.potCheck.m_213657_((Container)recipeWrapper, this.f_58857_) : Optional.empty();
    }

    protected Optional<CampfireCookingRecipe> getCampfireMatchRecipe(ItemStack stack) {
        return this.hasInput() && this.f_58857_ != null ? this.campfireCheck.m_213657_((Container)new SimpleContainer(new ItemStack[]{stack}), this.f_58857_) : Optional.empty();
    }

    protected boolean hasInput() {
        return ModItemStackHandlerHelper.hasInput(this.itemStackHandler, this.ingredientInput + this.seasoningInput + 1);
    }

    protected boolean canCooking() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.hasInput();
    }

    protected boolean canCookRecipe(AbstractPotRecipe recipe, RecipeWrapper recipeWrapper) {
        if (!this.canCooking()) {
            return false;
        }
        if (this.f_58857_ == null) {
            return false;
        }
        ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_());
        if (resultStack.m_41619_()) {
            return false;
        }
        if (!recipe.matches(recipeWrapper, this.f_58857_)) {
            return false;
        }
        ItemStack stackInSlot = this.itemStackHandler.getStackInSlot(this.ingredientInput + this.seasoningInput + 1);
        if (stackInSlot.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_41656_((ItemStack)stackInSlot, (ItemStack)resultStack)) {
            return false;
        }
        return stackInSlot.m_41613_() + resultStack.m_41613_() <= this.itemStackHandler.getSlotLimit(this.ingredientInput + this.seasoningInput + 1);
    }

    protected <T extends AbstractPotRecipe> void cookRecipe(T recipe, BlockPos pos, BlockState state) {
        ++this.cookingTime;
        this.getRecipeCookingCompletionTime(recipe);
        this.lidAccelerate(state);
        if (this.cookingTime < this.cookingCompletionTime) {
            return;
        }
        if (this.f_58857_ == null) {
            return;
        }
        ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_();
        ItemStack stackInSlot = this.itemStackHandler.getStackInSlot(this.ingredientInput + this.seasoningInput + 1);
        if (stackInSlot.m_41619_()) {
            this.itemStackHandler.setStackInSlot(this.ingredientInput + this.seasoningInput + 1, resultStack);
        } else if (ItemStack.m_41656_((ItemStack)stackInSlot, (ItemStack)resultStack)) {
            stackInSlot.m_41769_(resultStack.m_41613_());
        }
        for (int i = 0; i < this.ingredientInput + this.seasoningInput + 1; ++i) {
            ItemStack slotStack = this.itemStackHandler.getStackInSlot(i);
            if (slotStack.hasCraftingRemainingItem()) {
                AbstractPotBlockEntity.spawnRemainderItem(slotStack.getCraftingRemainingItem(), this.m_58900_(), this.f_58858_, this.f_58857_);
            }
            if (slotStack.m_41619_()) continue;
            slotStack.m_41774_(1);
        }
        this.clearCookingTime();
        this.itemStackHandlerChanged();
    }

    protected void cookCustomized(Level level, BlockPos pos, BlockState state) {
        for (int i = 0; i < this.ingredientInput; ++i) {
            ItemStack stackInSlot = this.itemStackHandler.getStackInSlot(i);
            Optional<CampfireCookingRecipe> recipe = this.getCampfireMatchRecipe(stackInSlot);
            if (recipe.isEmpty()) continue;
            ++this.cookingTime;
            this.getCustomizedCookingCompletionTime();
            this.lidAccelerate(state);
            if (this.cookingTime < this.cookingCompletionTime) {
                return;
            }
            ItemStack resultStack = recipe.get().m_5874_((Container)new SimpleContainer(new ItemStack[]{stackInSlot}), level.m_9598_()).m_41777_();
            resultStack.m_41764_(stackInSlot.m_41613_());
            this.itemStackHandler.setStackInSlot(i, resultStack);
        }
        this.clearCookingTime();
        this.itemStackHandlerChanged();
    }

    public void takeOutItem(Level level, BlockState state, BlockPos pos) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        double x = (double)pos.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
        double y = (double)pos.m_123342_() + 0.7;
        double z = (double)pos.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
        for (int i = 0; i < this.ingredientInput + this.seasoningInput + 1; ++i) {
            ItemStack stackInSlot = this.getItemStackHandler().getStackInSlot(i);
            if (stackInSlot.m_41619_()) continue;
            ItemEntity itemEntity = new ItemEntity(level, x, y, z, stackInSlot.m_41777_());
            itemEntity.m_20334_((double)((float)direction.m_122429_() * -0.1f), (double)0.3f, (double)((float)direction.m_122431_() * -0.1f));
            level.m_7967_((Entity)itemEntity);
            stackInSlot.m_278832_();
        }
        this.itemStackHandlerChanged();
    }

    public void insertItem(ItemStack itemStackInHand) {
        ModItemStackHandlerHelper.insertItem(itemStackInHand, this.itemStackHandler, this.ingredientInput, this.seasoningInput, 1);
        this.itemStackHandlerChanged();
    }

    public void getCustomizedCookingCompletionTime() {
        int time = 100;
        for (int i = 0; i < this.ingredientInput; ++i) {
            time += this.itemStackHandler.getStackInSlot(i).m_41613_() * 20;
        }
        this.cookingCompletionTime = time;
    }

    public <T extends AbstractPotRecipe> void getRecipeCookingCompletionTime(T holder) {
        this.cookingCompletionTime = holder.getCookingTime();
    }

    protected static void spawnRemainderItem(ItemStack remainderStack, BlockState state, BlockPos pos, Level level) {
        Direction direction = (Direction)state.m_61143_((Property)BlockStateProperties.f_61374_);
        double x = (double)pos.m_123341_() + 0.5 + (double)direction.m_122429_() * 0.25;
        double y = (double)pos.m_123342_() + 0.7;
        double z = (double)pos.m_123343_() + 0.5 + (double)direction.m_122431_() * 0.25;
        if (level != null) {
            ItemEntity entity = new ItemEntity(level, x, y, z, remainderStack);
            entity.m_20334_((double)((float)direction.m_122429_() * 0.1f), (double)0.3f, (double)((float)direction.m_122431_() * 0.1f));
            level.m_7967_((Entity)entity);
        }
    }

    public boolean isHeated() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.isHeated(this.f_58857_, this.f_58858_);
    }

    protected boolean isHeated(Level level, BlockPos pos) {
        BlockState stateBelow = level.m_8055_(pos.m_7495_());
        if (!stateBelow.m_204336_(ModTag.HEAT_SOURCE)) {
            return false;
        }
        if (stateBelow.m_61138_((Property)BlockStateProperties.f_61443_)) {
            return (Boolean)stateBelow.m_61143_((Property)BlockStateProperties.f_61443_);
        }
        return true;
    }

    protected void clearCookingTime() {
        if (this.cookingTime != 0) {
            this.cookingTime = 0;
        }
    }

    public void stirFryAccelerate(ItemStack itemStackInHand, LivingEntity entity, InteractionHand hand) {
        if (!itemStackInHand.m_204117_(ModTag.SPATULA) || this.cookingTime == 0) {
            return;
        }
        this.cookingTime += 10;
        if (entity instanceof Player) {
            Player player = (Player)entity;
            itemStackInHand.m_41622_(1, (LivingEntity)player, p -> player.m_21190_(hand));
        }
    }

    public void lidAccelerate(BlockState state) {
        if (((PotState)((Object)state.m_61143_(AbstractPotBlock.LID))).equals((Object)PotState.WITH_LID)) {
            ++this.cookingTime;
        }
    }

    public List<ItemStack> getItemStackListInPot(boolean includeOutput, boolean includeSeasoningAndSpice) {
        if (includeOutput) {
            if (includeSeasoningAndSpice) {
                return ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.allSlot);
            }
            List<ItemStack> stackList = ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.ingredientInput);
            stackList.addAll(ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, this.ingredientInput + this.seasoningInput + 1, this.allSlot));
            return stackList;
        }
        if (includeSeasoningAndSpice) {
            return ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.ingredientInput + this.seasoningInput + 1);
        }
        return ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.ingredientInput);
    }

    public void getOutputInPot(ItemStack itemStackInHand, Player player) {
        ModItemStackHandlerHelper.getOutputItem(itemStackInHand, player, this.itemStackHandler, this.ingredientInput + this.seasoningInput + 1);
        if (player instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)player;
            ModAdvancementRegistry.GET_FAMOUS_DISH.trigger(serverPlayer);
        }
        this.itemStackHandlerChanged();
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.itemStackHandler.deserializeNBT(compound.m_128469_("ItemStackHandler"));
        this.cookingTime = compound.m_128451_("CookingTime");
        this.cookingCompletionTime = compound.m_128451_("CookingCompletionTime");
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("CookingTime", this.cookingTime);
        compound.m_128405_("CookingCompletionTime", this.cookingCompletionTime);
        compound.m_128365_("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT());
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        super.m_183515_(tag);
        tag.m_128365_("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT());
        return tag;
    }

    public int getIngredientInput() {
        return this.ingredientInput;
    }

    public int getSeasoningInput() {
        return this.seasoningInput;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public LazyOptional<IItemHandler> getInputHandler() {
        return this.inputHandler;
    }

    public LazyOptional<IItemHandler> getOutputHandler() {
        return this.outputHandler;
    }

    public LazyOptional<IFluidHandler> getFluidHandler() {
        return this.fluidHandler;
    }

    public RecipeManager.CachedCheck<RecipeWrapper, ? extends AbstractPotRecipe> getPotCheck() {
        return this.potCheck;
    }

    public RecipeManager.CachedCheck<Container, CampfireCookingRecipe> getCampfireCheck() {
        return this.campfireCheck;
    }
}

