/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.entity;

import java.util.List;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mangopill.customized.common.block.BrewingBarrelBlock;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.handler.BrewingBarrelItemHandler;
import mangopill.customized.common.recipe.BrewingBarrelRecipe;
import mangopill.customized.common.registry.ModAdvancementRegistry;
import mangopill.customized.common.registry.ModBlockEntityTypeRegistry;
import mangopill.customized.common.registry.ModRecipeRegistry;
import mangopill.customized.common.util.CreateItemStackHandler;
import mangopill.customized.common.util.ModItemStackHandlerHelper;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.protocol.game.ClientboundBlockEntityDataPacket;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeManager;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class BrewingBarrelBlockEntity
extends BlockEntity
implements CreateItemStackHandler {
    private final int inputSlot;
    private final int outputSlot;
    private final int allSlot;
    private final RecipeManager.CachedCheck<RecipeWrapper, BrewingBarrelRecipe> check;
    private final ItemStackHandler itemStackHandler;
    private final LazyOptional<IItemHandler> inputHandler;
    private final LazyOptional<IItemHandler> outputHandler;
    private ItemStack containerItem;
    private int cookingTime;
    private int cookingCompletionTime;

    public BrewingBarrelBlockEntity(BlockPos pos, BlockState blockState) {
        super(ModBlockEntityTypeRegistry.BREWING_BARREL.get(), pos, blockState);
        this.inputSlot = 4;
        this.outputSlot = 1;
        this.allSlot = this.inputSlot + this.outputSlot;
        this.itemStackHandler = this.createItemStackHandler(this.allSlot);
        this.inputHandler = LazyOptional.of(() -> new BrewingBarrelItemHandler((IItemHandler)this.itemStackHandler, Direction.UP, this.inputSlot));
        this.outputHandler = LazyOptional.of(() -> new BrewingBarrelItemHandler((IItemHandler)this.itemStackHandler, Direction.DOWN, this.inputSlot));
        this.containerItem = ItemStack.f_41583_;
        this.check = RecipeManager.m_220267_(ModRecipeRegistry.BREWING_BARREL.get());
    }

    @Nonnull
    public <T> LazyOptional<T> getCapability(@Nonnull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            if (side == Direction.UP) {
                return this.inputHandler.cast();
            }
            return this.outputHandler.cast();
        }
        return super.getCapability(cap, side);
    }

    public static void cookingTick(Level level, BlockPos pos, BlockState state, BrewingBarrelBlockEntity barrelBlockEntity) {
        RecipeWrapper wrapper = new RecipeWrapper((IItemHandlerModifiable)barrelBlockEntity.itemStackHandler);
        Optional<BrewingBarrelRecipe> barrelMatchRecipe = barrelBlockEntity.getBrewingBarrelMatchRecipe(wrapper);
        if (barrelMatchRecipe.isPresent() && barrelBlockEntity.canCookRecipe(barrelMatchRecipe.get(), wrapper)) {
            barrelBlockEntity.cookRecipe(level, barrelMatchRecipe.get(), pos, state, barrelBlockEntity);
        } else {
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BrewingBarrelBlock.PROGRESS, (Comparable)Integer.valueOf(0)));
        }
    }

    protected void cookRecipe(Level level, BrewingBarrelRecipe recipe, BlockPos pos, BlockState state, BrewingBarrelBlockEntity barrelBlockEntity) {
        ++this.cookingTime;
        this.getRecipeCookingCompletionTime(recipe);
        if (this.f_58857_ == null) {
            return;
        }
        if (this.cookingTime < this.cookingCompletionTime) {
            return;
        }
        Block block = level.m_8055_(pos).m_60734_();
        if (block instanceof BrewingBarrelBlock) {
            if ((Integer)state.m_61143_((Property)BrewingBarrelBlock.PROGRESS) < 12) {
                level.m_46597_(pos, (BlockState)state.m_61124_((Property)BrewingBarrelBlock.PROGRESS, (Comparable)Integer.valueOf((Integer)state.m_61143_((Property)BrewingBarrelBlock.PROGRESS) + 1)));
                barrelBlockEntity.clearCookingTime();
                return;
            }
            ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_()).m_41777_();
            ItemStack stackInSlot = this.itemStackHandler.getStackInSlot(this.inputSlot);
            if (stackInSlot.m_41619_()) {
                this.itemStackHandler.setStackInSlot(this.inputSlot, resultStack);
            } else if (ItemStack.m_150942_((ItemStack)stackInSlot, (ItemStack)resultStack)) {
                stackInSlot.m_41769_(resultStack.m_41613_());
            }
            for (int i = 0; i < this.inputSlot; ++i) {
                ItemStack slotStack = this.itemStackHandler.getStackInSlot(i);
                if (slotStack.hasCraftingRemainingItem()) {
                    AbstractPotBlockEntity.spawnRemainderItem(slotStack.getCraftingRemainingItem(), this.m_58900_(), this.f_58858_, level);
                }
                if (slotStack.m_41619_()) continue;
                slotStack.m_41774_(1);
            }
            this.containerItem = recipe.getContainerItem().m_43908_()[0];
            this.clearCookingTime();
            level.m_46597_(pos, (BlockState)state.m_61124_((Property)BrewingBarrelBlock.PROGRESS, (Comparable)Integer.valueOf(0)));
            this.itemStackHandlerChanged();
        }
    }

    protected boolean canCookRecipe(BrewingBarrelRecipe recipe, RecipeWrapper recipeWrapper) {
        if (!this.canCooking()) {
            return false;
        }
        if (this.f_58857_ == null) {
            return false;
        }
        ItemStack resultStack = recipe.m_8043_(this.f_58857_.m_9598_());
        if (resultStack.m_41619_()) {
            return false;
        }
        if (!recipe.matches(recipeWrapper, this.f_58857_)) {
            return false;
        }
        ItemStack stackInSlot = this.itemStackHandler.getStackInSlot(this.inputSlot);
        if (stackInSlot.m_41619_()) {
            return true;
        }
        if (!ItemStack.m_41656_((ItemStack)stackInSlot, (ItemStack)resultStack)) {
            return false;
        }
        return stackInSlot.m_41613_() + resultStack.m_41613_() <= this.itemStackHandler.getSlotLimit(this.inputSlot);
    }

    protected Optional<BrewingBarrelRecipe> getBrewingBarrelMatchRecipe(RecipeWrapper recipeWrapper) {
        return this.hasInput() && this.f_58857_ != null ? this.check.m_213657_((Container)recipeWrapper, this.f_58857_) : Optional.empty();
    }

    public void interact(ItemStack itemStackInHand, Player player, Level level, BlockPos pos) {
        if (itemStackInHand.m_41619_() && player.m_6144_()) {
            this.getItemStackListInBrewingBarrel(false).forEach(itemStack -> {
                if (!player.m_150109_().m_36054_(itemStack)) {
                    player.m_36176_(itemStack, false);
                }
            });
            level.m_5594_(null, pos, SoundEvents.f_11724_, SoundSource.BLOCKS, 0.8f, 1.0f);
            this.itemStackHandlerChanged();
            return;
        }
        if (this.canOutput(itemStackInHand)) {
            ItemStack outputItem = this.getOutputItem();
            if (outputItem == null || outputItem.m_41619_()) {
                return;
            }
            ModItemStackHandlerHelper.getOutputItem(itemStackInHand, player, this.itemStackHandler, this.inputSlot);
            level.m_5594_(null, pos, SoundEvents.f_11724_, SoundSource.BLOCKS, 0.8f, 1.0f);
            if (player instanceof ServerPlayer) {
                ServerPlayer serverPlayer = (ServerPlayer)player;
                ModAdvancementRegistry.USE_BREWING_BARREL.trigger(serverPlayer);
            }
            this.itemStackHandlerChanged();
        } else {
            this.insertItem(itemStackInHand);
            level.m_5594_(null, pos, SoundEvents.f_11725_, SoundSource.BLOCKS, 0.8f, 1.0f);
            this.itemStackHandlerChanged();
        }
    }

    public void insertItem(ItemStack itemStackInHand) {
        ModItemStackHandlerHelper.fillInItem(this.itemStackHandler, itemStackInHand, 0, this.inputSlot);
        this.itemStackHandlerChanged();
    }

    @Nullable
    public ItemStack getOutputItem() {
        return this.itemStackHandler.getStackInSlot(this.inputSlot);
    }

    public boolean canOutput(ItemStack itemStackInHand) {
        return !this.containerItem.m_41619_() && ItemStack.m_41656_((ItemStack)this.containerItem, (ItemStack)itemStackInHand);
    }

    protected boolean hasInput() {
        return ModItemStackHandlerHelper.hasInput(this.itemStackHandler, this.inputSlot);
    }

    public List<ItemStack> getItemStackListInBrewingBarrel(boolean includeOutput) {
        if (includeOutput) {
            return ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.allSlot);
        }
        return ModItemStackHandlerHelper.getItemStackListInSlot(this.itemStackHandler, 0, this.inputSlot);
    }

    protected boolean canCooking() {
        if (this.f_58857_ == null) {
            return false;
        }
        return this.hasInput();
    }

    protected void clearCookingTime() {
        if (this.cookingTime >= this.cookingCompletionTime) {
            this.cookingTime = 0;
        }
    }

    public void getRecipeCookingCompletionTime(BrewingBarrelRecipe recipe) {
        this.cookingCompletionTime = recipe.getCookingTime();
    }

    @Override
    public void itemStackHandlerChanged() {
        super.m_6596_();
        if (this.f_58857_ != null) {
            this.f_58857_.m_7260_(this.m_58899_(), this.m_58900_(), this.m_58900_(), 2);
        }
    }

    @Nullable
    public ClientboundBlockEntityDataPacket getUpdatePacket() {
        return ClientboundBlockEntityDataPacket.m_195640_((BlockEntity)this);
    }

    public void m_142466_(@Nonnull CompoundTag compound) {
        super.m_142466_(compound);
        this.itemStackHandler.deserializeNBT(compound.m_128469_("ItemStackHandler"));
        this.containerItem = ItemStack.m_41712_((CompoundTag)compound.m_128469_("Container"));
        this.cookingTime = compound.m_128451_("CookingTime");
        this.cookingCompletionTime = compound.m_128451_("CookingCompletionTime");
    }

    public void m_183515_(@Nonnull CompoundTag compound) {
        super.m_183515_(compound);
        compound.m_128405_("CookingTime", this.cookingTime);
        compound.m_128405_("CookingCompletionTime", this.cookingCompletionTime);
        compound.m_128365_("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT());
        compound.m_128365_("Container", (Tag)this.containerItem.serializeNBT());
    }

    @Nonnull
    public CompoundTag m_5995_() {
        CompoundTag tag = new CompoundTag();
        super.m_183515_(tag);
        tag.m_128365_("ItemStackHandler", (Tag)this.itemStackHandler.serializeNBT());
        tag.m_128365_("Container", (Tag)this.containerItem.serializeNBT());
        return tag;
    }

    public int getInputSlot() {
        return this.inputSlot;
    }

    public int getOutputSlot() {
        return this.outputSlot;
    }

    public RecipeManager.CachedCheck<RecipeWrapper, BrewingBarrelRecipe> getCheck() {
        return this.check;
    }

    public ItemStackHandler getItemStackHandler() {
        return this.itemStackHandler;
    }

    public LazyOptional<IItemHandler> getInputHandler() {
        return this.inputHandler;
    }

    public LazyOptional<IItemHandler> getOutputHandler() {
        return this.outputHandler;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public int getCookingCompletionTime() {
        return this.cookingCompletionTime;
    }

    public ItemStack getContainerItem() {
        return this.containerItem;
    }
}

