/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.handler;

import javax.annotation.Nonnull;
import mangopill.customized.common.block.fluid.ModFluidContent;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

public abstract class ModIFluidHandler<T extends Comparable<T>, V extends T>
implements IFluidHandler {
    private final Level level;
    private final BlockPos pos;

    public ModIFluidHandler(Level level, BlockPos pos) {
        this.level = level;
        this.pos = pos;
    }

    protected abstract ModFluidContent<T, V> getContent();

    protected abstract ModFluidContent<T, V> getContentForFill();

    protected abstract boolean canInput();

    protected abstract boolean canOutput();

    protected void updateDriveState(IFluidHandler.FluidAction action, ModFluidContent<T, V> contents) {
        if (!action.execute()) {
            return;
        }
        if (this.canInput()) {
            BlockState blockState = this.getLevel().m_8055_(this.getPos());
            this.getLevel().m_46597_(this.getPos(), (BlockState)blockState.m_61124_(contents.getProperty(), contents.getValue()));
        }
    }

    protected void updateWithoutDriveState(IFluidHandler.FluidAction action, ModFluidContent<T, V> contents) {
        if (!action.execute()) {
            return;
        }
        if (this.canOutput()) {
            BlockState blockState = this.getLevel().m_8055_(this.getPos());
            this.getLevel().m_46597_(this.getPos(), (BlockState)blockState.m_61124_(contents.getProperty(), contents.getValue()));
        }
    }

    public int getTanks() {
        return 1;
    }

    @Nonnull
    public FluidStack getFluidInTank(int i) {
        ModFluidContent<T, V> contents = this.getContent();
        return new FluidStack(contents.getFluid(), contents.getTotalAmount());
    }

    public int getTankCapacity(int i) {
        ModFluidContent<T, V> contents = this.getContent();
        return contents.getTotalAmount();
    }

    public boolean isFluidValid(int i, @Nonnull FluidStack fluidStack) {
        return true;
    }

    public int fill(@Nonnull FluidStack fluidStack, @Nonnull IFluidHandler.FluidAction fluidAction) {
        if (fluidStack.isEmpty()) {
            return 0;
        }
        ModFluidContent<T, V> contents = this.getContentForFill();
        if (contents.getFluid() != Fluids.f_76191_ && !fluidStack.getFluid().equals(contents.getFluid())) {
            return 0;
        }
        int amount = fluidStack.getAmount();
        if (this.canInput()) {
            if (amount >= contents.getTotalAmount()) {
                this.updateDriveState(fluidAction, contents);
                return contents.getTotalAmount();
            }
            return 0;
        }
        return 0;
    }

    @Nonnull
    public FluidStack drain(@Nonnull FluidStack fluidStack, @Nonnull IFluidHandler.FluidAction fluidAction) {
        if (fluidStack.isEmpty()) {
            return FluidStack.EMPTY;
        }
        return fluidStack.getFluid() == this.getContent().getFluid() && fluidStack.getTag().m_128456_() && this.canOutput() && fluidStack.getAmount() >= this.getContent().getTotalAmount() ? this.drain(fluidAction) : FluidStack.EMPTY;
    }

    @Nonnull
    public FluidStack drain(int maxDrain, @Nonnull IFluidHandler.FluidAction fluidAction) {
        return maxDrain <= 0 ? FluidStack.EMPTY : this.drain(fluidAction);
    }

    protected FluidStack drain(IFluidHandler.FluidAction fluidAction) {
        ModFluidContent<T, V> content = this.getContent();
        this.updateWithoutDriveState(fluidAction, content);
        return new FluidStack(content.getFluid(), content.getTotalAmount());
    }

    public Level getLevel() {
        return this.level;
    }

    public BlockPos getPos() {
        return this.pos;
    }
}

