/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.block.handler;

import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mangopill.customized.common.tag.ModTag;
import net.minecraft.core.Direction;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.IItemHandler;

public class PotItemHandler
implements IItemHandler {
    private final int ingredientInput;
    private final int seasoningInput;
    private static final int SPICE_INPUT = 1;
    private final IItemHandler itemHandler;
    private final Direction side;

    public PotItemHandler(IItemHandler itemHandler, @Nullable Direction side, int ingredientCount, int seasoningCount) {
        this.itemHandler = itemHandler;
        this.ingredientInput = ingredientCount;
        this.seasoningInput = seasoningCount;
        this.side = side;
    }

    public int getSlots() {
        return this.itemHandler.getSlots();
    }

    @Nonnull
    public ItemStack getStackInSlot(int slot) {
        return this.itemHandler.getStackInSlot(slot);
    }

    @Nonnull
    public ItemStack insertItem(int slot, @Nonnull ItemStack stack, boolean simulate) {
        if (this.side == null || !this.side.equals((Object)Direction.UP)) {
            return stack;
        }
        if (stack.m_204117_(ModTag.SEASONING)) {
            return slot < this.seasoningInput + this.ingredientInput && slot >= this.ingredientInput ? this.itemHandler.insertItem(slot, stack, simulate) : stack;
        }
        if (stack.m_204117_(ModTag.FAMOUS_SPICE)) {
            return slot == this.seasoningInput + this.ingredientInput ? this.itemHandler.insertItem(slot, stack, simulate) : stack;
        }
        return slot < this.ingredientInput ? this.itemHandler.insertItem(slot, stack, simulate) : stack;
    }

    @Nonnull
    public ItemStack extractItem(int slot, int amount, boolean simulate) {
        if (this.side == null || this.side.equals((Object)Direction.UP)) {
            return slot < this.seasoningInput + this.ingredientInput + 1 ? this.itemHandler.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
        }
        return slot == this.seasoningInput + this.ingredientInput + 1 ? this.itemHandler.extractItem(slot, amount, simulate) : ItemStack.f_41583_;
    }

    public int getSlotLimit(int slot) {
        return this.itemHandler.getSlotLimit(slot);
    }

    public boolean isItemValid(int slot, @Nonnull ItemStack stack) {
        return this.itemHandler.isItemValid(slot, stack);
    }
}

