/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.item;

import java.util.List;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mangopill.customized.client.event.renderer.SoupBowlItemRenderer;
import mangopill.customized.common.FoodValue;
import mangopill.customized.common.block.AbstractPlateBlock;
import mangopill.customized.common.block.AbstractPotBlock;
import mangopill.customized.common.block.entity.AbstractPlateBlockEntity;
import mangopill.customized.common.block.entity.AbstractPotBlockEntity;
import mangopill.customized.common.block.state.PlateState;
import mangopill.customized.common.block.state.PotState;
import mangopill.customized.common.registry.ModAdvancementRegistry;
import mangopill.customized.common.util.ModItemStackHandlerHelper;
import mangopill.customized.common.util.PlateComponentUtil;
import mangopill.customized.common.util.PropertyValueUtil;
import net.minecraft.ChatFormatting;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.network.chat.MutableComponent;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.stats.Stats;
import net.minecraft.util.Mth;
import net.minecraft.util.StringUtil;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.item.context.BlockPlaceContext;
import net.minecraft.world.item.context.UseOnContext;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraftforge.client.extensions.common.IClientItemExtensions;
import net.minecraftforge.items.ItemStackHandler;

public abstract class AbstractPlateItem
extends BlockItem {
    private final int ingredientInput;
    private final int seasoningInput;
    private final boolean canInputDrive;

    public AbstractPlateItem(Block block, Item.Properties properties, int ingredientInput, int seasoningInput, boolean canInputDrive) {
        super(block, properties);
        this.ingredientInput = ingredientInput;
        this.seasoningInput = seasoningInput;
        this.canInputDrive = canInputDrive;
    }

    public void initializeClient(Consumer<IClientItemExtensions> consumer) {
        consumer.accept(new SoupBowlItemRenderer.SoupBowlItemExtensions());
    }

    public void m_7373_(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltipComponents, @Nonnull TooltipFlag tooltipFlag) {
        super.m_7373_(stack, level, tooltipComponents, tooltipFlag);
        tooltipComponents.add((Component)Component.m_237110_((String)"item_text.customized.consumption_count_total", (Object[])new Object[]{PlateComponentUtil.getConsumptionCountTotal(stack)}).m_130940_(ChatFormatting.GRAY));
        tooltipComponents.add((Component)Component.m_237110_((String)"item_text.customized.consumption_count", (Object[])new Object[]{PlateComponentUtil.getConsumptionCount(stack)}).m_130940_(ChatFormatting.GRAY));
        this.addItemStackTooltip(stack, tooltipComponents);
        if (this.hasInput(stack) && !PlateComponentUtil.getFoodProperty(stack).m_38747_()) {
            tooltipComponents.add((Component)Component.m_237115_((String)"item_text.customized.inedible").m_130940_(ChatFormatting.DARK_RED));
        }
        this.addEffectTooltip(stack, level, tooltipComponents);
    }

    @Nonnull
    public InteractionResultHolder<ItemStack> m_7203_(@Nonnull Level level, @Nonnull Player player, @Nonnull InteractionHand usedHand) {
        ItemStack itemstack = player.m_21120_(usedHand);
        if (level.f_46443_) {
            return InteractionResultHolder.m_19090_((Object)itemstack);
        }
        if (PlateComponentUtil.getConsumptionCount(itemstack) <= 0) {
            return InteractionResultHolder.m_19098_((Object)itemstack);
        }
        return super.m_7203_(level, player, usedHand);
    }

    @Nonnull
    public ItemStack m_5922_(@Nonnull ItemStack stack, @Nonnull Level level, @Nonnull LivingEntity livingEntity) {
        if (level.f_46443_) {
            return stack;
        }
        ItemStackHandler handler = PlateComponentUtil.getItemStackHandler(stack, null);
        ItemStackHandler initialHandler = PlateComponentUtil.getInitialItemStackHandler(stack);
        int consumptionCount = PlateComponentUtil.getConsumptionCount(stack);
        int consumptionCountTotal = PlateComponentUtil.getConsumptionCountTotal(stack);
        FoodProperties properties = PlateComponentUtil.getFoodProperty(stack);
        AbstractPlateItem.plateAdvancement(livingEntity, properties);
        if (consumptionCount >= 1) {
            level.m_6269_(null, (Entity)livingEntity, SoundEvents.f_11912_, SoundSource.PLAYERS, 0.8f, 0.8f);
            if (livingEntity instanceof ServerPlayer) {
                ServerPlayer player = (ServerPlayer)livingEntity;
                player.m_36246_(Stats.f_12982_.m_12902_((Object)stack.m_41720_()));
                player.m_36324_().m_38707_(properties.m_38744_(), properties.m_38745_());
            }
            AbstractPlateBlockEntity.addEffect(livingEntity, properties);
            if (consumptionCount > 1) {
                ModItemStackHandlerHelper.reduceItemStackCountByDivision(handler, initialHandler, consumptionCountTotal);
            } else {
                ModItemStackHandlerHelper.clearAllSlot(handler);
                ModItemStackHandlerHelper.clearAllSlot(initialHandler);
                PlateComponentUtil.setFoodProperty(stack, FoodValue.NULL);
                PlateComponentUtil.setConsumptionCountTotal(stack, 0);
            }
            PlateComponentUtil.setConsumptionCount(stack, --consumptionCount);
            PlateComponentUtil.setItemStackHandler(stack, handler);
            livingEntity.m_146850_(GameEvent.f_157806_);
        }
        return stack;
    }

    public static void plateAdvancement(@Nonnull LivingEntity livingEntity, FoodProperties properties) {
        if (livingEntity instanceof ServerPlayer) {
            ServerPlayer serverPlayer = (ServerPlayer)livingEntity;
            if (!properties.m_38747_()) {
                ModAdvancementRegistry.EAT_INEDIBLE_STEW.trigger(serverPlayer);
            } else {
                ModAdvancementRegistry.EAT_NORMAL_STEW.trigger(serverPlayer);
            }
        }
    }

    public FoodProperties getFoodProperties(@Nonnull ItemStack stack, @Nullable LivingEntity entity) {
        return PlateComponentUtil.getFoodProperty(stack);
    }

    @Nonnull
    public InteractionResult m_6225_(@Nonnull UseOnContext context) {
        Level level = context.m_43725_();
        ItemStack itemInHand = context.m_43722_();
        Player player = context.m_43723_();
        BlockPos pos = context.m_8083_();
        BlockEntity blockEntity = level.m_7702_(pos);
        AbstractPotBlockEntity potEntity = this.getPotEntity(level, pos);
        BlockState state = level.m_8055_(pos);
        if (level.f_46443_ || player == null) {
            return InteractionResult.SUCCESS;
        }
        if (blockEntity != null && blockEntity.equals(potEntity) && player.m_6144_()) {
            if (!((PotState)((Object)state.m_61143_(AbstractPotBlock.LID))).equals((Object)PotState.WITH_DRIVE) || !potEntity.isHeated()) {
                return InteractionResult.PASS;
            }
            return this.getInteractionResult(this.getPotEntity(level, pos), itemInHand, level, player);
        }
        return player.m_6144_() ? super.m_6225_(context) : this.m_7203_(level, player, context.m_43724_()).m_19089_();
    }

    @Nonnull
    public InteractionResult m_40576_(@Nonnull BlockPlaceContext context) {
        AbstractPlateBlockEntity plateBlockEntity;
        super.m_40576_(context);
        BlockPos pos = context.m_8083_();
        BlockState state = context.m_43725_().m_8055_(pos);
        Level level = context.m_43725_();
        BlockEntity blockEntity = level.m_7702_(pos);
        if (this.canInputDrive && blockEntity instanceof AbstractPlateBlockEntity && (plateBlockEntity = (AbstractPlateBlockEntity)blockEntity).hasInput()) {
            level.m_46597_(pos, (BlockState)state.m_61124_(AbstractPlateBlock.DRIVE, (Comparable)((Object)PlateState.WITH_DRIVE)));
        }
        return InteractionResult.m_19078_((boolean)level.f_46443_);
    }

    public boolean m_142522_(@Nonnull ItemStack stack) {
        return PlateComponentUtil.getConsumptionCountTotal(stack) > 0;
    }

    public int m_142158_(@Nonnull ItemStack stack) {
        int consumptionCount = PlateComponentUtil.getConsumptionCount(stack);
        int consumptionCountTotal = PlateComponentUtil.getConsumptionCountTotal(stack);
        return (int)Math.ceil((double)consumptionCount / (double)consumptionCountTotal * 13.0);
    }

    public int m_142159_(@Nonnull ItemStack stack) {
        return 0x5555FF;
    }

    @Nonnull
    public Component m_7626_(@Nonnull ItemStack stack) {
        List<ItemStack> stackList = this.getItemStackListInPlate(stack, false);
        List<ItemStack> topTwoItems = ModItemStackHandlerHelper.getTopTwoItemsByCount(stackList);
        if (topTwoItems.size() == 1) {
            ItemStack aStack = ModItemStackHandlerHelper.getTopTwoItemsByCount(stackList).get(0);
            return Component.m_237115_((String)"").m_7220_(aStack.m_41611_()).m_130946_(":").m_7220_((Component)Component.m_237115_((String)(this.m_5671_(stack) + "_food")));
        }
        if (topTwoItems.size() == 2) {
            ItemStack aStack = ModItemStackHandlerHelper.getTopTwoItemsByCount(stackList).get(0);
            ItemStack bStack = ModItemStackHandlerHelper.getTopTwoItemsByCount(stackList).get(1);
            return Component.m_237115_((String)"").m_7220_(aStack.m_41611_()).m_130946_("&").m_7220_(bStack.m_41611_()).m_130946_(":").m_7220_((Component)Component.m_237115_((String)(this.m_5671_(stack) + "_food")));
        }
        return Component.m_237115_((String)this.m_5671_(stack));
    }

    protected boolean m_7274_(@Nonnull BlockPos pos, Level level, @Nullable Player player, @Nonnull ItemStack stack, @Nonnull BlockState state) {
        BlockEntity blockEntity = level.m_7702_(pos);
        if (blockEntity instanceof AbstractPlateBlockEntity) {
            AbstractPlateBlockEntity plateEntity = (AbstractPlateBlockEntity)blockEntity;
            CompoundTag tag = stack.m_41784_();
            plateEntity.m_142466_(tag);
            plateEntity.m_6596_();
            return true;
        }
        return false;
    }

    private InteractionResult getInteractionResult(AbstractPotBlockEntity potBlockEntity, ItemStack itemInHand, Level level, Player player) {
        List<ItemStack> stackList = potBlockEntity.getItemStackListInPot(false, true);
        ItemStackHandler newItemStackHandler = this.copyItemStackHandlerByComponent(itemInHand);
        ModItemStackHandlerHelper.spawnUsingConvertsTo(player, stackList);
        stackList.forEach(itemStack -> this.insertItem((ItemStack)itemStack, newItemStackHandler));
        List<ItemStack> newStackList = ModItemStackHandlerHelper.getItemStackListInSlot(newItemStackHandler, 0, newItemStackHandler.getSlots());
        ItemStackHandler initialItemStackHandler = new ItemStackHandler(newItemStackHandler.getSlots());
        newStackList.forEach(itemStack -> this.insertItem(itemStack.m_41777_(), initialItemStackHandler));
        potBlockEntity.itemStackHandlerChanged();
        PlateComponentUtil.updateAll(itemInHand, newItemStackHandler, initialItemStackHandler, PropertyValueUtil.getFoodPropertyByPropertyValue(level, newStackList, true), ModItemStackHandlerHelper.getConsumptionCount(newStackList), ModItemStackHandlerHelper.getConsumptionCount(newStackList));
        return InteractionResult.SUCCESS;
    }

    public void insertItem(ItemStack stack, ItemStackHandler newItemStackHandler) {
        ModItemStackHandlerHelper.insertItem(stack, newItemStackHandler, this.ingredientInput, this.seasoningInput, 1);
    }

    public ItemStackHandler copyItemStackHandlerByComponent(ItemStack stack) {
        ItemStackHandler newItemStackHandler = new ItemStackHandler(PlateComponentUtil.getItemStackHandler(stack, null).getSlots());
        this.getItemStackListInPlate(stack, true).forEach(itemStack -> this.insertItem(itemStack.m_41777_(), newItemStackHandler));
        return newItemStackHandler;
    }

    public boolean hasInput(ItemStack stack) {
        return ModItemStackHandlerHelper.hasInput(PlateComponentUtil.getItemStackHandler(stack, null), PlateComponentUtil.getItemStackHandler(stack, null).getSlots());
    }

    public List<ItemStack> getItemStackListInPlate(ItemStack stack, boolean includeSeasoningAndSpice) {
        return includeSeasoningAndSpice ? ModItemStackHandlerHelper.getItemStackListInSlot(PlateComponentUtil.getItemStackHandler(stack, null), 0, PlateComponentUtil.getItemStackHandler(stack, null).getSlots()) : ModItemStackHandlerHelper.getItemStackListInSlot(PlateComponentUtil.getItemStackHandler(stack, null), 0, this.ingredientInput);
    }

    public void addItemStackTooltip(ItemStack stack, @Nonnull List<Component> tooltipComponents) {
        List<ItemStack> stackList = this.getItemStackListInPlate(stack, true);
        if (!stackList.isEmpty()) {
            stackList.forEach(itemStack -> tooltipComponents.add((Component)Component.m_237110_((String)"item_text.customized.item_stack", (Object[])new Object[]{itemStack.m_41613_(), Component.m_237115_((String)itemStack.m_41720_().m_5524_())}).m_130940_(ChatFormatting.GRAY)));
        }
    }

    public void addEffectTooltip(@Nonnull ItemStack stack, @Nullable Level level, @Nonnull List<Component> tooltipComponents) {
        if (!PlateComponentUtil.getFoodProperty(stack).m_38749_().isEmpty()) {
            PlateComponentUtil.getFoodProperty(stack).m_38749_().forEach(buff -> {
                int i = Mth.m_14143_((float)((MobEffectInstance)buff.getFirst()).m_19557_());
                MutableComponent component = Component.m_237113_((String)StringUtil.m_14404_((int)i));
                MobEffect mobEffect = ((MobEffectInstance)buff.getFirst()).m_19544_();
                tooltipComponents.add((Component)Component.m_237110_((String)"item_text.customized.buff", (Object[])new Object[]{Component.m_237115_((String)mobEffect.m_19481_()).m_7220_((Component)Component.m_237115_((String)("enchantment.level." + (((MobEffectInstance)buff.getFirst()).m_19564_() + 1)))), component}).m_130940_(mobEffect.m_19483_().m_19497_()));
            });
        }
    }

    public abstract AbstractPotBlockEntity getPotEntity(Level var1, BlockPos var2);

    public int getIngredientInput() {
        return this.ingredientInput;
    }

    public int getSeasoningInput() {
        return this.seasoningInput;
    }

    public boolean isCanInputDrive() {
        return this.canInputDrive;
    }
}

