/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.recipe;

import java.util.List;
import javax.annotation.Nonnull;
import mangopill.customized.common.recipe.ModRecipeInterface;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public abstract class AbstractPotRecipe
implements ModRecipeInterface<RecipeWrapper> {
    private final NonNullList<Ingredient> ingredientItem;
    private final NonNullList<Ingredient> seasoningItem;
    private final Ingredient spiceItem;
    private final ItemStack output;
    private final int cookingTime;
    private final RecipeSerializer<?> recipeSerializer;
    private final RecipeType<?> recipeType;
    private final int ingredientInput;
    private final int seasoningInput;
    private final ResourceLocation id;

    public AbstractPotRecipe(NonNullList<Ingredient> ingredientItem, NonNullList<Ingredient> seasoningItem, Ingredient spiceItem, ItemStack output, int cookingTime, RecipeSerializer<?> recipeSerializer, RecipeType<?> recipeType, int ingredientSlot, int seasoningSlot, ResourceLocation id) {
        this.ingredientItem = ingredientItem;
        this.seasoningItem = seasoningItem;
        this.spiceItem = spiceItem;
        this.output = output;
        this.cookingTime = cookingTime;
        this.recipeSerializer = recipeSerializer;
        this.recipeType = recipeType;
        this.ingredientInput = ingredientSlot;
        this.seasoningInput = seasoningSlot;
        this.id = id;
    }

    public boolean matches(@Nonnull RecipeWrapper recipeWrapper, @Nonnull Level level) {
        List<ItemStack> ingredient = this.getListByWrapper(recipeWrapper, 0, this.ingredientInput);
        List<ItemStack> seasoning = this.getListByWrapper(recipeWrapper, this.ingredientInput, this.ingredientInput + this.seasoningInput);
        return ItemStack.m_41656_((ItemStack)this.spiceItem.m_43908_()[0], (ItemStack)recipeWrapper.m_8020_(this.ingredientInput + this.seasoningInput)) && ingredient.size() == this.ingredientItem.size() && seasoning.size() == this.seasoningItem.size() && RecipeMatcher.findMatches(ingredient, this.ingredientItem) != null && RecipeMatcher.findMatches(seasoning, this.seasoningItem) != null;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull RecipeWrapper recipeWrapper, @Nonnull RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registryAccess) {
        return this.output;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        NonNullList combinedIngredient = NonNullList.m_122779_();
        combinedIngredient.addAll(this.ingredientItem);
        combinedIngredient.addAll(this.seasoningItem);
        if (this.spiceItem != null && !this.spiceItem.m_43947_()) {
            combinedIngredient.add((Object)this.spiceItem);
        }
        return combinedIngredient;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return this.recipeSerializer;
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return this.recipeType;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    public NonNullList<Ingredient> getIngredientItem() {
        return this.ingredientItem;
    }

    public NonNullList<Ingredient> getSeasoningItem() {
        return this.seasoningItem;
    }

    public Ingredient getSpiceItem() {
        return this.spiceItem;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }
}

