/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.recipe;

import java.util.List;
import javax.annotation.Nonnull;
import mangopill.customized.common.recipe.ModRecipeInterface;
import mangopill.customized.common.registry.ModRecipeRegistry;
import mangopill.customized.common.registry.ModRecipeSerializerRegistry;
import net.minecraft.core.NonNullList;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.util.RecipeMatcher;
import net.minecraftforge.items.wrapper.RecipeWrapper;

public class BrewingBarrelRecipe
implements ModRecipeInterface<RecipeWrapper> {
    private final NonNullList<Ingredient> ingredientItem;
    private final Ingredient containerItem;
    private final ItemStack output;
    private final int cookingTime;
    private final int ingredientInput;
    private final ResourceLocation id;

    public BrewingBarrelRecipe(NonNullList<Ingredient> ingredientItem, Ingredient containerItem, ItemStack output, int cookingTime, ResourceLocation id) {
        this.ingredientItem = ingredientItem;
        this.containerItem = containerItem;
        this.output = output;
        this.cookingTime = cookingTime;
        this.ingredientInput = 4;
        this.id = id;
    }

    public boolean matches(@Nonnull RecipeWrapper recipeWrapper, @Nonnull Level level) {
        List<ItemStack> ingredient = this.getListByWrapper(recipeWrapper, 0, this.ingredientInput);
        return ingredient.size() == this.ingredientItem.size() && RecipeMatcher.findMatches(ingredient, this.ingredientItem) != null;
    }

    @Nonnull
    public ItemStack assemble(@Nonnull RecipeWrapper recipeWrapper, @Nonnull RegistryAccess registryAccess) {
        return this.output.m_41777_();
    }

    @Nonnull
    public ItemStack m_8043_(@Nonnull RegistryAccess registryAccess) {
        return this.output;
    }

    @Nonnull
    public NonNullList<Ingredient> m_7527_() {
        return this.ingredientItem;
    }

    @Nonnull
    public ResourceLocation m_6423_() {
        return this.id;
    }

    @Nonnull
    public RecipeSerializer<?> m_7707_() {
        return ModRecipeSerializerRegistry.BREWING_BARREL.get();
    }

    @Nonnull
    public RecipeType<?> m_6671_() {
        return ModRecipeRegistry.BREWING_BARREL.get();
    }

    public NonNullList<Ingredient> getIngredientItem() {
        return this.ingredientItem;
    }

    public Ingredient getContainerItem() {
        return this.containerItem;
    }

    public ItemStack getOutput() {
        return this.output;
    }

    public int getCookingTime() {
        return this.cookingTime;
    }

    public int getIngredientInput() {
        return this.ingredientInput;
    }
}

