/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mangopill.customized.common.recipe.BrewingBarrelRecipe;
import mangopill.customized.common.util.JsonUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;

public class BrewingBarrelSerializer
implements RecipeSerializer<BrewingBarrelRecipe> {
    @Nonnull
    public BrewingBarrelRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject jsonObject) {
        JsonArray ingredientsArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredient");
        NonNullList<Ingredient> ingredient = JsonUtil.jsonArrayToNonNullList(ingredientsArray);
        JsonObject containerIn = GsonHelper.m_13930_((JsonObject)jsonObject, (String)"container");
        Ingredient container = Ingredient.m_43917_((JsonElement)containerIn);
        ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"), (boolean)true);
        int cookingTime = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"time", (int)200);
        return new BrewingBarrelRecipe(ingredient, container, output, cookingTime, id);
    }

    @Nullable
    public BrewingBarrelRecipe fromNetwork(@Nonnull ResourceLocation id, FriendlyByteBuf buffer) {
        int ingredientLength = buffer.m_130242_();
        NonNullList ingredient = NonNullList.m_122780_((int)ingredientLength, (Object)Ingredient.f_43901_);
        ingredient.replaceAll(i -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
        Ingredient container = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack output = buffer.m_130267_();
        int cookingTime = buffer.m_130242_();
        return new BrewingBarrelRecipe((NonNullList<Ingredient>)ingredient, container, output, cookingTime, id);
    }

    public void toNetwork(FriendlyByteBuf buffer, BrewingBarrelRecipe recipe) {
        buffer.m_130130_(recipe.getIngredientItem().size());
        for (Ingredient ingredient : recipe.getIngredientItem()) {
            ingredient.m_43923_(buffer);
        }
        recipe.getContainerItem().m_43923_(buffer);
        buffer.m_130055_(recipe.getOutput());
        buffer.m_130130_(recipe.getCookingTime());
    }
}

