/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.recipe.serializer;

import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mangopill.customized.common.recipe.CasseroleRecipe;
import mangopill.customized.common.util.JsonUtil;
import net.minecraft.core.NonNullList;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.item.crafting.RecipeSerializer;
import net.minecraftforge.common.crafting.CraftingHelper;

public class CasseroleSerializer
implements RecipeSerializer<CasseroleRecipe> {
    @Nonnull
    public CasseroleRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject jsonObject) {
        JsonArray ingredientsArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"ingredient");
        NonNullList<Ingredient> ingredient = JsonUtil.jsonArrayToNonNullList(ingredientsArray);
        JsonArray seasoningArray = GsonHelper.m_13933_((JsonObject)jsonObject, (String)"seasoning");
        NonNullList<Ingredient> seasoning = JsonUtil.jsonArrayToNonNullList(seasoningArray);
        JsonObject spiceIn = GsonHelper.m_13930_((JsonObject)jsonObject, (String)"spice");
        Ingredient spice = Ingredient.m_43917_((JsonElement)spiceIn);
        ItemStack output = CraftingHelper.getItemStack((JsonObject)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"result"), (boolean)true);
        int cookingTime = GsonHelper.m_13824_((JsonObject)jsonObject, (String)"time", (int)300);
        return new CasseroleRecipe(ingredient, seasoning, spice, output, cookingTime, id);
    }

    @Nullable
    public CasseroleRecipe fromNetwork(@Nonnull ResourceLocation id, FriendlyByteBuf buffer) {
        int ingredientLength = buffer.m_130242_();
        NonNullList ingredient = NonNullList.m_122780_((int)ingredientLength, (Object)Ingredient.f_43901_);
        ingredient.replaceAll(i -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
        int seasoningLength = buffer.m_130242_();
        NonNullList seasoning = NonNullList.m_122780_((int)seasoningLength, (Object)Ingredient.f_43901_);
        seasoning.replaceAll(j -> Ingredient.m_43940_((FriendlyByteBuf)buffer));
        Ingredient spice = Ingredient.m_43940_((FriendlyByteBuf)buffer);
        ItemStack output = buffer.m_130267_();
        int cookingTime = buffer.m_130242_();
        return new CasseroleRecipe((NonNullList<Ingredient>)ingredient, (NonNullList<Ingredient>)seasoning, spice, output, cookingTime, id);
    }

    public void toNetwork(FriendlyByteBuf buffer, CasseroleRecipe recipe) {
        buffer.m_130130_(recipe.getIngredientItem().size());
        for (Ingredient ingredient : recipe.getIngredientItem()) {
            ingredient.m_43923_(buffer);
        }
        buffer.m_130130_(recipe.getSeasoningItem().size());
        for (Ingredient ingredient : recipe.getSeasoningItem()) {
            ingredient.m_43923_(buffer);
        }
        recipe.getSpiceItem().m_43923_(buffer);
        buffer.m_130055_(recipe.getOutput());
        buffer.m_130130_(recipe.getCookingTime());
    }
}

