/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.recipe.serializer;

import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.HashSet;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mangopill.customized.common.recipe.PropertyValueRecipe;
import mangopill.customized.common.util.value.PropertyValue;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class PropertyValueSerializer
implements RecipeSerializer<PropertyValueRecipe> {
    @Nonnull
    public PropertyValueRecipe fromJson(@Nonnull ResourceLocation id, @Nonnull JsonObject jsonObject) {
        HashSet<ResourceLocation> name = new HashSet<ResourceLocation>();
        PropertyValue propertyValue = PropertyValue.fromJson((JsonElement)GsonHelper.m_13930_((JsonObject)jsonObject, (String)"value"));
        boolean isItem = jsonObject.has("item");
        GsonHelper.m_13933_((JsonObject)jsonObject, (String)(isItem ? "item" : "tag")).forEach(n -> name.add(new ResourceLocation(GsonHelper.m_13805_((JsonElement)n, (String)(isItem ? "item" : "tag")))));
        return new PropertyValueRecipe(name, propertyValue, isItem, id);
    }

    public PropertyValueRecipe fromNetwork(@Nonnull ResourceLocation id, FriendlyByteBuf buffer) {
        boolean isItem = buffer.readBoolean();
        HashSet<ResourceLocation> name = new HashSet<ResourceLocation>();
        int length = buffer.m_130242_();
        IntStream.range(0, length).forEach(i -> name.add(buffer.m_130281_()));
        PropertyValue propertyValue = PropertyValue.fromNetwork(buffer);
        return new PropertyValueRecipe(name, propertyValue, isItem, id);
    }

    public void toNetwork(FriendlyByteBuf buffer, PropertyValueRecipe recipe) {
        buffer.writeBoolean(recipe.item());
        buffer.m_130130_(recipe.name().size());
        recipe.name().forEach(arg_0 -> ((FriendlyByteBuf)buffer).m_130085_(arg_0));
        recipe.propertyValue().toNetwork(buffer);
    }
}

