/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.util;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import mangopill.customized.common.tag.ModTag;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.items.ItemStackHandler;

public final class ModItemStackHandlerHelper {
    private ModItemStackHandlerHelper() {
    }

    public static void fillInItem(ItemStackHandler itemStackHandler, ItemStack itemStackInHand, int startIndex, int endIndex) {
        for (int i = startIndex; i < endIndex; ++i) {
            ItemStack newItemStackInHand = itemStackInHand.m_41777_();
            ItemStack stackInSlot = itemStackHandler.getStackInSlot(i);
            int slotLimit = Math.min(itemStackHandler.getSlotLimit(i), itemStackInHand.m_41741_());
            int itemStackInHandCount = itemStackInHand.m_41613_();
            int stackInSlotCount = stackInSlot.m_41613_();
            if (stackInSlot.m_41619_()) {
                if (slotLimit >= itemStackInHandCount) {
                    itemStackHandler.setStackInSlot(i, newItemStackInHand);
                    itemStackInHand.m_278832_();
                    break;
                }
                itemStackHandler.setStackInSlot(i, newItemStackInHand.m_41620_(slotLimit));
                continue;
            }
            if (!ItemStack.m_150942_((ItemStack)stackInSlot, (ItemStack)itemStackInHand)) continue;
            if (slotLimit >= stackInSlotCount + itemStackInHandCount) {
                stackInSlot.m_41769_(itemStackInHandCount);
                itemStackInHand.m_278832_();
                break;
            }
            itemStackInHand.m_41774_(slotLimit - stackInSlotCount);
            stackInSlot.m_41769_(slotLimit - stackInSlotCount);
        }
    }

    public static void insertItem(ItemStack itemStackInHand, ItemStackHandler itemStackHandler, int ingredientInput, int seasoningInput, int spiceInput) {
        if (itemStackInHand.m_204117_(ModTag.SEASONING)) {
            ModItemStackHandlerHelper.fillInItem(itemStackHandler, itemStackInHand, ingredientInput, ingredientInput + seasoningInput);
            return;
        }
        if (itemStackInHand.m_204117_(ModTag.FAMOUS_SPICE)) {
            ModItemStackHandlerHelper.fillInItem(itemStackHandler, itemStackInHand, ingredientInput + seasoningInput, ingredientInput + seasoningInput + spiceInput);
            return;
        }
        ModItemStackHandlerHelper.fillInItem(itemStackHandler, itemStackInHand, 0, ingredientInput);
    }

    public static List<ItemStack> getItemStackListInSlot(ItemStackHandler itemStackHandler, int startIndex, int endIndex) {
        ArrayList<ItemStack> stackList = new ArrayList<ItemStack>();
        for (int i = startIndex; i < endIndex; ++i) {
            if (itemStackHandler.getStackInSlot(i).m_41619_()) continue;
            stackList.add(itemStackHandler.getStackInSlot(i));
        }
        return stackList;
    }

    public static void reduceItemStackCountByDivision(ItemStackHandler itemStackHandler, ItemStackHandler initialItemStackHandler, int consumptionCountTotal) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            ItemStack stack = itemStackHandler.getStackInSlot(i);
            ItemStack initialStack = initialItemStackHandler.getStackInSlot(i);
            if (stack.m_41619_()) continue;
            int shrinkCount = Math.round((float)initialStack.m_41613_() / (float)consumptionCountTotal);
            if (shrinkCount >= stack.m_41613_()) {
                stack.m_278832_();
                continue;
            }
            stack.m_41774_(shrinkCount);
        }
    }

    public static void clearAllSlot(ItemStackHandler itemStackHandler) {
        for (int i = 0; i < itemStackHandler.getSlots(); ++i) {
            itemStackHandler.getStackInSlot(i).m_278832_();
        }
    }

    public static ItemStack findMinStack(List<ItemStack> stackList) {
        if (stackList == null || stackList.isEmpty()) {
            return ItemStack.f_41583_;
        }
        ItemStack minStack = stackList.get(0);
        for (ItemStack stack : stackList) {
            if (stack.m_41613_() >= minStack.m_41613_()) continue;
            minStack = stack;
        }
        return minStack;
    }

    public static int getConsumptionCount(List<ItemStack> stackList) {
        return Math.min(16, ModItemStackHandlerHelper.findMinStack(stackList).m_41613_());
    }

    public static boolean hasInput(ItemStackHandler itemStackHandler, int endIndex) {
        for (int i = 0; i < endIndex; ++i) {
            if (itemStackHandler.getStackInSlot(i).m_41619_()) continue;
            return true;
        }
        return false;
    }

    public static List<ItemStack> getTopTwoItemsByCount(List<ItemStack> itemStackList) {
        HashMap<Item, Integer> itemCountMap = new HashMap<Item, Integer>();
        for (ItemStack itemStack : itemStackList) {
            if (itemStack == null) continue;
            Item item = itemStack.m_41720_();
            int count = itemStack.m_41613_();
            itemCountMap.put(item, itemCountMap.getOrDefault(item, 0) + count);
        }
        return itemCountMap.entrySet().stream().sorted((entry1, entry2) -> (Integer)entry2.getValue() - (Integer)entry1.getValue()).limit(2L).map(entry -> new ItemStack((ItemLike)entry.getKey(), ((Integer)entry.getValue()).intValue())).collect(Collectors.toList());
    }

    public static void getOutputItem(ItemStack itemStackInHand, Player player, ItemStackHandler itemStackHandler, int slot) {
        ItemStack stackInSlot = itemStackHandler.getStackInSlot(slot);
        int itemStackInHandCount = itemStackInHand.m_41613_();
        int stackInSlotCount = stackInSlot.m_41613_();
        int min = Math.min(stackInSlotCount, itemStackInHandCount);
        ItemStack newStack = stackInSlot.m_41620_(min).m_41777_();
        if (!player.m_150109_().m_36054_(newStack)) {
            player.m_36176_(newStack, false);
        }
        itemStackInHand.m_41774_(min);
    }

    public static void spawnUsingConvertsTo(Player player, List<ItemStack> stackList) {
        List spawnList = stackList.stream().flatMap(itemStack -> {
            ItemStack optionalItem = itemStack.getCraftingRemainingItem();
            optionalItem.m_41764_(itemStack.m_41613_());
            return Stream.of(optionalItem);
        }).toList();
        spawnList.forEach(craftingRemainingItem -> {
            if (!player.m_150109_().m_36054_(craftingRemainingItem)) {
                player.m_36176_(craftingRemainingItem, false);
            }
        });
    }
}

