/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.util;

import com.mojang.datafixers.util.Pair;
import javax.annotation.Nullable;
import mangopill.customized.common.block.record.PlateSlotRecord;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraftforge.items.ItemStackHandler;

public final class PlateComponentUtil {
    private static final String FOOD_KEY = "FoodProperty";
    private static final String ITEM_HANDLER_KEY = "ItemStackHandler";
    private static final String INITIAL_HANDLER_KEY = "InitialItemStackHandler";
    private static final String CONSUMPTION_KEY = "ConsumptionCount";
    private static final String CONSUMPTION_TOTAL_KEY = "ConsumptionCountTotal";

    private PlateComponentUtil() {
    }

    public static FoodProperties getFoodProperty(ItemStack stack) {
        return PlateComponentUtil.deserializeFoodProperties(stack.m_41784_().m_128469_(FOOD_KEY));
    }

    public static ItemStackHandler getItemStackHandler(ItemStack stack, @Nullable Integer slot) {
        CompoundTag cache;
        if (stack.m_41784_().m_128441_("HandlerCache") && (cache = stack.m_41784_().m_128469_("HandlerCache")).m_128441_(ITEM_HANDLER_KEY)) {
            CompoundTag handlerTag = cache.m_128469_(ITEM_HANDLER_KEY);
            int actualSlots = handlerTag.m_128437_("Items", 10).size();
            ItemStackHandler handler = new ItemStackHandler(actualSlots);
            handler.deserializeNBT(handlerTag);
            return handler;
        }
        if (!stack.m_41784_().m_128441_(ITEM_HANDLER_KEY)) {
            int defaultSlots = slot == null ? PlateSlotRecord.SOUP_BOWL.ingredientInput() + PlateSlotRecord.SOUP_BOWL.seasoningInput() + 1 : slot;
            ItemStackHandler handler = new ItemStackHandler(defaultSlots);
            stack.m_41784_().m_128365_(ITEM_HANDLER_KEY, (Tag)handler.serializeNBT());
        }
        CompoundTag handlerTag = stack.m_41784_().m_128469_(ITEM_HANDLER_KEY);
        int actualSlots = handlerTag.m_128437_("Items", 10).size();
        ItemStackHandler handler = new ItemStackHandler(actualSlots);
        handler.deserializeNBT(handlerTag);
        CompoundTag cache2 = new CompoundTag();
        cache2.m_128365_(ITEM_HANDLER_KEY, (Tag)handler.serializeNBT());
        stack.m_41784_().m_128365_("HandlerCache", (Tag)cache2);
        return handler;
    }

    public static ItemStackHandler getInitialItemStackHandler(ItemStack stack) {
        ItemStackHandler handler;
        if (!stack.m_41784_().m_128441_(INITIAL_HANDLER_KEY)) {
            CompoundTag mainHandlerTag = stack.m_41784_().m_128469_(ITEM_HANDLER_KEY);
            int defaultSlots = mainHandlerTag.m_128437_("Items", 10).size();
            handler = new ItemStackHandler(defaultSlots);
            stack.m_41784_().m_128365_(INITIAL_HANDLER_KEY, (Tag)handler.serializeNBT());
        }
        CompoundTag handlerTag = stack.m_41784_().m_128469_(INITIAL_HANDLER_KEY);
        int actualSlots = handlerTag.m_128437_("Items", 10).size();
        handler = new ItemStackHandler(actualSlots);
        handler.deserializeNBT(handlerTag);
        return handler;
    }

    public static int getConsumptionCount(ItemStack stack) {
        return stack.m_41784_().m_128451_(CONSUMPTION_KEY);
    }

    public static int getConsumptionCountTotal(ItemStack stack) {
        return stack.m_41784_().m_128451_(CONSUMPTION_TOTAL_KEY);
    }

    public static void setFoodProperty(ItemStack stack, FoodProperties foodProperties) {
        stack.m_41784_().m_128365_(FOOD_KEY, (Tag)PlateComponentUtil.serializeFoodProperties(foodProperties));
    }

    public static void setItemStackHandler(ItemStack stack, ItemStackHandler itemStackHandler) {
        stack.m_41784_().m_128365_(ITEM_HANDLER_KEY, (Tag)itemStackHandler.serializeNBT());
        CompoundTag cache = new CompoundTag();
        cache.m_128365_(ITEM_HANDLER_KEY, (Tag)itemStackHandler.serializeNBT());
        stack.m_41784_().m_128365_("HandlerCache", (Tag)cache);
    }

    public static void setInitialItemStackHandler(ItemStack stack, ItemStackHandler itemStackHandler) {
        stack.m_41784_().m_128365_(INITIAL_HANDLER_KEY, (Tag)itemStackHandler.serializeNBT());
    }

    public static void setConsumptionCount(ItemStack stack, int consumptionCount) {
        stack.m_41784_().m_128405_(CONSUMPTION_KEY, consumptionCount);
    }

    public static void setConsumptionCountTotal(ItemStack stack, int consumptionCountTotal) {
        stack.m_41784_().m_128405_(CONSUMPTION_TOTAL_KEY, consumptionCountTotal);
    }

    public static void updateAll(ItemStack stack, ItemStackHandler itemStackHandler, ItemStackHandler initialItemStackHandler, FoodProperties foodProperty, int consumptionCount, int consumptionCountTotal) {
        PlateComponentUtil.setItemStackHandler(stack, itemStackHandler);
        PlateComponentUtil.setInitialItemStackHandler(stack, initialItemStackHandler);
        PlateComponentUtil.setFoodProperty(stack, foodProperty);
        PlateComponentUtil.setConsumptionCount(stack, consumptionCount);
        PlateComponentUtil.setConsumptionCountTotal(stack, consumptionCountTotal);
    }

    public static CompoundTag serializeFoodProperties(FoodProperties food) {
        CompoundTag tag = new CompoundTag();
        tag.m_128405_("nutrition", food.m_38744_());
        tag.m_128350_("saturation", food.m_38745_());
        tag.m_128379_("isMeat", food.m_38746_());
        tag.m_128379_("alwaysEat", food.m_38747_());
        tag.m_128379_("fastFood", food.m_38748_());
        ListTag effects = new ListTag();
        for (Pair pair : food.m_38749_()) {
            CompoundTag effectTag = new CompoundTag();
            effectTag.m_128405_("id", MobEffect.m_19459_((MobEffect)((MobEffectInstance)pair.getFirst()).m_19544_()));
            effectTag.m_128405_("duration", ((MobEffectInstance)pair.getFirst()).m_19557_());
            effectTag.m_128405_("amplifier", ((MobEffectInstance)pair.getFirst()).m_19564_());
            effectTag.m_128350_("probability", ((Float)pair.getSecond()).floatValue());
            effects.add((Object)effectTag);
        }
        tag.m_128365_("effects", (Tag)effects);
        return tag;
    }

    public static FoodProperties deserializeFoodProperties(CompoundTag tag) {
        FoodProperties.Builder builder = new FoodProperties.Builder().m_38760_(tag.m_128451_("nutrition")).m_38758_(tag.m_128457_("saturation"));
        if (tag.m_128471_("isMeat")) {
            builder.m_38757_();
        }
        if (tag.m_128471_("alwaysEat")) {
            builder.m_38765_();
        }
        if (tag.m_128471_("fastFood")) {
            builder.m_38766_();
        }
        if (tag.m_128425_("effects", 9)) {
            ListTag effects = tag.m_128437_("effects", 10);
            for (int i = 0; i < effects.size(); ++i) {
                CompoundTag effectTag = effects.m_128728_(i);
                MobEffect effect = MobEffect.m_19453_((int)effectTag.m_128451_("id"));
                builder.effect(() -> {
                    if (effect != null) {
                        return new MobEffectInstance(effect, effectTag.m_128451_("duration"), effectTag.m_128451_("amplifier"));
                    }
                    return null;
                }, effectTag.m_128457_("probability"));
            }
        }
        return builder.m_38767_();
    }
}

