/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.util;

import com.mojang.datafixers.util.Pair;
import java.math.BigDecimal;
import java.math.RoundingMode;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mangopill.customized.common.CustomizedConfig;
import mangopill.customized.common.FoodValue;
import mangopill.customized.common.effect.CombinationMobEffect;
import mangopill.customized.common.effect.ShrinkNutritionMobEffect;
import mangopill.customized.common.effect.ShrinkSaturationMobEffect;
import mangopill.customized.common.recipe.PropertyValueRecipe;
import mangopill.customized.common.registry.ModRecipeRegistry;
import mangopill.customized.common.util.ModItemStackHandlerHelper;
import mangopill.customized.common.util.category.NutrientCategory;
import mangopill.customized.common.util.value.NutrientBuff;
import mangopill.customized.common.util.value.NutrientFoodValue;
import mangopill.customized.common.util.value.PropertyValue;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.Container;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.effect.MobEffect;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.Level;

public final class PropertyValueUtil {
    private PropertyValueUtil() {
    }

    @Nonnull
    public static PropertyValue getPropertyValue(ItemStack stack, Level level) {
        List recipeHolder = level.m_7465_().m_44056_(ModRecipeRegistry.PROPERTY_VALUE.get(), (Container)new SimpleContainer(new ItemStack[]{stack}), level);
        if (recipeHolder.isEmpty()) {
            return new PropertyValue();
        }
        return recipeHolder.stream().filter(PropertyValueRecipe::item).findFirst().map(PropertyValueRecipe::propertyValue).orElseGet(() -> {
            PropertyValue propertyValue = new PropertyValue();
            HashMap map = new HashMap();
            recipeHolder.forEach(valueRecipe -> valueRecipe.name().forEach(name -> map.put(name, valueRecipe.propertyValue())));
            long maxCount = 0L;
            for (ResourceLocation tag : stack.m_204131_().map(TagKey::f_203868_).filter(map::containsKey).toList()) {
                long count = tag.m_135815_().chars().filter(c -> c == 47).count();
                if (count < maxCount) continue;
                if (count > maxCount) {
                    maxCount = count;
                    propertyValue.replace();
                }
                ((PropertyValue)map.get(tag)).toSet().forEach(entry -> propertyValue.put((NutrientCategory)((Object)((Object)((Object)entry.getKey()))), Math.max(propertyValue.getBigger((NutrientCategory)((Object)((Object)((Object)entry.getKey())))), ((Float)entry.getValue()).floatValue())));
            }
            return propertyValue;
        });
    }

    public static FoodProperties getFoodPropertyByPropertyValue(Level level, List<ItemStack> stackList, boolean shardByConsumption) {
        FoodProperties.Builder builder;
        block20: {
            float saturationValue;
            int nutritionValue;
            ArrayList<Pair<MobEffectInstance, Float>> foodEffect;
            block19: {
                if (stackList == null || stackList.isEmpty()) {
                    return FoodValue.NULL;
                }
                EnumMap<NutrientCategory, Float> nutrientTotal = new EnumMap<NutrientCategory, Float>(NutrientCategory.class);
                for (NutrientCategory category : NutrientCategory.values()) {
                    nutrientTotal.put(category, Float.valueOf(0.0f));
                }
                foodEffect = new ArrayList<Pair<MobEffectInstance, Float>>();
                nutritionValue = 0;
                saturationValue = 0.0f;
                for (ItemStack stack : stackList) {
                    PropertyValue propertyValue = PropertyValueUtil.getPropertyValue(stack, level);
                    FoodProperties foodProperties = stack.getFoodProperties(null);
                    if (foodProperties != null && !foodProperties.m_38749_().isEmpty()) {
                        foodEffect.addAll(foodProperties.m_38749_());
                    }
                    if (!propertyValue.isEmpty()) {
                        for (org.apache.commons.lang3.tuple.Pair<NutrientCategory, Float> entry : propertyValue.toSet()) {
                            NutrientCategory category = (NutrientCategory)((Object)entry.getKey());
                            float value = ((Float)entry.getValue()).floatValue() * (float)stack.m_41613_();
                            nutrientTotal.put(category, Float.valueOf(((Float)nutrientTotal.get((Object)category)).floatValue() + value));
                        }
                        continue;
                    }
                    if (foodProperties != null) {
                        nutritionValue += foodProperties.m_38744_() * stack.m_41613_();
                        saturationValue += foodProperties.m_38745_() * (float)stack.m_41613_();
                        continue;
                    }
                    return FoodValue.INEDIBLE;
                }
                for (NutrientCategory category : nutrientTotal.keySet()) {
                    for (NutrientFoodValue value : NutrientFoodValue.values()) {
                        if (!category.name().equals(value.name())) continue;
                        nutritionValue += (int)Math.round((double)((Float)nutrientTotal.get((Object)category)).floatValue() * value.getNutrition());
                        saturationValue += (float)((double)((Float)nutrientTotal.get((Object)category)).floatValue() * value.getSaturation());
                    }
                }
                if (((Boolean)CustomizedConfig.COMBINATION_BUFF.get()).booleanValue()) {
                    nutritionValue = Math.max(0, (int)((float)nutritionValue - (float)nutritionValue * PropertyValueUtil.getShrinkNutrition(nutrientTotal)));
                    saturationValue = Math.max(0.0f, saturationValue - saturationValue * PropertyValueUtil.getShrinkSaturation(nutrientTotal));
                }
                builder = new FoodProperties.Builder();
                foodEffect.addAll(PropertyValueUtil.getCustomizedFoodEffectList(nutrientTotal));
                if (!shardByConsumption) break block19;
                int consumptionCount = ModItemStackHandlerHelper.getConsumptionCount(stackList);
                if (consumptionCount != 0) {
                    builder.m_38760_(nutritionValue / consumptionCount);
                } else {
                    builder.m_38760_(0);
                }
                if (nutritionValue != 0) {
                    BigDecimal bigDecimal = new BigDecimal(saturationValue).divide(BigDecimal.valueOf(nutritionValue), 6, RoundingMode.HALF_UP).divide(BigDecimal.valueOf(consumptionCount), 5, RoundingMode.HALF_UP);
                    builder.m_38758_(bigDecimal.floatValue() * 12.0f);
                } else {
                    builder.m_38758_(saturationValue / (float)consumptionCount);
                }
                if (foodEffect.isEmpty()) break block20;
                for (Pair pair : foodEffect) {
                    builder.m_38762_((MobEffectInstance)pair.getFirst(), Math.min(((Float)pair.getSecond()).floatValue(), 1.0f));
                }
                break block20;
            }
            builder.m_38760_(nutritionValue);
            if (nutritionValue != 0) {
                BigDecimal newSaturationValue = new BigDecimal(saturationValue).divide(BigDecimal.valueOf(nutritionValue), 5, RoundingMode.HALF_UP);
                builder.m_38758_(newSaturationValue.floatValue() * 12.0f);
            } else {
                builder.m_38758_(saturationValue);
            }
            if (!foodEffect.isEmpty()) {
                for (Pair pair : foodEffect) {
                    builder.m_38762_((MobEffectInstance)pair.getFirst(), ((Float)pair.getSecond()).floatValue());
                }
            }
        }
        return builder.m_38765_().m_38767_();
    }

    public static List<Pair<MobEffectInstance, Float>> getCustomizedFoodEffectList(Map<NutrientCategory, Float> nutrientTotal) {
        Map<NutrientCategory, Float> filteredNutrientTotal = PropertyValueUtil.getFilteredNutrientTotal(nutrientTotal);
        ArrayList<Pair<MobEffectInstance, Float>> foodEffect = new ArrayList<Pair<MobEffectInstance, Float>>();
        for (NutrientCategory category : filteredNutrientTotal.keySet()) {
            float nutrientValue = filteredNutrientTotal.get((Object)category).floatValue();
            if (((Boolean)CustomizedConfig.NORMAL_BUFF.get()).booleanValue()) {
                PropertyValueUtil.addBuffToList(nutrientValue, foodEffect, PropertyValueUtil.getNormalBuff(category));
            }
            if (!((Boolean)CustomizedConfig.POWERFUL_BUFF.get()).booleanValue()) continue;
            PropertyValueUtil.addBuffToList(nutrientValue, foodEffect, PropertyValueUtil.getPowerfulBuff(category));
        }
        if (((Boolean)CustomizedConfig.COMBINATION_BUFF.get()).booleanValue()) {
            Map<NutrientBuff, Float> combinationBuff = PropertyValueUtil.getCombinationBuffMap(filteredNutrientTotal);
            combinationBuff.forEach((n, f) -> PropertyValueUtil.addBuffToList(f.floatValue(), foodEffect, n));
        }
        return foodEffect;
    }

    @Nonnull
    public static Map<NutrientCategory, Float> getFilteredNutrientTotal(Map<NutrientCategory, Float> nutrientTotal) {
        return nutrientTotal.entrySet().stream().filter(entry -> ((Float)entry.getValue()).floatValue() > 0.0f).collect(Collectors.toMap(Map.Entry::getKey, Map.Entry::getValue));
    }

    public static Map<NutrientBuff, Float> getCombinationBuffMap(Map<NutrientCategory, Float> filteredNutrientTotal) {
        HashMap<NutrientBuff, Float> combinationBuff = new HashMap<NutrientBuff, Float>();
        EnumSet<NutrientBuff> nutrientTotal = EnumSet.allOf(NutrientBuff.class);
        nutrientTotal.forEach(nutrientBuff -> {
            MobEffect patt9399$temp = nutrientBuff.getEffect();
            if (patt9399$temp instanceof CombinationMobEffect) {
                CombinationMobEffect combinationMobEffect = (CombinationMobEffect)patt9399$temp;
                PropertyValueUtil.putCombinationBuffByContains(filteredNutrientTotal, combinationBuff, nutrientBuff, combinationMobEffect.getCategorySet());
            }
        });
        return combinationBuff;
    }

    public static float getShrinkNutrition(Map<NutrientCategory, Float> nutrientTotal) {
        Map<NutrientBuff, Float> buffMap = PropertyValueUtil.getCombinationBuffMap(PropertyValueUtil.getFilteredNutrientTotal(nutrientTotal));
        float i = 0.0f;
        for (NutrientBuff nutrient : buffMap.keySet()) {
            MobEffect mobEffect = nutrient.getEffect();
            if (!(mobEffect instanceof ShrinkNutritionMobEffect)) continue;
            ShrinkNutritionMobEffect effect = (ShrinkNutritionMobEffect)mobEffect;
            i += effect.getShrinkNutritionModifier();
        }
        return i;
    }

    public static float getShrinkSaturation(Map<NutrientCategory, Float> nutrientTotal) {
        Map<NutrientBuff, Float> buffMap = PropertyValueUtil.getCombinationBuffMap(PropertyValueUtil.getFilteredNutrientTotal(nutrientTotal));
        float i = 0.0f;
        for (NutrientBuff nutrient : buffMap.keySet()) {
            MobEffect mobEffect = nutrient.getEffect();
            if (!(mobEffect instanceof ShrinkSaturationMobEffect)) continue;
            ShrinkSaturationMobEffect effect = (ShrinkSaturationMobEffect)mobEffect;
            i += effect.getShrinkSaturationModifier();
        }
        return i;
    }

    public static void putCombinationBuffByContains(Map<NutrientCategory, Float> filteredNutrientTotal, Map<NutrientBuff, Float> combinationBuffMap, NutrientBuff combinationBuff, List<Set<NutrientCategory>> sets) {
        for (Set<NutrientCategory> set : sets) {
            if (!filteredNutrientTotal.keySet().containsAll(set)) continue;
            float totalValue = (float)filteredNutrientTotal.entrySet().stream().filter(entry -> set.contains(entry.getKey())).mapToDouble(Map.Entry::getValue).sum();
            combinationBuffMap.put(combinationBuff, Float.valueOf(totalValue));
        }
    }

    public static void addBuffToList(float nutrientValue, List<Pair<MobEffectInstance, Float>> foodEffect, NutrientBuff nutrientBuff) {
        if (nutrientBuff == null) {
            return;
        }
        int duration = Math.round(nutrientValue * (float)nutrientBuff.getDuration());
        float probability = (float)((double)nutrientValue * nutrientBuff.getProbability());
        foodEffect.add((Pair<MobEffectInstance, Float>)new Pair((Object)new MobEffectInstance(nutrientBuff.getEffect(), duration, Math.min((int)((double)nutrientValue / (Double)CustomizedConfig.BUFF_AMPLIFIER.get()), 9)), (Object)Float.valueOf(Math.min(probability, 1.0f))));
    }

    @Nullable
    public static NutrientBuff getNormalBuff(NutrientCategory category) {
        return switch (category) {
            case NutrientCategory.COLD -> NutrientBuff.ICED;
            case NutrientCategory.WARM -> NutrientBuff.WARM_STOMACH;
            default -> null;
        };
    }

    @Nullable
    public static NutrientBuff getPowerfulBuff(NutrientCategory category) {
        return switch (category) {
            case NutrientCategory.ECOLOGY -> NutrientBuff.VITALITY;
            case NutrientCategory.DREAD -> NutrientBuff.ANTIDOTE;
            case NutrientCategory.NOTHINGNESS -> NutrientBuff.SOAR;
            default -> null;
        };
    }
}

