/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.common.util.value;

import com.google.common.collect.ImmutableSet;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import java.util.Arrays;
import java.util.Locale;
import java.util.Set;
import java.util.stream.IntStream;
import javax.annotation.Nonnull;
import mangopill.customized.common.util.category.NutrientCategory;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.tuple.Pair;

public class PropertyValue {
    private static final NutrientCategory[] CATEGORY = NutrientCategory.values();
    private final float[] value = new float[CATEGORY.length];
    private int size;

    public static PropertyValue fromJson(JsonElement json) {
        PropertyValue propertyValue = new PropertyValue();
        JsonObject object = json.getAsJsonObject();
        object.entrySet().forEach(entry -> {
            String category = ((String)entry.getKey()).toUpperCase(Locale.ROOT);
            propertyValue.put(NutrientCategory.valueOf(category), ((JsonElement)entry.getValue()).getAsFloat());
        });
        return propertyValue;
    }

    public JsonElement toJson() {
        JsonObject object = new JsonObject();
        this.toSet().forEach(entry -> object.addProperty(((NutrientCategory)((Object)((Object)entry.getKey()))).name(), (Number)entry.getValue()));
        return object;
    }

    public boolean has(@Nonnull NutrientCategory category) {
        return this.value[category.ordinal()] > 0.0f;
    }

    public boolean notHas(@Nonnull NutrientCategory category) {
        return !this.has(category);
    }

    public void put(@Nonnull NutrientCategory category, float value) {
        if (Float.isNaN(value) || value <= 0.0f) {
            this.remove(category);
            return;
        }
        if (this.notHas(category)) {
            ++this.size;
        }
        this.value[category.ordinal()] = value;
    }

    public void remove(@Nonnull NutrientCategory category) {
        if (this.notHas(category)) {
            return;
        }
        this.value[category.ordinal()] = 0.0f;
        --this.size;
    }

    public Set<Pair<NutrientCategory, Float>> toSet() {
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (NutrientCategory category : CATEGORY) {
            if (!(this.value[category.ordinal()] > 0.0f)) continue;
            builder.add((Object)Pair.of((Object)((Object)category), (Object)Float.valueOf(this.value[category.ordinal()])));
        }
        return builder.build();
    }

    public static PropertyValue fromNetwork(FriendlyByteBuf buffer) {
        PropertyValue propertyValue = new PropertyValue();
        byte length = buffer.readByte();
        IntStream.range(0, length).forEach(i -> {
            NutrientCategory category = (NutrientCategory)buffer.m_130066_(NutrientCategory.class);
            float value = buffer.readFloat();
            propertyValue.put(category, value);
        });
        return propertyValue;
    }

    public void toNetwork(FriendlyByteBuf buffer) {
        Set<Pair<NutrientCategory, Float>> entrySet = this.toSet();
        buffer.writeByte(entrySet.size());
        entrySet.forEach(entry -> {
            buffer.m_130068_((Enum)entry.getKey());
            buffer.writeFloat(((Float)entry.getValue()).floatValue());
        });
    }

    public boolean isEmpty() {
        return this.size <= 0;
    }

    public void replace() {
        Arrays.fill(this.value, 0.0f);
        this.size = 0;
    }

    public float getBigger(@Nonnull NutrientCategory category) {
        return Math.max(this.value[category.ordinal()], 0.0f);
    }

    public static NutrientCategory[] getCategory() {
        return CATEGORY;
    }

    public float[] getValue() {
        return this.value;
    }

    public int getSize() {
        return this.size;
    }
}

