/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.integration.jei;

import javax.annotation.Nonnull;
import mangopill.customized.common.registry.ModAdvancementRegistry;
import mangopill.customized.common.registry.ModItemRegistry;
import mangopill.customized.integration.jei.category.BrewingBarrelRecipeCategory;
import mangopill.customized.integration.jei.category.CasseroleRecipeCategory;
import mangopill.customized.integration.jei.util.JeiUtil;
import mezz.jei.api.IModPlugin;
import mezz.jei.api.constants.RecipeTypes;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import mezz.jei.api.registration.IRecipeCatalystRegistration;
import mezz.jei.api.registration.IRecipeCategoryRegistration;
import mezz.jei.api.registration.IRecipeRegistration;
import net.minecraft.client.Minecraft;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.ItemLike;

@mezz.jei.api.JeiPlugin
public class JeiPlugin
implements IModPlugin {
    public static final ResourceLocation JEI_PLUGIN_UID = ModAdvancementRegistry.getId("jei_plugin");

    public void registerCategories(@Nonnull IRecipeCategoryRegistration registration) {
        registration.addRecipeCategories(new IRecipeCategory[]{new CasseroleRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
        registration.addRecipeCategories(new IRecipeCategory[]{new BrewingBarrelRecipeCategory(registration.getJeiHelpers().getGuiHelper())});
    }

    public void registerRecipes(@Nonnull IRecipeRegistration registration) {
        if (Minecraft.m_91087_().f_91073_ != null) {
            registration.addRecipes(JeiUtil.CASSEROLE, JeiUtil.getCasseroleRecipeList());
            registration.addRecipes(JeiUtil.BREWING_BARREL, JeiUtil.getBrewingBarrelRecipeList());
        }
        JeiUtil.addJeiInfo(registration, ModItemRegistry.SOILED_SEED, ".soiled_seed");
        JeiUtil.addJeiInfo(registration, ModItemRegistry.SOUP_BOWL, ".soup_bowl");
        JeiUtil.addJeiInfo(registration, ModItemRegistry.SALT_PAN, ".salt_pan");
        JeiUtil.addJeiInfo(registration, ModItemRegistry.SALT, ".salt");
        JeiUtil.addJeiInfo(registration, ModItemRegistry.SPOON, ".spoon");
    }

    public void registerRecipeCatalysts(IRecipeCatalystRegistration registration) {
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItemRegistry.CASSEROLE.get()), new RecipeType[]{RecipeTypes.CAMPFIRE_COOKING, JeiUtil.CASSEROLE});
        registration.addRecipeCatalyst(new ItemStack((ItemLike)ModItemRegistry.BREWING_BARREL.get()), new RecipeType[]{JeiUtil.BREWING_BARREL});
    }

    @Nonnull
    public ResourceLocation getPluginUid() {
        return JEI_PLUGIN_UID;
    }
}

