/*
 * Decompiled with CFR 0.152.
 */
package mangopill.customized.integration.jei.category;

import java.util.ArrayList;
import java.util.List;
import javax.annotation.Nonnull;
import mangopill.customized.common.recipe.BrewingBarrelRecipe;
import mangopill.customized.common.registry.ModAdvancementRegistry;
import mangopill.customized.common.registry.ModBlockRegistry;
import mangopill.customized.common.registry.ModItemRegistry;
import mangopill.customized.integration.jei.util.JeiUtil;
import mezz.jei.api.constants.VanillaTypes;
import mezz.jei.api.gui.builder.IRecipeLayoutBuilder;
import mezz.jei.api.gui.drawable.IDrawable;
import mezz.jei.api.gui.ingredient.IRecipeSlotsView;
import mezz.jei.api.helpers.IGuiHelper;
import mezz.jei.api.ingredients.IIngredientType;
import mezz.jei.api.recipe.IFocusGroup;
import mezz.jei.api.recipe.RecipeIngredientRole;
import mezz.jei.api.recipe.RecipeType;
import mezz.jei.api.recipe.category.IRecipeCategory;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;

public class BrewingBarrelRecipeCategory
implements IRecipeCategory<BrewingBarrelRecipe> {
    private final Component title = Component.m_237115_((String)ModBlockRegistry.BREWING_BARREL.get().m_7705_());
    private final IDrawable background;
    private final IDrawable icon;

    public BrewingBarrelRecipeCategory(IGuiHelper helper) {
        this.background = helper.createDrawable(ModAdvancementRegistry.getId("textures/gui/brewing_barrel.png"), 4, 4, 54, 41);
        this.icon = helper.createDrawableIngredient((IIngredientType)VanillaTypes.ITEM_STACK, (Object)new ItemStack((ItemLike)ModItemRegistry.BREWING_BARREL.get()));
    }

    @Nonnull
    public RecipeType<BrewingBarrelRecipe> getRecipeType() {
        return JeiUtil.BREWING_BARREL;
    }

    @Nonnull
    public Component getTitle() {
        return this.title;
    }

    @Nonnull
    public IDrawable getBackground() {
        return this.background;
    }

    @Nonnull
    public IDrawable getIcon() {
        return this.icon;
    }

    public void setRecipe(@Nonnull IRecipeLayoutBuilder builder, @Nonnull BrewingBarrelRecipe recipe, @Nonnull IFocusGroup focuses) {
        int slotSize = 18;
        for (int row = 0; row < 2; ++row) {
            for (int col = 0; col < 2; ++col) {
                int index = row * 2 + col;
                if (index >= recipe.getIngredientItem().size()) continue;
                builder.addSlot(RecipeIngredientRole.INPUT, col * slotSize + 1, row * slotSize + 1).addIngredients((Ingredient)recipe.getIngredientItem().get(index));
            }
        }
        builder.addSlot(RecipeIngredientRole.OUTPUT, 37, 19).addItemStack(recipe.getOutput());
    }

    @Nonnull
    public List<Component> getTooltipStrings(@Nonnull BrewingBarrelRecipe recipe, @Nonnull IRecipeSlotsView recipeSlotsView, double mouseX, double mouseY) {
        ArrayList<Component> tooltipString = new ArrayList<Component>();
        if (JeiUtil.canAddTooltip(mouseX, mouseY, 38.0, 3.0, 11.0, 13.0)) {
            tooltipString.add((Component)Component.m_237110_((String)"gui.jei.customized.cook_time", (Object[])new Object[]{recipe.getCookingTime() * 13 / 20}));
        }
        if (JeiUtil.canAddTooltip(mouseX, mouseY, 41.0, 37.0, 8.0, 4.0)) {
            tooltipString.add((Component)Component.m_237110_((String)"gui.jei.customized.container", (Object[])new Object[]{Component.m_237115_((String)recipe.getContainerItem().m_43908_()[0].m_41778_())}));
        }
        return tooltipString;
    }
}

