/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.database.resources;

import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.Unit;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.sailex.secondbrain.database.repositories.ConversationRepository;
import me.sailex.secondbrain.history.Message;
import me.sailex.secondbrain.model.database.Conversation;
import me.sailex.secondbrain.util.LogUtil;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\u001b\u0010\n\u001a\u00020\t2\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\n\u0010\u000bJ#\u0010\u000f\u001a\u00020\t2\u0006\u0010\f\u001a\u00020\u00072\f\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\r0\u0006\u00a2\u0006\u0004\b\u000f\u0010\u0010J\r\u0010\u0011\u001a\u00020\t\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\tH\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0012J#\u0010\u0018\u001a\b\u0012\u0004\u0012\u00020\u00170\u00162\f\u0010\u0015\u001a\b\u0012\u0004\u0012\u00020\t0\u0014H\u0002\u00a2\u0006\u0004\b\u0018\u0010\u0019J\u000f\u0010\u001b\u001a\u00020\u001aH\u0002\u00a2\u0006\u0004\b\u001b\u0010\u001cR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u001d\u001a\u0004\b\u001e\u0010\u001fR\u0016\u0010 \u001a\u00020\u001a8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b \u0010!R?\u0010%\u001a*\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u00060\"j\u0014\u0012\u0004\u0012\u00020\u0007\u0012\n\u0012\b\u0012\u0004\u0012\u00020#0\u0006`$8\u0006\u00a2\u0006\f\n\u0004\b%\u0010&\u001a\u0004\b'\u0010(\u00a8\u0006)"}, d2={"Lme/sailex/secondbrain/database/resources/ResourceProvider;", "", "Lme/sailex/secondbrain/database/repositories/ConversationRepository;", "conversationRepository", "<init>", "(Lme/sailex/secondbrain/database/repositories/ConversationRepository;)V", "", "Ljava/util/UUID;", "uuids", "", "loadResources", "(Ljava/util/List;)V", "uuid", "Lme/sailex/secondbrain/history/Message;", "messages", "addConversations", "(Ljava/util/UUID;Ljava/util/List;)V", "saveResources", "()V", "shutdownServiceNow", "Lkotlin/Function0;", "task", "Ljava/util/concurrent/CompletableFuture;", "Ljava/lang/Void;", "runAsync", "(Lkotlin/jvm/functions/Function0;)Ljava/util/concurrent/CompletableFuture;", "Ljava/util/concurrent/ExecutorService;", "initExecutorPool", "()Ljava/util/concurrent/ExecutorService;", "Lme/sailex/secondbrain/database/repositories/ConversationRepository;", "getConversationRepository", "()Lme/sailex/secondbrain/database/repositories/ConversationRepository;", "executorService", "Ljava/util/concurrent/ExecutorService;", "Ljava/util/HashMap;", "Lme/sailex/secondbrain/model/database/Conversation;", "Lkotlin/collections/HashMap;", "loadedConversations", "Ljava/util/HashMap;", "getLoadedConversations", "()Ljava/util/HashMap;", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nResourceProvider.kt\nKotlin\n*S Kotlin\n*F\n+ 1 ResourceProvider.kt\nme/sailex/secondbrain/database/resources/ResourceProvider\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n+ 3 _Maps.kt\nkotlin/collections/MapsKt___MapsKt\n*L\n1#1,74:1\n1557#2:75\n1628#2,3:76\n1863#2,2:79\n1863#2,2:82\n216#3:81\n217#3:84\n*S KotlinDebug\n*F\n+ 1 ResourceProvider.kt\nme/sailex/secondbrain/database/resources/ResourceProvider\n*L\n36#1:75\n36#1:76,3\n28#1:79,2\n49#1:82,2\n48#1:81\n48#1:84\n*E\n"})
public final class ResourceProvider {
    @NotNull
    private final ConversationRepository conversationRepository;
    private ExecutorService executorService;
    @NotNull
    private final HashMap<UUID, List<Conversation>> loadedConversations;

    public ResourceProvider(@NotNull ConversationRepository conversationRepository) {
        Intrinsics.checkNotNullParameter((Object)conversationRepository, (String)"conversationRepository");
        this.conversationRepository = conversationRepository;
        this.loadedConversations = new HashMap();
    }

    @NotNull
    public final ConversationRepository getConversationRepository() {
        return this.conversationRepository;
    }

    @NotNull
    public final HashMap<UUID, List<Conversation>> getLoadedConversations() {
        return this.loadedConversations;
    }

    public final void loadResources(@NotNull List<UUID> uuids) {
        Intrinsics.checkNotNullParameter(uuids, (String)"uuids");
        this.executorService = this.initExecutorPool();
        this.runAsync((Function0<Unit>)((Function0)() -> ResourceProvider.loadResources$lambda$1(uuids, this)));
    }

    /*
     * WARNING - void declaration
     */
    public final void addConversations(@NotNull UUID uuid, @NotNull List<Message> messages) {
        void $this$mapTo$iv$iv;
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter(messages, (String)"messages");
        Map map = this.loadedConversations;
        Iterable $this$map$iv = messages;
        boolean $i$f$map = false;
        Iterable iterable = $this$map$iv;
        Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        boolean $i$f$mapTo = false;
        for (Object item$iv$iv : $this$mapTo$iv$iv) {
            void it;
            Message message = (Message)item$iv$iv;
            Collection collection = destination$iv$iv;
            boolean bl = false;
            collection.add(new Conversation(uuid, it.getRole(), it.getMessage()));
        }
        List list = (List)destination$iv$iv;
        map.put(uuid, list);
    }

    public final void saveResources() {
        this.shutdownServiceNow();
        this.executorService = this.initExecutorPool();
        this.runAsync((Function0<Unit>)((Function0)() -> ResourceProvider.saveResources$lambda$5(this))).get();
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executorService");
            executorService = null;
        }
        executorService.shutdownNow();
    }

    private final void shutdownServiceNow() {
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executorService");
            executorService = null;
        }
        if (!executorService.isTerminated()) {
            ExecutorService executorService2 = this.executorService;
            if (executorService2 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executorService");
                executorService2 = null;
            }
            executorService2.shutdownNow();
            LogUtil.error("Initial loading of resources interrupted - Wait for termination");
            ExecutorService executorService3 = this.executorService;
            if (executorService3 == null) {
                Intrinsics.throwUninitializedPropertyAccessException((String)"executorService");
                executorService3 = null;
            }
            executorService3.awaitTermination(500L, TimeUnit.MILLISECONDS);
        }
    }

    private final CompletableFuture<Void> runAsync(Function0<Unit> task) {
        Runnable runnable = () -> ResourceProvider.runAsync$lambda$6(task);
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executorService");
            executorService = null;
        }
        CompletionStage completionStage = CompletableFuture.runAsync(runnable, executorService).exceptionally(ResourceProvider::runAsync$lambda$7);
        Intrinsics.checkNotNullExpressionValue((Object)completionStage, (String)"exceptionally(...)");
        return completionStage;
    }

    private final ExecutorService initExecutorPool() {
        ExecutorService executorService = Executors.newFixedThreadPool(2);
        Intrinsics.checkNotNullExpressionValue((Object)executorService, (String)"newFixedThreadPool(...)");
        return executorService;
    }

    private static final Unit loadResources$lambda$1(List $uuids, ResourceProvider this$0) {
        LogUtil.info("Loading conversations into memory...");
        Iterable $this$forEach$iv = $uuids;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            ((Map)this$0.loadedConversations).put(it, this$0.conversationRepository.selectByUuid(it));
        }
        ExecutorService executorService = this$0.executorService;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executorService");
            executorService = null;
        }
        executorService.shutdownNow();
        return Unit.INSTANCE;
    }

    private static final Unit saveResources$lambda$5(ResourceProvider this$0) {
        Map $this$forEach$iv = this$0.loadedConversations;
        boolean $i$f$forEach = false;
        Iterator iterator = $this$forEach$iv.entrySet().iterator();
        while (iterator.hasNext()) {
            Map.Entry element$iv;
            Map.Entry conversations = element$iv = iterator.next();
            boolean bl = false;
            Iterable $this$forEach$iv2 = (Iterable)conversations.getValue();
            boolean $i$f$forEach2 = false;
            for (Object element$iv2 : $this$forEach$iv2) {
                Conversation it = (Conversation)element$iv2;
                boolean bl2 = false;
                this$0.conversationRepository.insert(it);
            }
        }
        LogUtil.info("Saved conversations to db");
        return Unit.INSTANCE;
    }

    private static final void runAsync$lambda$6(Function0 $tmp0) {
        $tmp0.invoke();
    }

    private static final Void runAsync$lambda$7(Throwable it) {
        LogUtil.error("Error loading/saving resources into memory", it);
        return null;
    }
}

