/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.event;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.JsonParseException;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Ref;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.sequences.Sequence;
import kotlin.sequences.SequencesKt;
import kotlin.text.StringsKt;
import me.sailex.altoclef.AltoClefController;
import me.sailex.altoclef.commandsystem.CommandException;
import me.sailex.altoclef.commandsystem.CommandExecutor;
import me.sailex.altoclef.tasks.LookAtOwnerTask;
import me.sailex.altoclef.tasksystem.Task;
import me.sailex.secondbrain.config.NPCConfig;
import me.sailex.secondbrain.context.ContextProvider;
import me.sailex.secondbrain.event.CustomEventException;
import me.sailex.secondbrain.event.EventHandler;
import me.sailex.secondbrain.event.NPCEventHandler$buildErrorMessage$;
import me.sailex.secondbrain.history.ConversationHistory;
import me.sailex.secondbrain.history.Message;
import me.sailex.secondbrain.llm.LLMClient;
import me.sailex.secondbrain.llm.player2.Player2APIClient;
import me.sailex.secondbrain.llm.roles.Player2ChatRole;
import me.sailex.secondbrain.util.LogUtil;
import me.sailex.secondbrain.util.PromptFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000V\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0010\u0003\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 ,2\u00020\u0001:\u0002,-B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u000f\u001a\u00020\u000eH\u0016\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u000f\u0010\u0013\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u000f\u0010\u0016\u001a\u00020\u0015H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u0017\u0010\u001a\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001a\u0010\u001bJ\u0017\u0010\u001c\u001a\u00020\u00192\u0006\u0010\u0018\u001a\u00020\u000eH\u0002\u00a2\u0006\u0004\b\u001c\u0010\u001bJ\u0015\u0010\u001e\u001a\u00020\u00152\u0006\u0010\u001d\u001a\u00020\u000e\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0019\u0010\"\u001a\u0004\u0018\u00010\u000e2\u0006\u0010!\u001a\u00020 H\u0002\u00a2\u0006\u0004\b\"\u0010#R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010$R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010%R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010&R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010'R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010(R\u0014\u0010*\u001a\u00020)8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b*\u0010+\u00a8\u0006."}, d2={"Lme/sailex/secondbrain/event/NPCEventHandler;", "Lme/sailex/secondbrain/event/EventHandler;", "Lme/sailex/secondbrain/llm/LLMClient;", "llmClient", "Lme/sailex/secondbrain/history/ConversationHistory;", "history", "Lme/sailex/secondbrain/context/ContextProvider;", "contextProvider", "Lme/sailex/altoclef/AltoClefController;", "controller", "Lme/sailex/secondbrain/config/NPCConfig;", "config", "<init>", "(Lme/sailex/secondbrain/llm/LLMClient;Lme/sailex/secondbrain/history/ConversationHistory;Lme/sailex/secondbrain/context/ContextProvider;Lme/sailex/altoclef/AltoClefController;Lme/sailex/secondbrain/config/NPCConfig;)V", "", "prompt", "", "onEvent", "(Ljava/lang/String;)V", "stopService", "()V", "", "queueIsEmpty", "()Z", "content", "Lme/sailex/secondbrain/event/NPCEventHandler$CommandMessage;", "parse", "(Ljava/lang/String;)Lme/sailex/secondbrain/event/NPCEventHandler$CommandMessage;", "parseContent", "command", "execute", "(Ljava/lang/String;)Z", "", "exception", "buildErrorMessage", "(Ljava/lang/Throwable;)Ljava/lang/String;", "Lme/sailex/secondbrain/llm/LLMClient;", "Lme/sailex/secondbrain/history/ConversationHistory;", "Lme/sailex/secondbrain/context/ContextProvider;", "Lme/sailex/altoclef/AltoClefController;", "Lme/sailex/secondbrain/config/NPCConfig;", "Ljava/util/concurrent/ThreadPoolExecutor;", "executorService", "Ljava/util/concurrent/ThreadPoolExecutor;", "Companion", "CommandMessage", "1.21.10"})
@SourceDebugExtension(value={"SMAP\nNPCEventHandler.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NPCEventHandler.kt\nme/sailex/secondbrain/event/NPCEventHandler\n+ 2 _Sequences.kt\nkotlin/sequences/SequencesKt___SequencesKt\n*L\n1#1,143:1\n477#2:144\n*S KotlinDebug\n*F\n+ 1 NPCEventHandler.kt\nme/sailex/secondbrain/event/NPCEventHandler\n*L\n136#1:144\n*E\n"})
public final class NPCEventHandler
implements EventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LLMClient llmClient;
    @NotNull
    private final ConversationHistory history;
    @NotNull
    private final ContextProvider contextProvider;
    @NotNull
    private final AltoClefController controller;
    @NotNull
    private final NPCConfig config;
    @NotNull
    private final ThreadPoolExecutor executorService;
    private static final Gson gson = new GsonBuilder().setLenient().create();

    public NPCEventHandler(@NotNull LLMClient llmClient, @NotNull ConversationHistory history, @NotNull ContextProvider contextProvider, @NotNull AltoClefController controller, @NotNull NPCConfig config) {
        Intrinsics.checkNotNullParameter((Object)llmClient, (String)"llmClient");
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.llmClient = llmClient;
        this.history = history;
        this.contextProvider = contextProvider;
        this.controller = controller;
        this.config = config;
        this.executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new ArrayBlockingQueue(10), new ThreadPoolExecutor.DiscardPolicy());
    }

    @Override
    public void onEvent(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        CompletableFuture.runAsync(() -> NPCEventHandler.onEvent$lambda$0(prompt, this), this.executorService).exceptionally(arg_0 -> NPCEventHandler.onEvent$lambda$1(this, prompt, arg_0));
    }

    @Override
    public void stopService() {
        this.executorService.shutdownNow();
    }

    @Override
    public boolean queueIsEmpty() {
        return this.executorService.getQueue().isEmpty();
    }

    private final CommandMessage parse(String content) {
        CommandMessage commandMessage;
        try {
            commandMessage = this.parseContent(content);
        }
        catch (JsonParseException jsonParseException) {
            CommandMessage commandMessage2;
            String cleanedContent = StringsKt.replace$default((String)StringsKt.replace$default((String)content, (String)"```json", (String)"", (boolean)false, (int)4, null), (String)"```", (String)"", (boolean)false, (int)4, null);
            try {
                commandMessage2 = this.parseContent(cleanedContent);
            }
            catch (JsonParseException e) {
                throw new CustomEventException("The selected model may be too small to understand the context or to reliably produce valid JSON. Please switch to a larger or more capable LLM model.", (Exception)((Object)e));
            }
            commandMessage = commandMessage2;
        }
        return commandMessage;
    }

    private final CommandMessage parseContent(String content) {
        Object object = gson.fromJson(content, CommandMessage.class);
        Intrinsics.checkNotNullExpressionValue((Object)object, (String)"fromJson(...)");
        return (CommandMessage)object;
    }

    public final boolean execute(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        Ref.BooleanRef successful = new Ref.BooleanRef();
        successful.element = true;
        CommandExecutor cmdExecutor = this.controller.getCommandExecutor();
        String commandWithPrefix = cmdExecutor.isClientCommand(command) ? command : cmdExecutor.getCommandPrefix() + command;
        cmdExecutor.execute(commandWithPrefix, () -> NPCEventHandler.execute$lambda$2(this), arg_0 -> NPCEventHandler.execute$lambda$3(successful, this, commandWithPrefix, arg_0));
        return successful.element;
    }

    private final String buildErrorMessage(Throwable exception) {
        Sequence chain;
        Sequence $this$filterIsInstance$iv = chain = SequencesKt.generateSequence((Object)exception, NPCEventHandler::buildErrorMessage$lambda$4);
        boolean $i$f$filterIsInstance = false;
        Sequence sequence = SequencesKt.filter((Sequence)$this$filterIsInstance$iv, (Function1)buildErrorMessage$$inlined$filterIsInstance$1.INSTANCE);
        Intrinsics.checkNotNull((Object)sequence, (String)"null cannot be cast to non-null type kotlin.sequences.Sequence<R of kotlin.sequences.SequencesKt___SequencesKt.filterIsInstance>");
        CustomEventException custom = (CustomEventException)SequencesKt.firstOrNull((Sequence)sequence);
        if (custom != null) {
            return custom.getMessage();
        }
        return ((Throwable)SequencesKt.last((Sequence)SequencesKt.generateSequence((Object)exception, NPCEventHandler::buildErrorMessage$lambda$5))).getMessage();
    }

    private static final void onEvent$lambda$0(String $prompt, NPCEventHandler this$0) {
        LogUtil.info("onEvent: " + $prompt);
        String string = PromptFormatter.format($prompt, this$0.contextProvider.buildContext());
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
        String formattedPrompt = string;
        ConversationHistory conversationHistory = this$0.history;
        String string2 = Player2ChatRole.USER.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"toLowerCase(...)");
        conversationHistory.add(new Message(formattedPrompt, string2));
        Message response = this$0.llmClient.chat(this$0.history.getLatestConversations());
        ConversationHistory conversationHistory2 = this$0.history;
        Intrinsics.checkNotNull((Object)response);
        conversationHistory2.add(response);
        CommandMessage parsedMessage = this$0.parse(response.getMessage());
        boolean succeeded = this$0.execute(parsedMessage.getCommand());
        if (!succeeded) {
            return;
        }
        if (!Intrinsics.areEqual((Object)parsedMessage.getMessage(), (Object)this$0.history.getLastMessage())) {
            if (this$0.llmClient instanceof Player2APIClient && this$0.config.isTTS()) {
                ((Player2APIClient)this$0.llmClient).startTextToSpeech(parsedMessage.getMessage());
            } else {
                this$0.controller.getControllerExtras().chat(parsedMessage.getMessage());
            }
        }
    }

    private static final Void onEvent$lambda$1(NPCEventHandler this$0, String $prompt, Throwable it) {
        Intrinsics.checkNotNull((Object)it);
        LogUtil.debugInChat("Could not generate a response: " + this$0.buildErrorMessage(it));
        LogUtil.error("Error occurred handling event: " + $prompt, it);
        return null;
    }

    private static final void execute$lambda$2(NPCEventHandler this$0) {
        this$0.controller.runUserTask((Task)new LookAtOwnerTask());
    }

    private static final void execute$lambda$3(Ref.BooleanRef $successful, NPCEventHandler this$0, String $commandWithPrefix, CommandException it) {
        $successful.element = false;
        String string = "Command %s failed. Error content: %s";
        Object[] objectArray = new Object[]{$commandWithPrefix, it.getMessage()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        this$0.onEvent(string2);
        LogUtil.error("Error executing command: " + $commandWithPrefix, (Throwable)it);
    }

    private static final Throwable buildErrorMessage$lambda$4(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCause();
    }

    private static final Throwable buildErrorMessage$lambda$5(Throwable it) {
        Intrinsics.checkNotNullParameter((Object)it, (String)"it");
        return it.getCause();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u0017"}, d2={"Lme/sailex/secondbrain/event/NPCEventHandler$CommandMessage;", "", "", "command", "message", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "component2", "copy", "(Ljava/lang/String;Ljava/lang/String;)Lme/sailex/secondbrain/event/NPCEventHandler$CommandMessage;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getCommand", "getMessage", "1.21.10"})
    public static final class CommandMessage {
        @NotNull
        private final String command;
        @NotNull
        private final String message;

        public CommandMessage(@NotNull String command, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.command = command;
            this.message = message;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String component1() {
            return this.command;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final CommandMessage copy(@NotNull String command, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new CommandMessage(command, message);
        }

        public static /* synthetic */ CommandMessage copy$default(CommandMessage commandMessage, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = commandMessage.command;
            }
            if ((n & 2) != 0) {
                string2 = commandMessage.message;
            }
            return commandMessage.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "CommandMessage(command=" + this.command + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result = this.command.hashCode();
            result = result * 31 + this.message.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommandMessage)) {
                return false;
            }
            CommandMessage commandMessage = (CommandMessage)other;
            if (!Intrinsics.areEqual((Object)this.command, (Object)commandMessage.command)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)commandMessage.message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/sailex/secondbrain/event/NPCEventHandler$Companion;", "", "<init>", "()V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "1.21.10"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

