/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.llm.ollama;

import io.github.ollama4j.OllamaAPI;
import io.github.ollama4j.models.chat.OllamaChatMessage;
import java.util.List;
import java.util.stream.Collectors;
import lombok.Generated;
import me.sailex.secondbrain.exception.LLMServiceException;
import me.sailex.secondbrain.history.Message;
import me.sailex.secondbrain.history.MessageConverter;
import me.sailex.secondbrain.llm.LLMClient;

public class OllamaClient
implements LLMClient {
    private OllamaAPI ollamaAPI;
    private final String model;
    private final String url;

    public OllamaClient(String model, String url, int timeout, boolean verbose) {
        this.url = url;
        this.ollamaAPI = new OllamaAPI(url);
        this.model = model;
        this.ollamaAPI.setVerbose(verbose);
        this.ollamaAPI.setMaxChatToolCallRetries(1);
        this.ollamaAPI.setRequestTimeoutSeconds((long)timeout);
    }

    @Override
    public void checkServiceIsReachable() {
        try {
            boolean isOllamaServerReachable = this.ollamaAPI.ping();
            if (!isOllamaServerReachable) {
                throw new LLMServiceException("Ollama server is not reachable at: " + this.url);
            }
        }
        catch (Exception e) {
            throw new LLMServiceException("Ollama server is not reachable at: " + this.url, e);
        }
    }

    @Override
    public Message chat(List<Message> messages) {
        try {
            List response = this.ollamaAPI.chat(this.model, messages.stream().map(MessageConverter::toOllamaChatMessage).collect(Collectors.toList())).getChatHistory();
            return MessageConverter.toMessage((OllamaChatMessage)response.get(response.size() - 1));
        }
        catch (Exception e) {
            throw new LLMServiceException("Could not generate Response for last prompt: " + messages.get(messages.size() - 1).getMessage(), e);
        }
    }

    @Override
    public void stopService() {
    }

    @Generated
    public void setOllamaAPI(OllamaAPI ollamaAPI) {
        this.ollamaAPI = ollamaAPI;
    }
}

