/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.mineskin;

import com.google.gson.Gson;
import com.google.gson.JsonParseException;
import java.io.IOException;
import java.net.URI;
import java.net.http.HttpClient;
import java.net.http.HttpRequest;
import java.net.http.HttpResponse;
import me.sailex.secondbrain.mineskin.MineSkinProxyClientException;
import me.sailex.secondbrain.mineskin.SkinRequest;
import me.sailex.secondbrain.mineskin.SkinResponse;
import me.sailex.secondbrain.mineskin.Variant;

public class MineSkinProxyClient {
    public static final String PROXY_URL = "https://mineskin.sailex.me/skin";
    public static final Gson GSON = new Gson();
    private final HttpClient client = HttpClient.newHttpClient();

    public SkinResponse getSkin(String url) {
        try {
            SkinRequest requestBody = new SkinRequest(url, Variant.AUTO);
            HttpRequest request = HttpRequest.newBuilder().uri(URI.create(PROXY_URL)).POST(HttpRequest.BodyPublishers.ofString(GSON.toJson((Object)requestBody))).build();
            HttpResponse<String> response = this.client.send(request, HttpResponse.BodyHandlers.ofString());
            return (SkinResponse)GSON.fromJson(response.body(), SkinResponse.class);
        }
        catch (JsonParseException | IOException | InterruptedException e) {
            throw new MineSkinProxyClientException("Failed to get skin for: " + url, e);
        }
    }
}

