/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.client.gui.screen;

import io.wispforest.owo.ui.base.BaseUIModelScreen;
import io.wispforest.owo.ui.component.ButtonComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.container.Containers;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import io.wispforest.owo.ui.core.Surface;
import java.util.List;
import me.sailex.secondbrain.client.gui.screen.BaseConfigScreen;
import me.sailex.secondbrain.client.gui.screen.NPCConfigScreen;
import me.sailex.secondbrain.client.networking.ClientNetworkManager;
import me.sailex.secondbrain.config.BaseConfig;
import me.sailex.secondbrain.config.NPCConfig;
import me.sailex.secondbrain.llm.LLMType;
import me.sailex.secondbrain.networking.packet.CreateNpcPacket;
import me.sailex.secondbrain.networking.packet.DeleteNpcPacket;
import net.minecraft.class_2561;
import net.minecraft.class_2960;
import net.minecraft.class_437;

public class SecondBrainScreen
extends BaseUIModelScreen<FlowLayout> {
    private static final class_2960 ID = class_2960.method_43902((String)"secondbrain", (String)"main");
    private final List<NPCConfig> npcConfig;
    private final BaseConfig baseConfig;
    private final ClientNetworkManager networkManager;

    public SecondBrainScreen(List<NPCConfig> npcConfig, BaseConfig baseConfig, ClientNetworkManager networkManager) {
        super(FlowLayout.class, BaseUIModelScreen.DataSource.asset((class_2960)ID));
        this.npcConfig = npcConfig;
        this.baseConfig = baseConfig;
        this.networkManager = networkManager;
    }

    protected void build(FlowLayout rootComponent) {
        FlowLayout panelComponent = (FlowLayout)rootComponent.childById(FlowLayout.class, "npc");
        this.npcConfig.forEach(config -> this.addNpcComponent(panelComponent, (NPCConfig)config));
        ((ButtonComponent)rootComponent.childById(ButtonComponent.class, "add_npc")).onPress(button -> this.field_22787.method_1507((class_437)new NPCConfigScreen(this.networkManager, new NPCConfig(), false)));
        ((ButtonComponent)rootComponent.childById(ButtonComponent.class, "edit_base")).onPress(button -> this.field_22787.method_1507((class_437)new BaseConfigScreen(this.networkManager, this.baseConfig, true)));
    }

    private void addNpcComponent(FlowLayout panelComponent, NPCConfig config) {
        FlowLayout npcContainer = Containers.verticalFlow((Sizing)Sizing.fixed((int)139), (Sizing)Sizing.content());
        npcContainer.margins(Insets.bottom((int)1));
        npcContainer.surface(Surface.DARK_PANEL).padding(Insets.of((int)10));
        FlowLayout npcLabelContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        npcLabelContainer.gap(2);
        npcLabelContainer.child((Component)Components.label((class_2561)class_2561.method_30163((String)config.getNpcName())));
        this.addTypeSpecificLabelTexture(npcLabelContainer, config);
        npcContainer.child((Component)npcLabelContainer);
        FlowLayout npcButtonContainer = Containers.horizontalFlow((Sizing)Sizing.content(), (Sizing)Sizing.content());
        npcButtonContainer.gap(2);
        this.addNpcSpawnButton(npcButtonContainer, config);
        this.addNpcEditButton(npcButtonContainer, config);
        this.addNpcDeleteButton(npcButtonContainer, config);
        npcContainer.child((Component)npcButtonContainer);
        panelComponent.child((Component)npcContainer);
    }

    private void addTypeSpecificLabelTexture(FlowLayout npcLabelContainer, NPCConfig config) {
        npcLabelContainer.child(Components.texture((class_2960)class_2960.method_43902((String)"secondbrain", (String)(switch (config.getLlmType()) {
            case LLMType.OLLAMA -> "ollama-icon.png";
            case LLMType.PLAYER2 -> "player2-icon.png";
            default -> "icon.png";
        })), (int)0, (int)0, (int)55, (int)55, (int)55, (int)55).sizing(Sizing.fixed((int)8), Sizing.fixed((int)8)));
    }

    private void addNpcSpawnButton(FlowLayout npcButtonContainer, NPCConfig config) {
        npcButtonContainer.child((Component)Components.button((class_2561)this.isActiveText(config), button -> {
            if (config.isActive()) {
                this.networkManager.sendPacket(new DeleteNpcPacket(config.getUuid().toString(), false));
            } else {
                this.networkManager.sendPacket(new CreateNpcPacket(config));
            }
            this.method_25419();
        }));
    }

    private void addNpcEditButton(FlowLayout npcButtonContainer, NPCConfig config) {
        if (!config.isActive() || config.getLlmType() == LLMType.PLAYER2) {
            npcButtonContainer.child((Component)Components.button((class_2561)class_2561.method_30163((String)"Edit"), button -> this.field_22787.method_1507((class_437)new NPCConfigScreen(this.networkManager, config, true))));
        }
    }

    private void addNpcDeleteButton(FlowLayout npcButtonContainer, NPCConfig config) {
        npcButtonContainer.child((Component)Components.button((class_2561)class_2561.method_30163((String)"Delete"), button -> {
            this.networkManager.sendPacket(new DeleteNpcPacket(config.getUuid().toString(), true));
            this.method_25419();
        }));
    }

    private class_2561 isActiveText(NPCConfig npcConfig) {
        return class_2561.method_30163((String)(npcConfig.isActive() ? "Despawn" : "Spawn"));
    }
}

