/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.sailex.altoclef.AltoClefController;
import me.sailex.automatone.api.BaritoneAPI;
import me.sailex.automatone.api.IBaritone;
import me.sailex.secondbrain.callback.NPCEvents;
import me.sailex.secondbrain.common.NPCSpawner;
import me.sailex.secondbrain.config.BaseConfig;
import me.sailex.secondbrain.config.ConfigProvider;
import me.sailex.secondbrain.config.NPCConfig;
import me.sailex.secondbrain.constant.Instructions;
import me.sailex.secondbrain.context.ContextProvider;
import me.sailex.secondbrain.database.resources.ResourceProvider;
import me.sailex.secondbrain.event.NPCEventHandler;
import me.sailex.secondbrain.exception.NPCCreationException;
import me.sailex.secondbrain.history.ConversationHistory;
import me.sailex.secondbrain.history.Message;
import me.sailex.secondbrain.llm.LLMClient;
import me.sailex.secondbrain.llm.LLMType;
import me.sailex.secondbrain.llm.ollama.OllamaClient;
import me.sailex.secondbrain.llm.openai.OpenAiClient;
import me.sailex.secondbrain.llm.player2.Player2APIClient;
import me.sailex.secondbrain.model.NPC;
import me.sailex.secondbrain.model.database.Conversation;
import me.sailex.secondbrain.util.LogUtil;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000|\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0006\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\b\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 <2\u00020\u0001:\u0001<B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0006\u0010\u0007J\r\u0010\t\u001a\u00020\b\u00a2\u0006\u0004\b\t\u0010\nJ1\u0010\u0013\u001a\u00020\b2\u0006\u0010\f\u001a\u00020\u000b2\u0006\u0010\u000e\u001a\u00020\r2\b\u0010\u0010\u001a\u0004\u0018\u00010\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u0011\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0019\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u001d\u0010\u001b\u001a\u00020\b2\u0006\u0010\u0016\u001a\u00020\u00152\u0006\u0010\u0018\u001a\u00020\u0017\u00a2\u0006\u0004\b\u001b\u0010\u001aJ\u0015\u0010\u001c\u001a\u00020\b2\u0006\u0010\u000e\u001a\u00020\r\u00a2\u0006\u0004\b\u001c\u0010\u001dJ'\u0010$\u001a\u00020#2\u0006\u0010\u001f\u001a\u00020\u001e2\u0006\u0010 \u001a\u00020\u000b2\u0006\u0010\"\u001a\u00020!H\u0002\u00a2\u0006\u0004\b$\u0010%J\u0017\u0010'\u001a\u00020&2\u0006\u0010\u001f\u001a\u00020\u001eH\u0002\u00a2\u0006\u0004\b'\u0010(J\u0017\u0010)\u001a\u00020!2\u0006\u0010 \u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b)\u0010*J\u0017\u0010-\u001a\u00020\b2\u0006\u0010,\u001a\u00020+H\u0002\u00a2\u0006\u0004\b-\u0010.J\u000f\u0010/\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b/\u0010\nJ\u0017\u00100\u001a\u00020\u000b2\u0006\u0010\f\u001a\u00020\u000bH\u0002\u00a2\u0006\u0004\b0\u00101R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u00102R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u00103R\u0016\u00105\u001a\u0002048\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b5\u00106R#\u00108\u001a\u000e\u0012\u0004\u0012\u00020\u0015\u0012\u0004\u0012\u00020#078\u0006\u00a2\u0006\f\n\u0004\b8\u00109\u001a\u0004\b:\u0010;\u00a8\u0006="}, d2={"Lme/sailex/secondbrain/common/NPCFactory;", "", "Lme/sailex/secondbrain/config/ConfigProvider;", "configProvider", "Lme/sailex/secondbrain/database/resources/ResourceProvider;", "resourceProvider", "<init>", "(Lme/sailex/secondbrain/config/ConfigProvider;Lme/sailex/secondbrain/database/resources/ResourceProvider;)V", "", "init", "()V", "Lme/sailex/secondbrain/config/NPCConfig;", "newConfig", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_2338;", "spawnPos", "Lnet/minecraft/class_1657;", "owner", "createNpc", "(Lme/sailex/secondbrain/config/NPCConfig;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_2338;Lnet/minecraft/class_1657;)V", "Ljava/util/UUID;", "uuid", "Lnet/minecraft/class_3324;", "playerManager", "removeNpc", "(Ljava/util/UUID;Lnet/minecraft/class_3324;)V", "deleteNpc", "shutdownNPCs", "(Lnet/minecraft/server/MinecraftServer;)V", "Lnet/minecraft/class_3222;", "npcEntity", "config", "Lme/sailex/secondbrain/llm/LLMClient;", "llmClient", "Lme/sailex/secondbrain/model/NPC;", "createNpcInstance", "(Lnet/minecraft/class_3222;Lme/sailex/secondbrain/config/NPCConfig;Lme/sailex/secondbrain/llm/LLMClient;)Lme/sailex/secondbrain/model/NPC;", "Lme/sailex/altoclef/AltoClefController;", "initController", "(Lnet/minecraft/class_3222;)Lme/sailex/altoclef/AltoClefController;", "initLLMClient", "(Lme/sailex/secondbrain/config/NPCConfig;)Lme/sailex/secondbrain/llm/LLMClient;", "", "npcName", "checkNpcName", "(Ljava/lang/String;)V", "checkLimit", "updateConfig", "(Lme/sailex/secondbrain/config/NPCConfig;)Lme/sailex/secondbrain/config/NPCConfig;", "Lme/sailex/secondbrain/config/ConfigProvider;", "Lme/sailex/secondbrain/database/resources/ResourceProvider;", "Ljava/util/concurrent/ExecutorService;", "executorService", "Ljava/util/concurrent/ExecutorService;", "Ljava/util/concurrent/ConcurrentHashMap;", "uuidToNpc", "Ljava/util/concurrent/ConcurrentHashMap;", "getUuidToNpc", "()Ljava/util/concurrent/ConcurrentHashMap;", "Companion", "1.20.1"})
@SourceDebugExtension(value={"SMAP\nNPCFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NPCFactory.kt\nme/sailex/secondbrain/common/NPCFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,166:1\n1863#2,2:167\n1557#2:169\n1628#2,3:170\n1755#2,3:173\n*S KotlinDebug\n*F\n+ 1 NPCFactory.kt\nme/sailex/secondbrain/common/NPCFactory\n*L\n104#1:167,2\n118#1:169\n118#1:170,3\n143#1:173,3\n*E\n"})
public final class NPCFactory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ConfigProvider configProvider;
    @NotNull
    private final ResourceProvider resourceProvider;
    private ExecutorService executorService;
    @NotNull
    private final ConcurrentHashMap<UUID, NPC> uuidToNpc;
    private static final int MAX_NUMBER_OF_NPC = 10;

    public NPCFactory(@NotNull ConfigProvider configProvider, @NotNull ResourceProvider resourceProvider) {
        Intrinsics.checkNotNullParameter((Object)configProvider, (String)"configProvider");
        Intrinsics.checkNotNullParameter((Object)resourceProvider, (String)"resourceProvider");
        this.configProvider = configProvider;
        this.resourceProvider = resourceProvider;
        this.uuidToNpc = new ConcurrentHashMap();
    }

    @NotNull
    public final ConcurrentHashMap<UUID, NPC> getUuidToNpc() {
        return this.uuidToNpc;
    }

    public final void init() {
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public final void createNpc(@NotNull NPCConfig newConfig, @NotNull MinecraftServer server, @Nullable class_2338 spawnPos, @Nullable class_1657 owner) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Runnable runnable = () -> NPCFactory.createNpc$lambda$2(newConfig, this, server, spawnPos, owner);
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executorService");
            executorService = null;
        }
        CompletableFuture.runAsync(runnable, executorService).exceptionally(NPCFactory::createNpc$lambda$3);
    }

    public final void removeNpc(@NotNull UUID uuid, @NotNull class_3324 playerManager) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        NPC npcToRemove = this.uuidToNpc.get(uuid);
        if (npcToRemove != null) {
            npcToRemove.getController().stop();
            npcToRemove.getLlmClient().stopService();
            npcToRemove.getEventHandler().stopService();
            npcToRemove.getContextProvider().getChunkManager().stopService();
            this.resourceProvider.addConversations(uuid, npcToRemove.getHistory().getLatestConversations());
            this.uuidToNpc.remove(uuid);
            NPCConfig nPCConfig = this.configProvider.getNpcConfig(uuid).get();
            Intrinsics.checkNotNullExpressionValue((Object)nPCConfig, (String)"get(...)");
            NPCConfig config = nPCConfig;
            config.setActive(false);
            NPCSpawner.remove(npcToRemove.getEntity().method_5667(), playerManager);
            LogUtil.infoInChat("Removed NPC with name " + config.getNpcName());
        }
    }

    public final void deleteNpc(@NotNull UUID uuid, @NotNull class_3324 playerManager) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        this.resourceProvider.getLoadedConversations().remove(uuid);
        this.resourceProvider.getConversationRepository().deleteByUuid(uuid);
        this.removeNpc(uuid, playerManager);
        this.configProvider.deleteNpcConfig(uuid);
    }

    public final void shutdownNPCs(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Set set = this.uuidToNpc.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            class_3324 class_33242 = server.method_3760();
            Intrinsics.checkNotNullExpressionValue((Object)class_33242, (String)"getPlayerManager(...)");
            this.removeNpc(it, class_33242);
        }
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executorService");
            executorService = null;
        }
        executorService.shutdownNow();
    }

    /*
     * Unable to fully structure code
     * Could not resolve type clashes
     */
    private final NPC createNpcInstance(class_3222 npcEntity, NPCConfig config, LLMClient llmClient) {
        baseConfig = this.configProvider.getBaseConfig();
        contextProvider = new ContextProvider(npcEntity, baseConfig);
        controller = this.initController(npcEntity);
        defaultPrompt = Instructions.getLlmSystemPrompt(config.getNpcName(), config.getLlmCharacter(), controller.getCommandExecutor().allCommands());
        var9_8 = this.resourceProvider.getLoadedConversations().get(npcEntity.method_5667());
        if (var9_8 == null) ** GOTO lbl-1000
        var11_9 = var9_8;
        $i$f$map = false;
        var13_11 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var18_16 = (Conversation)item$iv$iv;
            var20_18 = destination$iv$iv;
            $i$a$-map-NPCFactory$createNpcInstance$messages$1 = false;
            var20_18.add(new Message(it.getMessage(), it.getRole()));
        }
        var11_9 = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if (var11_9 != null) {
            v0 /* !! */  = var11_9;
        } else lbl-1000:
        // 2 sources

        {
            v0 /* !! */  = new ArrayList<E>();
        }
        messages = v0 /* !! */ ;
        Intrinsics.checkNotNull((Object)defaultPrompt);
        history = new ConversationHistory(llmClient, defaultPrompt, messages);
        eventHandler = new NPCEventHandler(llmClient, history, contextProvider, controller, config);
        return new NPC(npcEntity, llmClient, history, eventHandler, controller, contextProvider, config);
    }

    private final AltoClefController initController(class_3222 npcEntity) {
        IBaritone automatone = BaritoneAPI.getProvider().getBaritone(npcEntity);
        return new AltoClefController(automatone);
    }

    private final LLMClient initLLMClient(NPCConfig config) {
        BaseConfig baseConfig = this.configProvider.getBaseConfig();
        LLMType lLMType = config.getLlmType();
        LLMClient llmClient = switch (lLMType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[lLMType.ordinal()]) {
            case 1 -> new OllamaClient(config.getLlmModel(), config.getOllamaUrl(), baseConfig.getLlmTimeout(), baseConfig.isVerbose());
            case 2 -> new OpenAiClient(config.getLlmModel(), config.getOpenaiApiKey(), baseConfig.getLlmTimeout());
            case 3 -> new Player2APIClient(config.getVoiceId(), config.getNpcName(), baseConfig.getLlmTimeout());
            default -> throw new NPCCreationException("Invalid LLM type: " + config.getLlmType());
        };
        llmClient.checkServiceIsReachable();
        return llmClient;
    }

    private final void checkNpcName(String npcName) {
        boolean bl;
        block4: {
            Collection<NPC> collection = this.uuidToNpc.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    NPC it = (NPC)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getEntity().method_5477().getString(), (Object)npcName)) continue;
                    bl = true;
                    break block4;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new NPCCreationException("A NPC with the name '" + npcName + "' already exists.");
        }
    }

    private final void checkLimit() {
        if (this.uuidToNpc.size() == 10) {
            throw new NPCCreationException("Currently there are no more than10 parallel running NPCs supported!");
        }
    }

    private final NPCConfig updateConfig(NPCConfig newConfig) {
        Optional<NPCConfig> config = this.configProvider.getNpcConfigByName(newConfig.getNpcName());
        if (config.isEmpty()) {
            NPCConfig nPCConfig = this.configProvider.addNpcConfig(newConfig);
            Intrinsics.checkNotNullExpressionValue((Object)nPCConfig, (String)"addNpcConfig(...)");
            return nPCConfig;
        }
        config.get().setActive(true);
        NPCConfig nPCConfig = config.get();
        Intrinsics.checkNotNullExpressionValue((Object)nPCConfig, (String)"get(...)");
        return nPCConfig;
    }

    private static final void createNpc$lambda$2$lambda$0(NPCConfig $config, NPCFactory this$0, LLMClient $llmClient, class_1657 $owner, String $name, class_3222 npcEntity) {
        $config.setUuid(npcEntity.method_5667());
        Intrinsics.checkNotNull((Object)npcEntity);
        NPC npc = this$0.createNpcInstance(npcEntity, $config, $llmClient);
        npc.getController().setOwner($owner);
        ((Map)this$0.uuidToNpc).put($config.getUuid(), npc);
        LogUtil.infoInChat("Added NPC with name: " + $name);
        npc.getEventHandler().onEvent("You have just spawned into the world. \nGreet your owner warmly, introduce yourself in character, and show readiness to help. \nThen begin with a simple task, like gathering wood, unless the player gives you another task.\n");
    }

    private static final void createNpc$lambda$2$lambda$1(NPCFactory this$0, class_3222 it) {
        UUID uUID = it.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        MinecraftServer minecraftServer = it.field_13995;
        Intrinsics.checkNotNull((Object)minecraftServer);
        class_3324 class_33242 = minecraftServer.method_3760();
        Intrinsics.checkNotNullExpressionValue((Object)class_33242, (String)"getPlayerManager(...)");
        this$0.removeNpc(uUID, class_33242);
    }

    private static final void createNpc$lambda$2(NPCConfig $newConfig, NPCFactory this$0, MinecraftServer $server, class_2338 $spawnPos, class_1657 $owner) {
        String name = $newConfig.getNpcName();
        this$0.checkLimit();
        Intrinsics.checkNotNull((Object)name);
        this$0.checkNpcName(name);
        NPCConfig config = this$0.updateConfig($newConfig);
        LLMClient llmClient = this$0.initLLMClient(config);
        NPCSpawner.spawn(config, $server, $spawnPos, arg_0 -> NPCFactory.createNpc$lambda$2$lambda$0(config, this$0, llmClient, $owner, name, arg_0));
        NPCEvents.ON_DEATH.register(arg_0 -> NPCFactory.createNpc$lambda$2$lambda$1(this$0, arg_0));
    }

    private static final Void createNpc$lambda$3(Throwable it) {
        LogUtil.errorInChat(it.getMessage());
        LogUtil.error(it);
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/sailex/secondbrain/common/NPCFactory$Companion;", "", "<init>", "()V", "", "MAX_NUMBER_OF_NPC", "I", "1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LLMType.values().length];
            try {
                nArray[LLMType.OLLAMA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.OPENAI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.PLAYER2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

