/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.event;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.util.Arrays;
import java.util.Locale;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.sailex.altoclef.AltoClefController;
import me.sailex.altoclef.commandsystem.CommandException;
import me.sailex.altoclef.commandsystem.CommandExecutor;
import me.sailex.altoclef.tasks.LookAtOwnerTask;
import me.sailex.altoclef.tasksystem.Task;
import me.sailex.secondbrain.config.NPCConfig;
import me.sailex.secondbrain.context.ContextProvider;
import me.sailex.secondbrain.event.EventHandler;
import me.sailex.secondbrain.history.ConversationHistory;
import me.sailex.secondbrain.history.Message;
import me.sailex.secondbrain.llm.LLMClient;
import me.sailex.secondbrain.llm.player2.Player2APIClient;
import me.sailex.secondbrain.llm.roles.Player2ChatRole;
import me.sailex.secondbrain.util.LogUtil;
import me.sailex.secondbrain.util.PromptFormatter;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000T\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\u0002\n\u0002\b\u0005\n\u0002\u0010\u000b\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0018\u0002\n\u0002\b\u0005\u0018\u0000 )2\u00020\u0001:\u0002)*B/\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u0012\u0006\u0010\t\u001a\u00020\b\u0012\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001f\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u000f\u001a\u00020\u000e2\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0013\u001a\u00020\u00122\u0006\u0010\u0011\u001a\u00020\u0010H\u0016\u00a2\u0006\u0004\b\u0013\u0010\u0015J\u000f\u0010\u0016\u001a\u00020\u0012H\u0016\u00a2\u0006\u0004\b\u0016\u0010\u0017J\u000f\u0010\u0019\u001a\u00020\u0018H\u0016\u00a2\u0006\u0004\b\u0019\u0010\u001aJ\u0015\u0010\u001d\u001a\u00020\u001c2\u0006\u0010\u001b\u001a\u00020\u0010\u00a2\u0006\u0004\b\u001d\u0010\u001eJ\u0015\u0010 \u001a\u00020\u00122\u0006\u0010\u001f\u001a\u00020\u0010\u00a2\u0006\u0004\b \u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010!R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\"R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010#R\u0014\u0010\t\u001a\u00020\b8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\t\u0010$R\u0014\u0010\u000b\u001a\u00020\n8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u000b\u0010%R\u0014\u0010'\u001a\u00020&8\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b'\u0010(\u00a8\u0006+"}, d2={"Lme/sailex/secondbrain/event/NPCEventHandler;", "Lme/sailex/secondbrain/event/EventHandler;", "Lme/sailex/secondbrain/llm/LLMClient;", "llmClient", "Lme/sailex/secondbrain/history/ConversationHistory;", "history", "Lme/sailex/secondbrain/context/ContextProvider;", "contextProvider", "Lme/sailex/altoclef/AltoClefController;", "controller", "Lme/sailex/secondbrain/config/NPCConfig;", "config", "<init>", "(Lme/sailex/secondbrain/llm/LLMClient;Lme/sailex/secondbrain/history/ConversationHistory;Lme/sailex/secondbrain/context/ContextProvider;Lme/sailex/altoclef/AltoClefController;Lme/sailex/secondbrain/config/NPCConfig;)V", "Lme/sailex/secondbrain/llm/roles/Player2ChatRole;", "role", "", "prompt", "", "onEvent", "(Lme/sailex/secondbrain/llm/roles/Player2ChatRole;Ljava/lang/String;)V", "(Ljava/lang/String;)V", "stopService", "()V", "", "queueIsEmpty", "()Z", "content", "Lme/sailex/secondbrain/event/NPCEventHandler$CommandMessage;", "parse", "(Ljava/lang/String;)Lme/sailex/secondbrain/event/NPCEventHandler$CommandMessage;", "command", "execute", "Lme/sailex/secondbrain/llm/LLMClient;", "Lme/sailex/secondbrain/history/ConversationHistory;", "Lme/sailex/secondbrain/context/ContextProvider;", "Lme/sailex/altoclef/AltoClefController;", "Lme/sailex/secondbrain/config/NPCConfig;", "Ljava/util/concurrent/ThreadPoolExecutor;", "executorService", "Ljava/util/concurrent/ThreadPoolExecutor;", "Companion", "CommandMessage", "1.21.8"})
public final class NPCEventHandler
implements EventHandler {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LLMClient llmClient;
    @NotNull
    private final ConversationHistory history;
    @NotNull
    private final ContextProvider contextProvider;
    @NotNull
    private final AltoClefController controller;
    @NotNull
    private final NPCConfig config;
    @NotNull
    private final ThreadPoolExecutor executorService;
    private static final Gson gson = new GsonBuilder().setLenient().create();

    public NPCEventHandler(@NotNull LLMClient llmClient, @NotNull ConversationHistory history, @NotNull ContextProvider contextProvider, @NotNull AltoClefController controller, @NotNull NPCConfig config) {
        Intrinsics.checkNotNullParameter((Object)llmClient, (String)"llmClient");
        Intrinsics.checkNotNullParameter((Object)history, (String)"history");
        Intrinsics.checkNotNullParameter((Object)contextProvider, (String)"contextProvider");
        Intrinsics.checkNotNullParameter((Object)controller, (String)"controller");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        this.llmClient = llmClient;
        this.history = history;
        this.contextProvider = contextProvider;
        this.controller = controller;
        this.config = config;
        this.executorService = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, (BlockingQueue<Runnable>)new ArrayBlockingQueue(10), new ThreadPoolExecutor.DiscardPolicy());
    }

    @Override
    public void onEvent(@NotNull Player2ChatRole role, @NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)role, (String)"role");
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        CompletableFuture.runAsync(() -> NPCEventHandler.onEvent$lambda$0(prompt, role, this), this.executorService).exceptionally(arg_0 -> NPCEventHandler.onEvent$lambda$1(prompt, arg_0));
    }

    @Override
    public void onEvent(@NotNull String prompt) {
        Intrinsics.checkNotNullParameter((Object)prompt, (String)"prompt");
        this.onEvent(Player2ChatRole.USER, prompt);
    }

    @Override
    public void stopService() {
        this.executorService.shutdownNow();
    }

    @Override
    public boolean queueIsEmpty() {
        return this.executorService.getQueue().isEmpty();
    }

    @NotNull
    public final CommandMessage parse(@NotNull String content) {
        Intrinsics.checkNotNullParameter((Object)content, (String)"content");
        CommandMessage message = (CommandMessage)gson.fromJson(content, CommandMessage.class);
        Intrinsics.checkNotNull((Object)message);
        return message;
    }

    public final void execute(@NotNull String command) {
        Intrinsics.checkNotNullParameter((Object)command, (String)"command");
        CommandExecutor cmdExecutor = this.controller.getCommandExecutor();
        String commandWithPrefix = cmdExecutor.isClientCommand(command) ? command : cmdExecutor.getCommandPrefix() + command;
        cmdExecutor.execute(commandWithPrefix, () -> NPCEventHandler.execute$lambda$2(this), arg_0 -> NPCEventHandler.execute$lambda$3(this, commandWithPrefix, arg_0));
    }

    private static final void onEvent$lambda$0(String $prompt, Player2ChatRole $role, NPCEventHandler this$0) {
        LogUtil.info("onEvent: " + $prompt);
        Object formattedPrompt = null;
        formattedPrompt = $role == Player2ChatRole.USER ? PromptFormatter.format($prompt, this$0.contextProvider.buildContext()) : "system prompt: " + $prompt;
        ConversationHistory conversationHistory = this$0.history;
        String string = $role.toString().toLowerCase(Locale.ROOT);
        Intrinsics.checkNotNullExpressionValue((Object)string, (String)"toLowerCase(...)");
        conversationHistory.add(new Message((String)formattedPrompt, string));
        Message response = this$0.llmClient.chat(this$0.history.getLatestConversations());
        ConversationHistory conversationHistory2 = this$0.history;
        Intrinsics.checkNotNull((Object)response);
        conversationHistory2.add(response);
        CommandMessage parsedMessage = this$0.parse(response.getMessage());
        this$0.execute(parsedMessage.getCommand());
        if (!Intrinsics.areEqual((Object)parsedMessage.getMessage(), (Object)this$0.history.getLastMessage())) {
            if (this$0.llmClient instanceof Player2APIClient && this$0.config.isTTS()) {
                ((Player2APIClient)this$0.llmClient).startTextToSpeech(parsedMessage.getMessage());
            } else {
                this$0.controller.getControllerExtras().chat(parsedMessage.getMessage());
            }
        }
    }

    private static final Void onEvent$lambda$1(String $prompt, Throwable it) {
        LogUtil.debugInChat("Could not generate a response for prompt: " + $prompt);
        LogUtil.error("Error occurred handling event: " + $prompt, it.getCause());
        return null;
    }

    private static final void execute$lambda$2(NPCEventHandler this$0) {
        this$0.controller.runUserTask((Task)new LookAtOwnerTask());
    }

    private static final void execute$lambda$3(NPCEventHandler this$0, String $commandWithPrefix, CommandException it) {
        String string = "Command %s failed. Error content: %s";
        Object[] objectArray = new Object[]{$commandWithPrefix, it.getMessage()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        this$0.onEvent(string2);
        LogUtil.error("Error executing command: " + $commandWithPrefix, (Throwable)it);
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000 \n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0010\u000e\n\u0002\b\n\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0007\b\u0086\b\u0018\u00002\u00020\u0001B\u0017\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0004\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0005\u0010\u0006J\u0010\u0010\u0007\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\t\u001a\u00020\u0002H\u00c6\u0003\u00a2\u0006\u0004\b\t\u0010\bJ$\u0010\n\u001a\u00020\u00002\b\b\u0002\u0010\u0003\u001a\u00020\u00022\b\b\u0002\u0010\u0004\u001a\u00020\u0002H\u00c6\u0001\u00a2\u0006\u0004\b\n\u0010\u000bJ\u001a\u0010\u000e\u001a\u00020\r2\b\u0010\f\u001a\u0004\u0018\u00010\u0001H\u00d6\u0003\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0010\u0010\u0011\u001a\u00020\u0010H\u00d6\u0001\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0010\u0010\u0013\u001a\u00020\u0002H\u00d6\u0001\u00a2\u0006\u0004\b\u0013\u0010\bR\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0014\u001a\u0004\b\u0015\u0010\bR\u0017\u0010\u0004\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0004\u0010\u0014\u001a\u0004\b\u0016\u0010\b\u00a8\u0006\u0017"}, d2={"Lme/sailex/secondbrain/event/NPCEventHandler$CommandMessage;", "", "", "command", "message", "<init>", "(Ljava/lang/String;Ljava/lang/String;)V", "component1", "()Ljava/lang/String;", "component2", "copy", "(Ljava/lang/String;Ljava/lang/String;)Lme/sailex/secondbrain/event/NPCEventHandler$CommandMessage;", "other", "", "equals", "(Ljava/lang/Object;)Z", "", "hashCode", "()I", "toString", "Ljava/lang/String;", "getCommand", "getMessage", "1.21.8"})
    public static final class CommandMessage {
        @NotNull
        private final String command;
        @NotNull
        private final String message;

        public CommandMessage(@NotNull String command, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            this.command = command;
            this.message = message;
        }

        @NotNull
        public final String getCommand() {
            return this.command;
        }

        @NotNull
        public final String getMessage() {
            return this.message;
        }

        @NotNull
        public final String component1() {
            return this.command;
        }

        @NotNull
        public final String component2() {
            return this.message;
        }

        @NotNull
        public final CommandMessage copy(@NotNull String command, @NotNull String message) {
            Intrinsics.checkNotNullParameter((Object)command, (String)"command");
            Intrinsics.checkNotNullParameter((Object)message, (String)"message");
            return new CommandMessage(command, message);
        }

        public static /* synthetic */ CommandMessage copy$default(CommandMessage commandMessage, String string, String string2, int n, Object object) {
            if ((n & 1) != 0) {
                string = commandMessage.command;
            }
            if ((n & 2) != 0) {
                string2 = commandMessage.message;
            }
            return commandMessage.copy(string, string2);
        }

        @NotNull
        public String toString() {
            return "CommandMessage(command=" + this.command + ", message=" + this.message + ")";
        }

        public int hashCode() {
            int result = this.command.hashCode();
            result = result * 31 + this.message.hashCode();
            return result;
        }

        public boolean equals(@Nullable Object other) {
            if (this == other) {
                return true;
            }
            if (!(other instanceof CommandMessage)) {
                return false;
            }
            CommandMessage commandMessage = (CommandMessage)other;
            if (!Intrinsics.areEqual((Object)this.command, (Object)commandMessage.command)) {
                return false;
            }
            return Intrinsics.areEqual((Object)this.message, (Object)commandMessage.message);
        }
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u001c\u0010\u0006\u001a\n \u0005*\u0004\u0018\u00010\u00040\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0006\u0010\u0007\u00a8\u0006\b"}, d2={"Lme/sailex/secondbrain/event/NPCEventHandler$Companion;", "", "<init>", "()V", "Lcom/google/gson/Gson;", "kotlin.jvm.PlatformType", "gson", "Lcom/google/gson/Gson;", "1.21.8"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

