/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.client.gui.screen;

import io.wispforest.owo.ui.component.CheckboxComponent;
import io.wispforest.owo.ui.component.Components;
import io.wispforest.owo.ui.component.DropdownComponent;
import io.wispforest.owo.ui.component.LabelComponent;
import io.wispforest.owo.ui.component.TextAreaComponent;
import io.wispforest.owo.ui.container.FlowLayout;
import io.wispforest.owo.ui.core.Component;
import io.wispforest.owo.ui.core.Insets;
import io.wispforest.owo.ui.core.Sizing;
import me.sailex.secondbrain.client.gui.screen.ConfigScreen;
import me.sailex.secondbrain.client.networking.ClientNetworkManager;
import me.sailex.secondbrain.config.NPCConfig;
import me.sailex.secondbrain.llm.LLMType;
import me.sailex.secondbrain.networking.packet.CreateNpcPacket;
import me.sailex.secondbrain.networking.packet.UpdateNpcConfigPacket;
import net.minecraft.class_2561;
import net.minecraft.class_2960;

public class NPCConfigScreen
extends ConfigScreen<NPCConfig> {
    private static final class_2960 ID = class_2960.method_60655((String)"secondbrain", (String)"npcconfig");

    public NPCConfigScreen(ClientNetworkManager networkManager, NPCConfig npcConfig, boolean isEdit) {
        super(networkManager, npcConfig, isEdit, ID);
    }

    @Override
    protected void build(FlowLayout rootComponent) {
        FlowLayout panel = (FlowLayout)rootComponent.childById(FlowLayout.class, "panel");
        LabelComponent npcNameLabel = (LabelComponent)panel.childById(LabelComponent.class, "npcName-label");
        if (this.isEdit) {
            npcNameLabel.text(class_2561.method_30163((String)"Edit '%s'".formatted(((NPCConfig)this.config).getNpcName())));
        } else {
            npcNameLabel.text(class_2561.method_30163((String)"Name of the NPC"));
            TextAreaComponent npcName = Components.textArea((Sizing)Sizing.fill((int)35), (Sizing)Sizing.fill((int)7)).text(((NPCConfig)this.config).getNpcName());
            npcName.onChanged().subscribe(((NPCConfig)this.config)::setNpcName);
            ((FlowLayout)panel.childById(FlowLayout.class, "npcName")).child((Component)npcName);
        }
        this.drawLLMTypeDropDown(panel);
        this.drawLLMModelInput(panel);
        this.drawLlmInfo(panel);
        this.onPressSaveButton(rootComponent, button -> {
            if (this.isEdit) {
                this.networkManager.sendPacket(new UpdateNpcConfigPacket((NPCConfig)this.config));
                this.method_25419();
            } else {
                this.networkManager.sendPacket(new CreateNpcPacket((NPCConfig)this.config));
                this.method_25419();
            }
        });
    }

    private void drawLlmInfo(FlowLayout panel) {
        FlowLayout llmInfo = (FlowLayout)panel.childById(FlowLayout.class, "llmInfo");
        llmInfo.clearChildren();
        TextAreaComponent llmInfoTextArea = Components.textArea((Sizing)Sizing.fill((int)35), (Sizing)Sizing.fill((int)7));
        switch (((NPCConfig)this.config).getLlmType()) {
            case OLLAMA: {
                llmInfo.child((Component)Components.label((class_2561)class_2561.method_30163((String)"Ollama URL")).shadow(true));
                llmInfoTextArea.text(((NPCConfig)this.config).getOllamaUrl()).onChanged().subscribe(((NPCConfig)this.config)::setOllamaUrl);
                llmInfo.child((Component)llmInfoTextArea);
                break;
            }
            case PLAYER2: {
                CheckboxComponent isTTS = Components.checkbox((class_2561)class_2561.method_30163((String)"Text to Speech")).checked(((NPCConfig)this.config).isTTS()).onChanged(listener -> ((NPCConfig)this.config).setTTS(!((NPCConfig)this.config).isTTS()));
                llmInfo.child((Component)isTTS);
                break;
            }
            case OPENAI: {
                llmInfo.child((Component)Components.label((class_2561)class_2561.method_30163((String)"OpenAI API Key")).shadow(true));
                llmInfoTextArea.text(((NPCConfig)this.config).getOpenaiApiKey()).onChanged().subscribe(((NPCConfig)this.config)::setOpenaiApiKey);
                llmInfo.child((Component)llmInfoTextArea);
            }
        }
        llmInfo.child((Component)Components.label((class_2561)class_2561.method_30163((String)"Characteristics")).shadow(true).margins(Insets.top((int)7)));
        TextAreaComponent llmCharacter = Components.textArea((Sizing)Sizing.fill((int)35), (Sizing)Sizing.fill((int)25));
        llmCharacter.text(((NPCConfig)this.config).getLlmCharacter()).onChanged().subscribe(((NPCConfig)this.config)::setLlmCharacter);
        llmInfo.child((Component)llmCharacter);
    }

    private void drawLLMTypeDropDown(FlowLayout panel) {
        ((LabelComponent)panel.childById(LabelComponent.class, "llmType-label")).text(class_2561.method_30163((String)"Type"));
        DropdownComponent llmTypeDropDown = (DropdownComponent)panel.childById(DropdownComponent.class, "llmType");
        if (this.isEdit) {
            llmTypeDropDown.button(class_2561.method_30163((String)((NPCConfig)this.config).getLlmType().toString()), button -> {});
        } else {
            llmTypeDropDown.button(class_2561.method_30163((String)LLMType.OLLAMA.toString()), button -> {
                ((NPCConfig)this.config).setLlmType(LLMType.OLLAMA);
                this.drawLlmInfo(panel);
            });
            llmTypeDropDown.button(class_2561.method_30163((String)LLMType.OPENAI.toString()), button -> {
                ((NPCConfig)this.config).setLlmType(LLMType.OPENAI);
                this.drawLlmInfo(panel);
            });
        }
    }

    private void drawLLMModelInput(FlowLayout panel) {
        ((LabelComponent)panel.childById(LabelComponent.class, "llmModel-label")).text(class_2561.method_30163((String)"LLM Model"));
        switch (((NPCConfig)this.config).getLlmType()) {
            case OLLAMA: 
            case OPENAI: {
                TextAreaComponent llmModel = Components.textArea((Sizing)Sizing.fill((int)17), (Sizing)Sizing.fill((int)7)).text(((NPCConfig)this.config).getLlmModel());
                llmModel.onChanged().subscribe(((NPCConfig)this.config)::setLlmModel);
                ((FlowLayout)panel.childById(FlowLayout.class, "llmModel")).child((Component)llmModel);
            }
        }
    }
}

