/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.history;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.util.Arrays;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import me.sailex.secondbrain.history.Message;
import me.sailex.secondbrain.llm.LLMClient;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0010!\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0002\b\u0004\n\u0002\u0010 \n\u0002\b\r\u0018\u0000 \u001d2\u00020\u0001:\u0001\u001dB%\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\f\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u0006\u00a2\u0006\u0004\b\t\u0010\nJ\u0015\u0010\r\u001a\u00020\f2\u0006\u0010\u000b\u001a\u00020\u0007\u00a2\u0006\u0004\b\r\u0010\u000eJ\u000f\u0010\u000f\u001a\u00020\fH\u0002\u00a2\u0006\u0004\b\u000f\u0010\u0010J\u001d\u0010\u0013\u001a\u00020\u00072\f\u0010\u0012\u001a\b\u0012\u0004\u0012\u00020\u00070\u0011H\u0002\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u0017\u0010\u0015\u001a\u00020\f2\u0006\u0010\u0005\u001a\u00020\u0004H\u0002\u00a2\u0006\u0004\b\u0015\u0010\u0016J\r\u0010\u0017\u001a\u00020\u0004\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0019R\u001d\u0010\b\u001a\b\u0012\u0004\u0012\u00020\u00070\u00068\u0006\u00a2\u0006\f\n\u0004\b\b\u0010\u001a\u001a\u0004\b\u001b\u0010\u001c\u00a8\u0006\u001e"}, d2={"Lme/sailex/secondbrain/history/ConversationHistory;", "", "Lme/sailex/secondbrain/llm/LLMClient;", "llmClient", "", "initMessage", "", "Lme/sailex/secondbrain/history/Message;", "latestConversations", "<init>", "(Lme/sailex/secondbrain/llm/LLMClient;Ljava/lang/String;Ljava/util/List;)V", "message", "", "add", "(Lme/sailex/secondbrain/history/Message;)V", "updateConversations", "()V", "", "conversations", "summarize", "(Ljava/util/List;)Lme/sailex/secondbrain/history/Message;", "setInitMessage", "(Ljava/lang/String;)V", "getLastMessage", "()Ljava/lang/String;", "Lme/sailex/secondbrain/llm/LLMClient;", "Ljava/util/List;", "getLatestConversations", "()Ljava/util/List;", "Companion", "1.21.1"})
public final class ConversationHistory {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final LLMClient llmClient;
    @NotNull
    private final List<Message> latestConversations;
    private static final int MAX_HISTORY_LENGTH = 30;
    @NotNull
    private static final ObjectMapper objectMapper = new ObjectMapper();

    public ConversationHistory(@NotNull LLMClient llmClient, @NotNull String initMessage, @NotNull List<Message> latestConversations) {
        Intrinsics.checkNotNullParameter((Object)llmClient, (String)"llmClient");
        Intrinsics.checkNotNullParameter((Object)initMessage, (String)"initMessage");
        Intrinsics.checkNotNullParameter(latestConversations, (String)"latestConversations");
        this.llmClient = llmClient;
        this.latestConversations = latestConversations;
        this.setInitMessage(initMessage);
    }

    @NotNull
    public final List<Message> getLatestConversations() {
        return this.latestConversations;
    }

    public final synchronized void add(@NotNull Message message) {
        Intrinsics.checkNotNullParameter((Object)message, (String)"message");
        this.latestConversations.add(message);
        if (this.latestConversations.size() >= 30) {
            this.updateConversations();
        }
    }

    private final void updateConversations() {
        int removeCount = 10;
        List toSummarize = CollectionsKt.toList((Iterable)this.latestConversations.subList(1, removeCount));
        Message message = this.summarize(toSummarize);
        this.latestConversations.removeAll(toSummarize);
        this.latestConversations.add(1, message);
    }

    private final Message summarize(List<Message> conversations) {
        String string = "Our AI agent has been chatting with the user and playing Minecraft.\nUpdate the agent's memory by summarizing the following conversation\n\nGuidelines:\n- Write in natural language, not JSON\n- Keep the summary under 500 characters\n- Preserve important facts, user requests, and useful tips\n- Exclude stats, inventory details, code, or documentation\n\nConversations:\n%s\n";
        Object[] objectArray = new Object[]{objectMapper.writeValueAsString(conversations)};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        Message summarizeMessage = new Message(string2, "user");
        Message message = this.llmClient.chat(CollectionsKt.listOf((Object)summarizeMessage));
        Intrinsics.checkNotNullExpressionValue((Object)message, (String)"chat(...)");
        return message;
    }

    private final void setInitMessage(String initMessage) {
        this.latestConversations.add(0, new Message(initMessage, "system"));
    }

    @NotNull
    public final String getLastMessage() {
        return ((Message)CollectionsKt.last(this.latestConversations)).getMessage();
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006R\u0014\u0010\b\u001a\u00020\u00078\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\b\u0010\t\u00a8\u0006\n"}, d2={"Lme/sailex/secondbrain/history/ConversationHistory$Companion;", "", "<init>", "()V", "", "MAX_HISTORY_LENGTH", "I", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "objectMapper", "Lcom/fasterxml/jackson/databind/ObjectMapper;", "1.21.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

