/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.context;

import java.util.ArrayList;
import java.util.List;
import me.sailex.secondbrain.config.BaseConfig;
import me.sailex.secondbrain.context.ChunkManager;
import me.sailex.secondbrain.model.context.EntityData;
import me.sailex.secondbrain.model.context.InventoryData;
import me.sailex.secondbrain.model.context.ItemData;
import me.sailex.secondbrain.model.context.StateData;
import me.sailex.secondbrain.model.context.WorldContext;
import me.sailex.secondbrain.util.MCDataUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1661;
import net.minecraft.class_1799;
import net.minecraft.class_3222;

public class ContextProvider {
    private final class_3222 npcEntity;
    private final ChunkManager chunkManager;
    private WorldContext cachedContext;

    public ContextProvider(class_3222 npcEntity, BaseConfig config) {
        this.npcEntity = npcEntity;
        this.chunkManager = new ChunkManager(npcEntity, config);
        this.buildContext();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public WorldContext buildContext() {
        ContextProvider contextProvider = this;
        synchronized (contextProvider) {
            WorldContext context;
            this.cachedContext = context = new WorldContext(this.getNpcState(), this.getInventoryState(), this.chunkManager.getNearbyBlocks(), this.getNearbyEntities());
            return context;
        }
    }

    private StateData getNpcState() {
        return new StateData(this.npcEntity.method_24515(), this.npcEntity.method_6032(), this.npcEntity.method_7344().method_7586(), MCDataUtil.getBiome((class_1297)this.npcEntity));
    }

    private InventoryData getInventoryState() {
        class_1661 inventory = this.npcEntity.method_31548();
        return new InventoryData(this.getItemsInRange(inventory, 36, 39), this.getItemsInRange(inventory, 9, 35), this.getItemsInRange(inventory, 0, 8), this.getItemsInRange(inventory, 40, 40));
    }

    private List<ItemData> getItemsInRange(class_1661 inventory, int start, int end) {
        ArrayList<ItemData> items = new ArrayList<ItemData>();
        for (int i = start; i <= end; ++i) {
            class_1799 stack = inventory.method_5438(i);
            this.addItemData(stack, items, i);
        }
        return items;
    }

    private void addItemData(class_1799 stack, List<ItemData> items, int slot) {
        if (!stack.method_7960()) {
            items.add(new ItemData(this.getBlockName(stack), stack.method_7947(), slot));
        }
    }

    private String getBlockName(class_1799 stack) {
        String translationKey = stack.method_7909().method_7876();
        return translationKey.substring(translationKey.lastIndexOf(".") + 1);
    }

    private List<EntityData> getNearbyEntities() {
        ArrayList nearbyEntities = new ArrayList();
        List<class_1297> entities = MCDataUtil.getNearbyEntities(this.npcEntity);
        entities.forEach(entity -> nearbyEntities.add(new EntityData(entity.method_5628(), entity.method_5477().getString(), entity.method_31747())));
        return nearbyEntities.stream().toList();
    }

    public ChunkManager getChunkManager() {
        return this.chunkManager;
    }

    public WorldContext getCachedContext() {
        return this.cachedContext;
    }
}

