/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.common;

import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import me.sailex.secondbrain.common.NPCFactory;
import me.sailex.secondbrain.config.ConfigProvider;
import me.sailex.secondbrain.config.NPCConfig;
import me.sailex.secondbrain.exception.LLMServiceException;
import me.sailex.secondbrain.llm.LLMType;
import me.sailex.secondbrain.llm.player2.Player2APIClient;
import me.sailex.secondbrain.llm.player2.model.Characters;
import me.sailex.secondbrain.model.NPC;
import me.sailex.secondbrain.util.LogUtil;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.server.MinecraftServer;

public class Player2NpcSynchronizer {
    private static final int MAX_NPC_COUNT = 8;
    private final NPCFactory npcFactory;
    private final ConfigProvider configProvider;
    private final Player2APIClient player2APIClient;
    private final ScheduledExecutorService executor;

    public Player2NpcSynchronizer(NPCFactory npcFactory, ConfigProvider configProvider) {
        this.npcFactory = npcFactory;
        this.configProvider = configProvider;
        this.player2APIClient = new Player2APIClient();
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.scheduleHeartBeats();
    }

    public void syncCharacters(class_2338 spawnPos, MinecraftServer server, class_1657 owner) {
        try {
            this.player2APIClient.getHealthStatus();
            List<Characters.Character> characters = this.player2APIClient.getSelectedCharacters().characters();
            if (characters.size() > 8) {
                LogUtil.errorInChat("You selected more than 8 characters in Player2. Limiting to 8");
            }
            Map<UUID, Characters.Character> uuidToChar = characters.stream().limit(8L).collect(Collectors.toMap(ch -> UUID.fromString(ch.id()), ch -> ch));
            List<UUID> currentNpcUuids = this.getNpcUuidsPlayer2();
            for (UUID uUID : currentNpcUuids) {
                this.npcFactory.deleteNpc(uUID, server.method_3760());
            }
            this.configProvider.deleteByType(LLMType.PLAYER2);
            for (Map.Entry entry : uuidToChar.entrySet()) {
                Characters.Character character = (Characters.Character)entry.getValue();
                NPCConfig config = NPCConfig.builder(character.short_name()).uuid((UUID)entry.getKey()).llmDefaultPrompt(character.description()).llmType(LLMType.PLAYER2).voiceId(character.voice_ids().get(0)).skinUrl(character.meta().skin_url()).build();
                this.npcFactory.createNpc(config, server, spawnPos, owner);
            }
        }
        catch (Exception e) {
            LogUtil.errorInChat(e.getMessage());
            LogUtil.error(e);
        }
    }

    public void syncCharacters(MinecraftServer server, class_1657 owner) {
        this.syncCharacters(null, server, owner);
    }

    private void scheduleHeartBeats() {
        this.executor.scheduleAtFixedRate(() -> {
            try {
                List<UUID> uuids = this.getNpcUuidsPlayer2();
                if (uuids.isEmpty()) {
                    return;
                }
                this.player2APIClient.getHealthStatus();
            }
            catch (LLMServiceException e) {
                LogUtil.errorInChat(e.getMessage());
                LogUtil.error(e);
            }
        }, 0L, 1L, TimeUnit.MINUTES);
    }

    public void shutdown() {
        this.executor.shutdownNow();
    }

    private List<UUID> getNpcUuidsPlayer2() {
        return this.npcFactory.getUuidToNpc().entrySet().stream().filter(e -> ((NPC)e.getValue()).getConfig().getLlmType() == LLMType.PLAYER2).map(Map.Entry::getKey).toList();
    }
}

