/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.context;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import lombok.Generated;
import me.sailex.secondbrain.config.BaseConfig;
import me.sailex.secondbrain.model.context.BlockData;
import me.sailex.secondbrain.util.LogUtil;
import me.sailex.secondbrain.util.MCDataUtil;
import net.minecraft.class_1923;
import net.minecraft.class_1937;
import net.minecraft.class_2338;
import net.minecraft.class_2350;
import net.minecraft.class_2382;
import net.minecraft.class_2680;
import net.minecraft.class_2818;
import net.minecraft.class_3222;

public class ChunkManager {
    private final int verticalScanRange;
    private final int chunkRadius;
    private final class_3222 npcEntity;
    private final ScheduledExecutorService threadPool;
    private final List<BlockData> currentLoadedBlocks;
    private final List<BlockData> nearbyBlocks = new ArrayList<BlockData>();

    public ChunkManager(class_3222 npcEntity, BaseConfig config) {
        this.npcEntity = npcEntity;
        this.verticalScanRange = config.getContextVerticalScanRange();
        this.chunkRadius = config.getContextChunkRadius();
        this.currentLoadedBlocks = new ArrayList<BlockData>();
        this.threadPool = Executors.newSingleThreadScheduledExecutor();
        this.scheduleRefreshBlocks(config.getChunkExpiryTime());
    }

    private void scheduleRefreshBlocks(int chunkExpiryTime) {
        this.threadPool.scheduleAtFixedRate(() -> {
            ChunkManager chunkManager = this;
            synchronized (chunkManager) {
                this.updateAllBlocks();
                this.updateNearbyBlocks();
            }
        }, 0L, chunkExpiryTime, TimeUnit.SECONDS);
    }

    public List<BlockData> getBlocksOfType(String type, int numberOfBlocks) {
        ArrayList<BlockData> blocksFound = new ArrayList<BlockData>();
        for (BlockData block : this.currentLoadedBlocks) {
            if (blocksFound.size() >= numberOfBlocks) break;
            if (!type.equals(block.type())) continue;
            blocksFound.add(block);
        }
        if (blocksFound.size() < numberOfBlocks) {
            LogUtil.error("Only %s blocks found of %s (wanted: %s)".formatted(blocksFound.size(), type, numberOfBlocks));
        }
        return blocksFound;
    }

    private void updateNearbyBlocks() {
        HashMap<String, BlockData> nearestBlocks = new HashMap<String, BlockData>();
        for (BlockData block : this.currentLoadedBlocks) {
            String blockType = block.type();
            if (nearestBlocks.containsKey(blockType) && !this.isCloser(block.position(), ((BlockData)nearestBlocks.get(blockType)).position())) continue;
            nearestBlocks.put(blockType, block);
        }
        this.nearbyBlocks.addAll(nearestBlocks.values());
    }

    private void updateAllBlocks() {
        this.currentLoadedBlocks.clear();
        class_1937 world = this.npcEntity.method_37908();
        class_1923 centerChunk = this.npcEntity.method_31476();
        for (int x = -this.chunkRadius; x <= this.chunkRadius; ++x) {
            for (int z = -this.chunkRadius; z <= this.chunkRadius; ++z) {
                class_1923 pos = new class_1923(centerChunk.field_9181 + x, centerChunk.field_9180 + z);
                boolean isLoaded = world.method_8393(pos.field_9181, pos.field_9180);
                if (!isLoaded) continue;
                this.currentLoadedBlocks.addAll(this.scanChunk(pos));
            }
        }
    }

    private List<BlockData> scanChunk(class_1923 chunk) {
        class_1937 world = this.npcEntity.method_37908();
        class_2338.class_2339 pos = new class_2338.class_2339();
        int baseY = Math.max(0, this.npcEntity.method_24515().method_10264() - this.verticalScanRange);
        int maxY = Math.min(world.method_31605(), this.npcEntity.method_24515().method_10264() + this.verticalScanRange);
        ArrayList<BlockData> blocks = new ArrayList<BlockData>();
        for (int x = 0; x < 16; ++x) {
            for (int z = 0; z < 16; ++z) {
                for (int y = baseY; y < maxY; ++y) {
                    pos.method_10103(chunk.method_8326() + x, y, chunk.method_8328() + z);
                    class_2818 currentChunk = world.method_8500((class_2338)pos);
                    class_2680 blockState = currentChunk.method_8320((class_2338)pos);
                    String blockType = blockState.method_26204().method_9518().getString().toLowerCase().replace(" ", "_");
                    if (blockType.contains("air") || !this.isAccessible((class_2338)pos, currentChunk)) continue;
                    blocks.add(new BlockData(blockType, pos.method_10062(), MCDataUtil.getMiningLevel(blockState), MCDataUtil.getToolNeeded(blockState)));
                }
            }
        }
        return blocks;
    }

    private boolean isAccessible(class_2338 pos, class_2818 chunk) {
        for (class_2350 dir : class_2350.values()) {
            if (!chunk.method_8320(pos.method_10093(dir)).method_26215()) continue;
            return true;
        }
        return false;
    }

    private boolean isCloser(class_2338 pos1, class_2338 pos2) {
        double dist2;
        double dist1 = this.npcEntity.method_24515().method_10262((class_2382)pos1);
        return dist1 < (dist2 = this.npcEntity.method_24515().method_10262((class_2382)pos2));
    }

    public void stopService() {
        this.threadPool.shutdownNow();
    }

    @Generated
    public List<BlockData> getNearbyBlocks() {
        return this.nearbyBlocks;
    }
}

