/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.config;

import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.IOException;
import java.io.Reader;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.UUID;
import java.util.stream.Stream;
import lombok.Generated;
import me.sailex.secondbrain.config.BaseConfig;
import me.sailex.secondbrain.config.Configurable;
import me.sailex.secondbrain.config.NPCConfig;
import me.sailex.secondbrain.llm.LLMType;
import me.sailex.secondbrain.util.LogUtil;
import net.fabricmc.loader.api.FabricLoader;

public class ConfigProvider {
    private static final Path CONFIG_DIR = FabricLoader.getInstance().getConfigDir().resolve("secondbrain");
    private static final Path NPC_CONFIG_DIR = CONFIG_DIR.resolve("npc");
    private static final Path BASE_CONFIG_DIR = CONFIG_DIR.resolve("base");
    private static final Gson GSON = new GsonBuilder().setPrettyPrinting().create();
    private static final String JSON_EXTENSION = ".json";
    private List<NPCConfig> npcConfigs = Collections.synchronizedList(new ArrayList());
    private BaseConfig baseConfig = new BaseConfig();

    public ConfigProvider() {
        try {
            Files.createDirectories(NPC_CONFIG_DIR, new FileAttribute[0]);
            Files.createDirectories(BASE_CONFIG_DIR, new FileAttribute[0]);
            this.npcConfigs = this.loadAll(NPC_CONFIG_DIR, NPCConfig.class);
            this.baseConfig = this.loadAll(BASE_CONFIG_DIR, BaseConfig.class).stream().findFirst().orElseGet(BaseConfig::new);
        }
        catch (IOException e) {
            LogUtil.error("Failed to load config: " + e.getMessage());
        }
    }

    private <T> List<T> loadAll(Path dir, Class<T> configClass) throws IOException {
        try (Stream<Path> filenameStream = Files.list(dir);){
            ArrayList<Object> configs = new ArrayList<Object>();
            for (Path file : filenameStream.toList()) {
                BufferedReader reader = Files.newBufferedReader(file);
                try {
                    configs.add(GSON.fromJson((Reader)reader, configClass));
                }
                finally {
                    if (reader == null) continue;
                    ((Reader)reader).close();
                }
            }
            ArrayList<Object> arrayList = configs;
            return arrayList;
        }
    }

    public void saveAll() {
        this.save(BASE_CONFIG_DIR, this.baseConfig);
        this.npcConfigs.forEach(config -> this.save(NPC_CONFIG_DIR, (Configurable)config));
        LogUtil.info("Saved all configs");
    }

    private synchronized void save(Path dir, Configurable config) {
        Path configPath = dir.resolve(config.getConfigName() + JSON_EXTENSION);
        try (BufferedWriter writer = Files.newBufferedWriter(configPath, new OpenOption[0]);){
            GSON.toJson((Object)config, (Appendable)writer);
        }
        catch (IOException e) {
            LogUtil.error("Failed to save config for: " + config.getConfigName());
        }
    }

    private synchronized void delete(String configName) {
        Path configPath = NPC_CONFIG_DIR.resolve(configName + JSON_EXTENSION);
        try {
            Files.deleteIfExists(configPath);
        }
        catch (IOException e) {
            LogUtil.error("Failed to delete config for: " + configName);
        }
    }

    public synchronized void deleteNpcConfig(UUID uuid) {
        ArrayList configsToRemove = new ArrayList();
        this.npcConfigs.forEach(config -> {
            if (config.getUuid().equals(uuid)) {
                configsToRemove.add(config);
            }
        });
        this.npcConfigs.removeAll(configsToRemove);
        configsToRemove.forEach(config -> this.delete(config.getConfigName()));
    }

    public synchronized void deleteByType(LLMType llmType) {
        this.npcConfigs.removeIf(config -> config != null && config.getLlmType() == llmType);
    }

    public synchronized NPCConfig addNpcConfig(NPCConfig npcConfig) {
        this.npcConfigs.add(npcConfig);
        return npcConfig;
    }

    public synchronized void updateNpcConfig(NPCConfig updatedConfig) {
        this.npcConfigs.forEach(config -> {
            if (config.getNpcName().equals(updatedConfig.getNpcName())) {
                if (config.getOpenaiApiKey().isEmpty()) {
                    updatedConfig.setOpenaiApiKey(config.getOpenaiApiKey());
                }
                this.npcConfigs.set(this.npcConfigs.indexOf(config), updatedConfig);
            }
        });
    }

    public Optional<NPCConfig> getNpcConfig(UUID uuid) {
        return this.npcConfigs.stream().filter(config -> config.getUuid().equals(uuid)).findFirst();
    }

    public Optional<NPCConfig> getNpcConfigByName(String npcName) {
        return this.npcConfigs.stream().filter(config -> config.getNpcName().equals(npcName)).findFirst();
    }

    public List<UUID> getUuidsOfNpcs() {
        return this.npcConfigs.stream().map(NPCConfig::getUuid).toList();
    }

    public List<NPCConfig> getNpcConfigs() {
        return this.npcConfigs;
    }

    public BaseConfig getBaseConfig() {
        return this.baseConfig;
    }

    @Generated
    public void setNpcConfigs(List<NPCConfig> npcConfigs) {
        this.npcConfigs = npcConfigs;
    }

    @Generated
    public void setBaseConfig(BaseConfig baseConfig) {
        this.baseConfig = baseConfig;
    }
}

