/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.database;

import java.io.File;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import net.fabricmc.loader.api.FabricLoader;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class SqliteClient {
    private static final Logger LOGGER = LogManager.getLogger(SqliteClient.class);
    private Connection connection;

    public void initDatabase(String databaseName) {
        String databasePath = this.initDataBaseDir();
        try {
            String jdbcUrl = String.format("jdbc:sqlite:%s/%s.db", databasePath, databaseName);
            this.connection = DriverManager.getConnection(jdbcUrl);
            if (this.connection.isValid(3)) {
                LOGGER.info("Connected to database at: {}", (Object)databasePath);
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error creating/connecting to database: {}", (Object)e.getMessage());
        }
    }

    private String initDataBaseDir() {
        File configDir = FabricLoader.getInstance().getConfigDir().toFile();
        File sqlDbDir = new File(configDir, "secondbrain");
        if (sqlDbDir.mkdirs()) {
            LOGGER.info("Database directory created at: {}", (Object)sqlDbDir.getAbsolutePath());
        }
        return sqlDbDir.getAbsolutePath();
    }

    public ResultSet query(String sql) {
        try {
            Statement statement = this.connection.createStatement();
            statement.closeOnCompletion();
            return statement.executeQuery(sql);
        }
        catch (SQLException e) {
            LOGGER.error("Error selecting rule: {}", (Object)e.getMessage());
            return null;
        }
    }

    public void insert(PreparedStatement statement) {
        try {
            statement.executeUpdate();
        }
        catch (SQLException e) {
            LOGGER.error("Error inserting statement: {} : {}", (Object)statement, (Object)e.getMessage());
        }
    }

    public PreparedStatement buildPreparedStatement(String sql) {
        try {
            return this.connection.prepareStatement(sql);
        }
        catch (SQLException e) {
            LOGGER.error("Error building prepared statement: {}", (Object)e.getMessage());
            return null;
        }
    }

    public void create(String sql) {
        try (Statement statement = this.connection.createStatement();){
            statement.execute(sql);
        }
        catch (SQLException e) {
            LOGGER.error("Error executing query {} : {}", (Object)sql, (Object)e.getMessage());
        }
    }

    public void closeConnection() {
        try {
            if (this.connection != null && !this.connection.isClosed()) {
                this.connection.close();
                LOGGER.info("Database connection closed.");
            }
        }
        catch (SQLException e) {
            LOGGER.error("Error closing database connection: {}", (Object)e.getMessage());
        }
    }
}

