/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.thread;

import java.util.concurrent.CountDownLatch;
import me.sailex.secondbrain.model.Goal;
import me.sailex.secondbrain.util.LogUtil;

public class GoalThread
extends Thread {
    private final Runnable goalTask;
    private final String goalName;
    private final CountDownLatch completionLatch;

    public GoalThread(Goal goal) {
        super("NPCGoal-" + goal.name());
        this.goalName = goal.name();
        this.goalTask = goal.task();
        this.completionLatch = new CountDownLatch(1);
        this.setDaemon(true);
    }

    public GoalThread() {
        super("NPCGoal-Initial");
        this.goalTask = () -> {};
        this.goalName = null;
        this.completionLatch = new CountDownLatch(0);
    }

    @Override
    public void run() {
        try {
            this.goalTask.run();
        }
        catch (Exception e) {
            LogUtil.error("Error executing goal %s".formatted(this.goalName), e);
        }
        finally {
            this.completionLatch.countDown();
        }
    }

    public boolean isCompleted() {
        return this.completionLatch.getCount() == 0L;
    }
}

