/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.networking;

import io.wispforest.endec.util.EndecBuffer;
import io.wispforest.owo.network.OwoNetChannel;
import io.wispforest.owo.network.ServerAccess;
import io.wispforest.owo.network.serialization.PacketBufSerializer;
import java.util.UUID;
import me.sailex.secondbrain.auth.PlayerAuthorizer;
import me.sailex.secondbrain.callback.STTCallback;
import me.sailex.secondbrain.common.NPCFactory;
import me.sailex.secondbrain.config.BaseConfig;
import me.sailex.secondbrain.config.ConfigProvider;
import me.sailex.secondbrain.config.NPCConfig;
import me.sailex.secondbrain.networking.packet.ConfigPacket;
import me.sailex.secondbrain.networking.packet.CreateNpcPacket;
import me.sailex.secondbrain.networking.packet.DeleteNpcPacket;
import me.sailex.secondbrain.networking.packet.STTPacket;
import me.sailex.secondbrain.networking.packet.UpdateBaseConfigPacket;
import me.sailex.secondbrain.networking.packet.UpdateNpcConfigPacket;
import me.sailex.secondbrain.util.LogUtil;
import net.minecraft.class_1657;
import net.minecraft.class_2960;
import net.minecraft.class_3324;

public class NetworkHandler {
    public static final class_2960 CONFIG_CHANNEL_ID = class_2960.method_43902((String)"secondbrain", (String)"config-channel");
    public static final OwoNetChannel CHANNEL = OwoNetChannel.create((class_2960)CONFIG_CHANNEL_ID);
    private final ConfigProvider configProvider;
    private final NPCFactory npcFactory;
    private final PlayerAuthorizer authorizer;

    public NetworkHandler(ConfigProvider configProvider, NPCFactory npcFactory, PlayerAuthorizer authorizer) {
        this.configProvider = configProvider;
        this.npcFactory = npcFactory;
        this.authorizer = authorizer;
    }

    public void registerPacketReceiver() {
        this.registerEndecs();
        this.registerUpdateBaseConfig();
        this.registerUpdateNpcConfig();
        this.registerAddNpc();
        this.registerDeleteNpc();
        this.registerStartStopSTT();
        CHANNEL.registerClientboundDeferred(ConfigPacket.class);
    }

    public void sendPacket(ConfigPacket packet, class_1657 targetClient) {
        CHANNEL.serverHandle(targetClient).send((Record)packet);
    }

    private void registerUpdateBaseConfig() {
        CHANNEL.registerServerbound(UpdateBaseConfigPacket.class, (configPacket, serverAccess) -> {
            if (this.authorizer.isAuthorized((ServerAccess)serverAccess)) {
                this.configProvider.setBaseConfig(configPacket.baseConfig());
                LogUtil.info("Updated base config to: " + String.valueOf(configPacket));
            }
        });
    }

    private void registerUpdateNpcConfig() {
        CHANNEL.registerServerbound(UpdateNpcConfigPacket.class, (configPacket, serverAccess) -> {
            if (this.authorizer.isAuthorized((ServerAccess)serverAccess)) {
                this.configProvider.updateNpcConfig(configPacket.npcConfig());
                LogUtil.info("Updated npc config to: " + String.valueOf(configPacket));
            }
        });
    }

    private void registerAddNpc() {
        CHANNEL.registerServerbound(CreateNpcPacket.class, (createNpcPacket, serverAccess) -> {
            if (this.authorizer.isAuthorized((ServerAccess)serverAccess)) {
                this.npcFactory.createNpc(createNpcPacket.npcConfig(), serverAccess.runtime(), serverAccess.player().method_24515(), (class_1657)serverAccess.player());
            }
        });
    }

    private void registerDeleteNpc() {
        CHANNEL.registerServerbound(DeleteNpcPacket.class, (configPacket, serverAccess) -> {
            if (this.authorizer.isAuthorized((ServerAccess)serverAccess)) {
                class_3324 playerManager = serverAccess.player().method_5682().method_3760();
                UUID uuid = UUID.fromString(configPacket.uuid());
                if (configPacket.isDelete()) {
                    this.npcFactory.deleteNpc(uuid, playerManager);
                } else {
                    this.npcFactory.removeNpc(uuid, playerManager);
                }
            }
        });
    }

    private void registerStartStopSTT() {
        CHANNEL.registerServerbound(STTPacket.class, (sttPacket, serverAccess) -> {
            if (this.authorizer.isAuthorized((ServerAccess)serverAccess) && this.authorizer.isLocalConnection((ServerAccess)serverAccess)) {
                ((STTCallback)STTCallback.EVENT.invoker()).onSTTAction(sttPacket.type());
                LogUtil.info("STT action: " + String.valueOf(sttPacket));
            }
        });
    }

    private void registerEndecs() {
        PacketBufSerializer.register(ConfigPacket.class, (buf, packet) -> ((EndecBuffer)buf).write(ConfigPacket.ENDEC, packet), buf -> (ConfigPacket)((EndecBuffer)buf).read(ConfigPacket.ENDEC));
        PacketBufSerializer.register(BaseConfig.class, (buf, packet) -> ((EndecBuffer)buf).write(BaseConfig.ENDEC, packet), buf -> (BaseConfig)((EndecBuffer)buf).read(BaseConfig.ENDEC));
        PacketBufSerializer.register(NPCConfig.class, (buf, packet) -> ((EndecBuffer)buf).write(NPCConfig.ENDEC, packet), buf -> (NPCConfig)((EndecBuffer)buf).read(NPCConfig.ENDEC));
        PacketBufSerializer.register(DeleteNpcPacket.class, (buf, packet) -> ((EndecBuffer)buf).write(DeleteNpcPacket.ENDEC, packet), buf -> (DeleteNpcPacket)((EndecBuffer)buf).read(DeleteNpcPacket.ENDEC));
        PacketBufSerializer.register(UpdateNpcConfigPacket.class, (buf, packet) -> ((EndecBuffer)buf).write(UpdateNpcConfigPacket.ENDEC, packet), buf -> (UpdateNpcConfigPacket)((EndecBuffer)buf).read(UpdateNpcConfigPacket.ENDEC));
        PacketBufSerializer.register(UpdateBaseConfigPacket.class, (buf, packet) -> ((EndecBuffer)buf).write(UpdateBaseConfigPacket.ENDEC, packet), buf -> (UpdateBaseConfigPacket)((EndecBuffer)buf).read(UpdateBaseConfigPacket.ENDEC));
        PacketBufSerializer.register(STTPacket.class, (buf, packet) -> ((EndecBuffer)buf).write(STTPacket.ENDEC, packet), buf -> (STTPacket)((EndecBuffer)buf).read(STTPacket.ENDEC));
        PacketBufSerializer.register(CreateNpcPacket.class, (buf, packet) -> ((EndecBuffer)buf).write(CreateNpcPacket.ENDEC, packet), buf -> (CreateNpcPacket)((EndecBuffer)buf).read(CreateNpcPacket.ENDEC));
    }
}

