/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.database.repositories;

import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.UUID;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import me.sailex.secondbrain.database.SqliteClient;
import me.sailex.secondbrain.model.database.Conversation;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u00006\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\b\u0004\n\u0002\u0010\u000e\n\u0002\b\u0007\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J\r\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\u0007\u0010\bJ\r\u0010\t\u001a\u00020\u0006\u00a2\u0006\u0004\b\t\u0010\bJ\u0015\u0010\f\u001a\u00020\u00062\u0006\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\f\u0010\rJ\u001b\u0010\u0011\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0015\u0010\u0013\u001a\u00020\u00062\u0006\u0010\u000f\u001a\u00020\u000e\u00a2\u0006\u0004\b\u0013\u0010\u0014J\u001d\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\n0\u00102\u0006\u0010\u0016\u001a\u00020\u0015H\u0002\u00a2\u0006\u0004\b\u0017\u0010\u0018R\u0017\u0010\u0003\u001a\u00020\u00028\u0006\u00a2\u0006\f\n\u0004\b\u0003\u0010\u0019\u001a\u0004\b\u001a\u0010\u001b\u00a8\u0006\u001c"}, d2={"Lme/sailex/secondbrain/database/repositories/ConversationRepository;", "", "Lme/sailex/secondbrain/database/SqliteClient;", "sqliteClient", "<init>", "(Lme/sailex/secondbrain/database/SqliteClient;)V", "", "init", "()V", "createTable", "Lme/sailex/secondbrain/model/database/Conversation;", "conversation", "insert", "(Lme/sailex/secondbrain/model/database/Conversation;)V", "Ljava/util/UUID;", "uuid", "", "selectByUuid", "(Ljava/util/UUID;)Ljava/util/List;", "deleteByUuid", "(Ljava/util/UUID;)V", "", "sql", "executeAndProcessConversations", "(Ljava/lang/String;)Ljava/util/List;", "Lme/sailex/secondbrain/database/SqliteClient;", "getSqliteClient", "()Lme/sailex/secondbrain/database/SqliteClient;", "1.21.8"})
public final class ConversationRepository {
    @NotNull
    private final SqliteClient sqliteClient;

    public ConversationRepository(@NotNull SqliteClient sqliteClient) {
        Intrinsics.checkNotNullParameter((Object)sqliteClient, (String)"sqliteClient");
        this.sqliteClient = sqliteClient;
    }

    @NotNull
    public final SqliteClient getSqliteClient() {
        return this.sqliteClient;
    }

    public final void init() {
        this.createTable();
    }

    public final void createTable() {
        String sql = "\n            CREATE TABLE IF NOT EXISTS conversations (\n                id INTEGER PRIMARY KEY AUTOINCREMENT,\n                uuid CHARACTER(36) NOT NULL,\n                role CHARACTER(9) NOT NULL,\n                message TEXT NOT NULL\n            );\n        ";
        this.sqliteClient.create(sql);
    }

    public final void insert(@NotNull Conversation conversation) {
        Intrinsics.checkNotNullParameter((Object)conversation, (String)"conversation");
        PreparedStatement statement = this.sqliteClient.buildPreparedStatement("INSERT INTO conversations (uuid, role, message) VALUES (?, ?, ?)");
        statement.setString(1, conversation.getUuid().toString());
        statement.setString(2, conversation.getRole());
        statement.setString(3, conversation.getMessage());
        this.sqliteClient.insert(statement);
    }

    @NotNull
    public final List<Conversation> selectByUuid(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        String string = "SELECT * FROM conversations WHERE uuid = '%s' ORDER BY id DESC LIMIT 100";
        Object[] objectArray = new Object[]{uuid.toString()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String sql = string2;
        return this.executeAndProcessConversations(sql);
    }

    public final void deleteByUuid(@NotNull UUID uuid) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        String string = "DELETE FROM conversations WHERE uuid = '%s'";
        Object[] objectArray = new Object[]{uuid.toString()};
        String string2 = String.format(string, Arrays.copyOf(objectArray, objectArray.length));
        Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"format(...)");
        String sql = string2;
        this.sqliteClient.query(sql);
    }

    private final List<Conversation> executeAndProcessConversations(String sql) {
        ResultSet result = this.sqliteClient.query(sql);
        ArrayList<Conversation> conversations = new ArrayList<Conversation>();
        if (result == null) {
            return CollectionsKt.emptyList();
        }
        while (result.next()) {
            UUID uUID = UUID.fromString(result.getString("uuid"));
            Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"fromString(...)");
            String string = result.getString("role");
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"getString(...)");
            String string2 = result.getString("message");
            Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"getString(...)");
            Conversation conversation = new Conversation(uUID, string, string2);
            conversations.add(conversation);
        }
        result.close();
        return conversations;
    }
}

