/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain;

import lombok.Generated;
import me.sailex.secondbrain.auth.PlayerAuthorizer;
import me.sailex.secondbrain.commands.CommandManager;
import me.sailex.secondbrain.common.NPCFactory;
import me.sailex.secondbrain.common.Player2NpcSynchronizer;
import me.sailex.secondbrain.config.ConfigProvider;
import me.sailex.secondbrain.database.SqliteClient;
import me.sailex.secondbrain.database.repositories.RepositoryFactory;
import me.sailex.secondbrain.database.resources.ResourceProvider;
import me.sailex.secondbrain.listener.EventListenerRegisterer;
import me.sailex.secondbrain.networking.NetworkHandler;
import me.sailex.secondbrain.util.LogUtil;
import net.fabricmc.api.ModInitializer;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerEntityEvents;
import net.fabricmc.fabric.api.event.lifecycle.v1.ServerLifecycleEvents;
import net.minecraft.class_1657;

public class SecondBrain
implements ModInitializer {
    public static final String MOD_ID = "secondbrain";
    private boolean isFirstPlayerJoins = true;

    public void onInitialize() {
        ConfigProvider configProvider = new ConfigProvider();
        SqliteClient sqlite = new SqliteClient();
        RepositoryFactory repositoryFactory = new RepositoryFactory(sqlite);
        ResourceProvider resourceProvider = new ResourceProvider(repositoryFactory.getConversationRepository());
        NPCFactory npcFactory = new NPCFactory(configProvider, resourceProvider);
        PlayerAuthorizer authorizer = new PlayerAuthorizer();
        NetworkHandler networkManager = new NetworkHandler(configProvider, npcFactory, authorizer);
        networkManager.registerPacketReceiver();
        EventListenerRegisterer eventListenerRegisterer = new EventListenerRegisterer(npcFactory.getUuidToNpc());
        eventListenerRegisterer.register();
        Player2NpcSynchronizer synchronizer = new Player2NpcSynchronizer(npcFactory, configProvider);
        CommandManager commandManager = new CommandManager(npcFactory, configProvider, networkManager, synchronizer);
        commandManager.registerAll();
        ServerLifecycleEvents.SERVER_STARTED.register(server -> {
            LogUtil.initialize(server, configProvider);
            repositoryFactory.initRepositories();
            resourceProvider.loadResources(configProvider.getUuidsOfNpcs());
            npcFactory.init();
        });
        this.syncOnPlayerLoad(synchronizer);
        this.onStop(npcFactory, configProvider, sqlite, synchronizer, resourceProvider);
    }

    private void syncOnPlayerLoad(Player2NpcSynchronizer synchronizer) {
        ServerEntityEvents.ENTITY_LOAD.register((entity, world) -> {
            if (entity.method_31747() && this.isFirstPlayerJoins) {
                synchronizer.syncCharacters(world.method_8503(), (class_1657)entity);
                this.isFirstPlayerJoins = false;
            }
        });
    }

    private void onStop(NPCFactory npcFactory, ConfigProvider configProvider, SqliteClient sqlite, Player2NpcSynchronizer synchronizer, ResourceProvider resourceProvider) {
        ServerLifecycleEvents.SERVER_STOPPING.register(server -> {
            synchronizer.shutdown();
            npcFactory.shutdownNPCs(server);
            resourceProvider.saveResources();
            sqlite.closeConnection();
            configProvider.saveAll();
            this.isFirstPlayerJoins = true;
        });
    }

    @Generated
    public boolean isFirstPlayerJoins() {
        return this.isFirstPlayerJoins;
    }
}

