/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.commands;

import com.mojang.brigadier.arguments.ArgumentType;
import com.mojang.brigadier.arguments.StringArgumentType;
import com.mojang.brigadier.builder.LiteralArgumentBuilder;
import com.mojang.brigadier.context.CommandContext;
import com.mojang.brigadier.suggestion.SuggestionsBuilder;
import java.util.Optional;
import lombok.Generated;
import me.sailex.secondbrain.common.NPCFactory;
import me.sailex.secondbrain.config.ConfigProvider;
import me.sailex.secondbrain.config.NPCConfig;
import me.sailex.secondbrain.util.LogUtil;
import net.minecraft.class_2168;
import net.minecraft.class_2170;

public class NPCRemoveCommand {
    private final NPCFactory npcFactory;
    private final ConfigProvider configProvider;

    public LiteralArgumentBuilder<class_2168> getCommand() {
        return (LiteralArgumentBuilder)((LiteralArgumentBuilder)class_2170.method_9247((String)"remove").requires(source -> source.method_9259(2))).then(class_2170.method_9244((String)"name", (ArgumentType)StringArgumentType.string()).suggests((context, builder) -> {
            this.configProvider.getNpcConfigs().stream().map(NPCConfig::getNpcName).forEach(arg_0 -> ((SuggestionsBuilder)builder).suggest(arg_0));
            return builder.buildFuture();
        }).executes(this::removeNPC));
    }

    private int removeNPC(CommandContext<class_2168> context) {
        String name = StringArgumentType.getString(context, (String)"name");
        Optional<NPCConfig> config = this.configProvider.getNpcConfigByName(name);
        if (config.isPresent()) {
            this.npcFactory.deleteNpc(config.get().getUuid(), ((class_2168)context.getSource()).method_9211().method_3760());
            return 1;
        }
        ((class_2168)context.getSource()).method_9226(() -> LogUtil.formatError("NPC couldnt get removed. No NPC with name '" + name + "' found"), false);
        return 0;
    }

    @Generated
    public NPCRemoveCommand(NPCFactory npcFactory, ConfigProvider configProvider) {
        this.npcFactory = npcFactory;
        this.configProvider = configProvider;
    }
}

