/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.common;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.sailex.altoclef.AltoClefController;
import me.sailex.automatone.api.BaritoneAPI;
import me.sailex.automatone.api.IBaritone;
import me.sailex.secondbrain.config.BaseConfig;
import me.sailex.secondbrain.config.ConfigProvider;
import me.sailex.secondbrain.config.NPCConfig;
import me.sailex.secondbrain.constant.Instructions;
import me.sailex.secondbrain.context.ContextProvider;
import me.sailex.secondbrain.event.NPCEventHandler;
import me.sailex.secondbrain.exception.NPCCreationException;
import me.sailex.secondbrain.history.ConversationHistory;
import me.sailex.secondbrain.history.Message;
import me.sailex.secondbrain.llm.LLMClient;
import me.sailex.secondbrain.llm.LLMType;
import me.sailex.secondbrain.llm.ollama.OllamaClient;
import me.sailex.secondbrain.llm.openai.OpenAiClient;
import me.sailex.secondbrain.llm.player2.Player2APIClient;
import me.sailex.secondbrain.model.NPC;
import me.sailex.secondbrain.model.database.Conversation;
import net.minecraft.class_3222;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000>\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u000f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u00a2\u0006\u0004\b\u0004\u0010\u0005J-\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0007\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\b2\u000e\u0010\f\u001a\n\u0012\u0004\u0012\u00020\u000b\u0018\u00010\n\u00a2\u0006\u0004\b\u000e\u0010\u000fJ\u0017\u0010\u0011\u001a\u00020\u00102\u0006\u0010\u0007\u001a\u00020\u0006H\u0002\u00a2\u0006\u0004\b\u0011\u0010\u0012J\u0017\u0010\u0014\u001a\u00020\u00132\u0006\u0010\t\u001a\u00020\bH\u0002\u00a2\u0006\u0004\b\u0014\u0010\u0015R\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010\u0016\u00a8\u0006\u0017"}, d2={"Lme/sailex/secondbrain/common/NPCFactory;", "", "Lme/sailex/secondbrain/config/ConfigProvider;", "configProvider", "<init>", "(Lme/sailex/secondbrain/config/ConfigProvider;)V", "Lnet/minecraft/class_3222;", "npcEntity", "Lme/sailex/secondbrain/config/NPCConfig;", "config", "", "Lme/sailex/secondbrain/model/database/Conversation;", "loadedConversation", "Lme/sailex/secondbrain/model/NPC;", "createNpc", "(Lnet/minecraft/class_3222;Lme/sailex/secondbrain/config/NPCConfig;Ljava/util/List;)Lme/sailex/secondbrain/model/NPC;", "Lme/sailex/altoclef/AltoClefController;", "initController", "(Lnet/minecraft/class_3222;)Lme/sailex/altoclef/AltoClefController;", "Lme/sailex/secondbrain/llm/LLMClient;", "initLLMClient", "(Lme/sailex/secondbrain/config/NPCConfig;)Lme/sailex/secondbrain/llm/LLMClient;", "Lme/sailex/secondbrain/config/ConfigProvider;", "1.20.1"})
@SourceDebugExtension(value={"SMAP\nNPCFactory.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NPCFactory.kt\nme/sailex/secondbrain/common/NPCFactory\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,63:1\n1557#2:64\n1628#2,3:65\n*S KotlinDebug\n*F\n+ 1 NPCFactory.kt\nme/sailex/secondbrain/common/NPCFactory\n*L\n38#1:64\n38#1:65,3\n*E\n"})
public final class NPCFactory {
    @NotNull
    private final ConfigProvider configProvider;

    public NPCFactory(@NotNull ConfigProvider configProvider) {
        Intrinsics.checkNotNullParameter((Object)configProvider, (String)"configProvider");
        this.configProvider = configProvider;
    }

    /*
     * Unable to fully structure code
     */
    @NotNull
    public final NPC createNpc(@NotNull class_3222 npcEntity, @NotNull NPCConfig config, @Nullable List<Conversation> loadedConversation) {
        Intrinsics.checkNotNullParameter((Object)npcEntity, (String)"npcEntity");
        Intrinsics.checkNotNullParameter((Object)config, (String)"config");
        baseConfig = this.configProvider.getBaseConfig();
        contextProvider = new ContextProvider(npcEntity, baseConfig);
        llmClient = this.initLLMClient(config);
        controller = this.initController(npcEntity);
        defaultPrompt = Instructions.getLlmSystemPrompt(config.getNpcName(), config.getLlmCharacter(), controller.getCommandExecutor().allCommands(), config.getLlmType());
        if (loadedConversation == null) ** GOTO lbl-1000
        var11_9 = loadedConversation;
        $i$f$map = false;
        var13_11 = $this$map$iv;
        destination$iv$iv = new ArrayList<E>(CollectionsKt.collectionSizeOrDefault((Iterable)$this$map$iv, (int)10));
        $i$f$mapTo = false;
        for (T item$iv$iv : $this$mapTo$iv$iv) {
            var18_16 = (Conversation)item$iv$iv;
            var20_18 = destination$iv$iv;
            $i$a$-map-NPCFactory$createNpc$messages$1 = false;
            var20_18.add(new Message(it.getMessage(), it.getRole()));
        }
        $this$map$iv = CollectionsKt.toMutableList((Collection)((List)destination$iv$iv));
        if ($this$map$iv != null) {
            v0 = $this$map$iv;
        } else lbl-1000:
        // 2 sources

        {
            v0 = new ArrayList<E>();
        }
        messages = v0;
        Intrinsics.checkNotNull((Object)defaultPrompt);
        history = new ConversationHistory(llmClient, defaultPrompt, messages);
        eventHandler = new NPCEventHandler(llmClient, history, contextProvider, controller, config);
        return new NPC(npcEntity, llmClient, history, eventHandler, controller, contextProvider, config);
    }

    private final AltoClefController initController(class_3222 npcEntity) {
        IBaritone automatone = BaritoneAPI.getProvider().getBaritone(npcEntity);
        return new AltoClefController(automatone);
    }

    private final LLMClient initLLMClient(NPCConfig config) {
        BaseConfig baseConfig = this.configProvider.getBaseConfig();
        LLMType lLMType = config.getLlmType();
        LLMClient llmClient = switch (lLMType == null ? -1 : WhenMappings.$EnumSwitchMapping$0[lLMType.ordinal()]) {
            case 1 -> new OllamaClient(config.getLlmModel(), config.getOllamaUrl(), baseConfig.getLlmTimeout(), baseConfig.isVerbose());
            case 2 -> new OpenAiClient(config.getLlmModel(), config.getOpenaiApiKey(), baseConfig.getLlmTimeout());
            case 3 -> new Player2APIClient(config.getVoiceId(), config.getNpcName(), baseConfig.getLlmTimeout());
            default -> throw new NPCCreationException("Invalid LLM type: " + config.getLlmType());
        };
        llmClient.checkServiceIsReachable();
        return llmClient;
    }

    @Metadata(mv={2, 1, 0}, k=3, xi=48)
    public final class WhenMappings {
        public static final /* synthetic */ int[] $EnumSwitchMapping$0;

        static {
            int[] nArray = new int[LLMType.values().length];
            try {
                nArray[LLMType.OLLAMA.ordinal()] = 1;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.OPENAI.ordinal()] = 2;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            try {
                nArray[LLMType.PLAYER2.ordinal()] = 3;
            }
            catch (NoSuchFieldError noSuchFieldError) {
                // empty catch block
            }
            $EnumSwitchMapping$0 = nArray;
        }
    }
}

