/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.common;

import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import kotlin.Metadata;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import me.sailex.altoclef.multiversion.EntityVer;
import me.sailex.secondbrain.auth.UsernameValidator;
import me.sailex.secondbrain.callback.NPCEvents;
import me.sailex.secondbrain.common.NPCFactory;
import me.sailex.secondbrain.common.NPCSpawner;
import me.sailex.secondbrain.config.ConfigProvider;
import me.sailex.secondbrain.config.NPCConfig;
import me.sailex.secondbrain.database.resources.ResourceProvider;
import me.sailex.secondbrain.exception.NPCCreationException;
import me.sailex.secondbrain.model.NPC;
import me.sailex.secondbrain.util.LogUtil;
import net.minecraft.class_1297;
import net.minecraft.class_1657;
import net.minecraft.class_2338;
import net.minecraft.class_3222;
import net.minecraft.class_3324;
import net.minecraft.server.MinecraftServer;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000h\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\b\n\u0002\u0010\u000e\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0006\u0018\u0000 32\u00020\u0001:\u00013B\u001f\u0012\u0006\u0010\u0003\u001a\u00020\u0002\u0012\u0006\u0010\u0005\u001a\u00020\u0004\u0012\u0006\u0010\u0007\u001a\u00020\u0006\u00a2\u0006\u0004\b\b\u0010\tJ\r\u0010\u000b\u001a\u00020\n\u00a2\u0006\u0004\b\u000b\u0010\fJ1\u0010\u0015\u001a\u00020\n2\u0006\u0010\u000e\u001a\u00020\r2\u0006\u0010\u0010\u001a\u00020\u000f2\b\u0010\u0012\u001a\u0004\u0018\u00010\u00112\b\u0010\u0014\u001a\u0004\u0018\u00010\u0013\u00a2\u0006\u0004\b\u0015\u0010\u0016J\u001d\u0010\u001b\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001b\u0010\u001cJ\u001d\u0010\u001d\u001a\u00020\n2\u0006\u0010\u0018\u001a\u00020\u00172\u0006\u0010\u001a\u001a\u00020\u0019\u00a2\u0006\u0004\b\u001d\u0010\u001cJ\u0015\u0010\u001e\u001a\u00020\n2\u0006\u0010\u0010\u001a\u00020\u000f\u00a2\u0006\u0004\b\u001e\u0010\u001fJ\u0017\u0010 \u001a\u00020\r2\u0006\u0010\u000e\u001a\u00020\rH\u0002\u00a2\u0006\u0004\b \u0010!J\u0017\u0010$\u001a\u00020\n2\u0006\u0010#\u001a\u00020\"H\u0002\u00a2\u0006\u0004\b$\u0010%J\u000f\u0010&\u001a\u00020\nH\u0002\u00a2\u0006\u0004\b&\u0010\fR\u0014\u0010\u0003\u001a\u00020\u00028\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0003\u0010'R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0005\u0010(R\u0014\u0010\u0007\u001a\u00020\u00068\u0002X\u0082\u0004\u00a2\u0006\u0006\n\u0004\b\u0007\u0010)R\u0016\u0010+\u001a\u00020*8\u0002@\u0002X\u0082.\u00a2\u0006\u0006\n\u0004\b+\u0010,R#\u0010/\u001a\u000e\u0012\u0004\u0012\u00020\u0017\u0012\u0004\u0012\u00020.0-8\u0006\u00a2\u0006\f\n\u0004\b/\u00100\u001a\u0004\b1\u00102\u00a8\u00064"}, d2={"Lme/sailex/secondbrain/common/NPCService;", "", "Lme/sailex/secondbrain/common/NPCFactory;", "factory", "Lme/sailex/secondbrain/config/ConfigProvider;", "configProvider", "Lme/sailex/secondbrain/database/resources/ResourceProvider;", "resourceProvider", "<init>", "(Lme/sailex/secondbrain/common/NPCFactory;Lme/sailex/secondbrain/config/ConfigProvider;Lme/sailex/secondbrain/database/resources/ResourceProvider;)V", "", "init", "()V", "Lme/sailex/secondbrain/config/NPCConfig;", "newConfig", "Lnet/minecraft/server/MinecraftServer;", "server", "Lnet/minecraft/class_2338;", "spawnPos", "Lnet/minecraft/class_1657;", "owner", "createNpc", "(Lme/sailex/secondbrain/config/NPCConfig;Lnet/minecraft/server/MinecraftServer;Lnet/minecraft/class_2338;Lnet/minecraft/class_1657;)V", "Ljava/util/UUID;", "uuid", "Lnet/minecraft/class_3324;", "playerManager", "removeNpc", "(Ljava/util/UUID;Lnet/minecraft/class_3324;)V", "deleteNpc", "shutdownNPCs", "(Lnet/minecraft/server/MinecraftServer;)V", "updateConfig", "(Lme/sailex/secondbrain/config/NPCConfig;)Lme/sailex/secondbrain/config/NPCConfig;", "", "npcName", "checkNpcName", "(Ljava/lang/String;)V", "checkLimit", "Lme/sailex/secondbrain/common/NPCFactory;", "Lme/sailex/secondbrain/config/ConfigProvider;", "Lme/sailex/secondbrain/database/resources/ResourceProvider;", "Ljava/util/concurrent/ExecutorService;", "executorService", "Ljava/util/concurrent/ExecutorService;", "Ljava/util/concurrent/ConcurrentHashMap;", "Lme/sailex/secondbrain/model/NPC;", "uuidToNpc", "Ljava/util/concurrent/ConcurrentHashMap;", "getUuidToNpc", "()Ljava/util/concurrent/ConcurrentHashMap;", "Companion", "1.20.1"})
@SourceDebugExtension(value={"SMAP\nNPCService.kt\nKotlin\n*S Kotlin\n*F\n+ 1 NPCService.kt\nme/sailex/secondbrain/common/NPCService\n+ 2 _Collections.kt\nkotlin/collections/CollectionsKt___CollectionsKt\n*L\n1#1,128:1\n1863#2,2:129\n1755#2,3:131\n*S KotlinDebug\n*F\n+ 1 NPCService.kt\nme/sailex/secondbrain/common/NPCService\n*L\n97#1:129,2\n116#1:131,3\n*E\n"})
public final class NPCService {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final NPCFactory factory;
    @NotNull
    private final ConfigProvider configProvider;
    @NotNull
    private final ResourceProvider resourceProvider;
    private ExecutorService executorService;
    @NotNull
    private final ConcurrentHashMap<UUID, NPC> uuidToNpc;
    private static final int MAX_NUMBER_OF_NPC = 10;

    public NPCService(@NotNull NPCFactory factory, @NotNull ConfigProvider configProvider, @NotNull ResourceProvider resourceProvider) {
        Intrinsics.checkNotNullParameter((Object)factory, (String)"factory");
        Intrinsics.checkNotNullParameter((Object)configProvider, (String)"configProvider");
        Intrinsics.checkNotNullParameter((Object)resourceProvider, (String)"resourceProvider");
        this.factory = factory;
        this.configProvider = configProvider;
        this.resourceProvider = resourceProvider;
        this.uuidToNpc = new ConcurrentHashMap();
    }

    @NotNull
    public final ConcurrentHashMap<UUID, NPC> getUuidToNpc() {
        return this.uuidToNpc;
    }

    public final void init() {
        this.executorService = Executors.newSingleThreadExecutor();
    }

    public final void createNpc(@NotNull NPCConfig newConfig, @NotNull MinecraftServer server, @Nullable class_2338 spawnPos, @Nullable class_1657 owner) {
        Intrinsics.checkNotNullParameter((Object)newConfig, (String)"newConfig");
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Runnable runnable = () -> NPCService.createNpc$lambda$2(newConfig, this, server, spawnPos, owner);
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executorService");
            executorService = null;
        }
        CompletableFuture.runAsync(runnable, executorService).exceptionally(NPCService::createNpc$lambda$3);
    }

    public final void removeNpc(@NotNull UUID uuid, @NotNull class_3324 playerManager) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        NPC npcToRemove = this.uuidToNpc.get(uuid);
        if (npcToRemove != null) {
            npcToRemove.getController().stop();
            npcToRemove.getLlmClient().stopService();
            npcToRemove.getEventHandler().stopService();
            npcToRemove.getContextProvider().getChunkManager().stopService();
            this.resourceProvider.addConversations(uuid, npcToRemove.getHistory().getLatestConversations());
            this.uuidToNpc.remove(uuid);
            NPCSpawner.remove(npcToRemove.getEntity().method_5667(), playerManager);
            Optional<NPCConfig> config = this.configProvider.getNpcConfig(uuid);
            if (config.isPresent()) {
                config.get().setActive(false);
                LogUtil.infoInChat("Removed NPC with name " + config.get().getNpcName());
            } else {
                LogUtil.infoInChat("Removed NPC with uuid " + uuid);
            }
        }
    }

    public final void deleteNpc(@NotNull UUID uuid, @NotNull class_3324 playerManager) {
        Intrinsics.checkNotNullParameter((Object)uuid, (String)"uuid");
        Intrinsics.checkNotNullParameter((Object)playerManager, (String)"playerManager");
        this.resourceProvider.getLoadedConversations().remove(uuid);
        this.resourceProvider.getConversationRepository().deleteByUuid(uuid);
        this.removeNpc(uuid, playerManager);
        this.configProvider.deleteNpcConfig(uuid);
    }

    public final void shutdownNPCs(@NotNull MinecraftServer server) {
        Intrinsics.checkNotNullParameter((Object)server, (String)"server");
        Set set = this.uuidToNpc.keySet();
        Intrinsics.checkNotNullExpressionValue((Object)set, (String)"<get-keys>(...)");
        Iterable $this$forEach$iv = set;
        boolean $i$f$forEach = false;
        for (Object element$iv : $this$forEach$iv) {
            UUID it = (UUID)element$iv;
            boolean bl = false;
            Intrinsics.checkNotNull((Object)it);
            class_3324 class_33242 = server.method_3760();
            Intrinsics.checkNotNullExpressionValue((Object)class_33242, (String)"getPlayerManager(...)");
            this.removeNpc(it, class_33242);
        }
        ExecutorService executorService = this.executorService;
        if (executorService == null) {
            Intrinsics.throwUninitializedPropertyAccessException((String)"executorService");
            executorService = null;
        }
        executorService.shutdownNow();
    }

    private final NPCConfig updateConfig(NPCConfig newConfig) {
        Optional<NPCConfig> config = this.configProvider.getNpcConfigByName(newConfig.getNpcName());
        if (config.isEmpty()) {
            NPCConfig nPCConfig = this.configProvider.addNpcConfig(newConfig);
            Intrinsics.checkNotNullExpressionValue((Object)nPCConfig, (String)"addNpcConfig(...)");
            return nPCConfig;
        }
        config.get().setActive(true);
        NPCConfig nPCConfig = config.get();
        Intrinsics.checkNotNullExpressionValue((Object)nPCConfig, (String)"get(...)");
        return nPCConfig;
    }

    private final void checkNpcName(String npcName) {
        boolean bl;
        block5: {
            if (!UsernameValidator.isValid(npcName)) {
                throw new NPCCreationException("NPC name is not valid. Use 3\u201316 characters: letters, numbers, or underscores only.");
            }
            Collection<NPC> collection = this.uuidToNpc.values();
            Intrinsics.checkNotNullExpressionValue(collection, (String)"<get-values>(...)");
            Iterable $this$any$iv = collection;
            boolean $i$f$any = false;
            if (((Collection)$this$any$iv).isEmpty()) {
                bl = false;
            } else {
                for (Object element$iv : $this$any$iv) {
                    NPC it = (NPC)element$iv;
                    boolean bl2 = false;
                    if (!Intrinsics.areEqual((Object)it.getEntity().method_5477().getString(), (Object)npcName)) continue;
                    bl = true;
                    break block5;
                }
                bl = false;
            }
        }
        if (bl) {
            throw new NPCCreationException("A NPC with the name '" + npcName + "' already exists.");
        }
    }

    private final void checkLimit() {
        if (this.uuidToNpc.size() == 10) {
            throw new NPCCreationException("Currently there are no more than10 parallel running NPCs supported!");
        }
    }

    private static final void createNpc$lambda$2$lambda$0(NPCConfig $config, NPCService this$0, class_1657 $owner, String $name, class_3222 npcEntity) {
        $config.setUuid(npcEntity.method_5667());
        NPCFactory nPCFactory = this$0.factory;
        Intrinsics.checkNotNull((Object)npcEntity);
        NPC npc = nPCFactory.createNpc(npcEntity, $config, this$0.resourceProvider.getLoadedConversations().get($config.getUuid()));
        npc.getController().setOwner($owner);
        ((Map)this$0.uuidToNpc).put($config.getUuid(), npc);
        LogUtil.infoInChat("Added NPC with name: " + $name);
        npc.getEventHandler().onEvent("You have just spawned into the world. \nGreet your owner warmly, introduce yourself in character, and show readiness to help. \nThen begin with a simple task, like gathering wood, unless the player gives you another task.\n");
    }

    private static final void createNpc$lambda$2$lambda$1(NPCService this$0, class_3222 it) {
        UUID uUID = it.method_5667();
        Intrinsics.checkNotNullExpressionValue((Object)uUID, (String)"getUuid(...)");
        MinecraftServer minecraftServer = EntityVer.getWorld((class_1297)((class_1297)it)).method_8503();
        Intrinsics.checkNotNull((Object)minecraftServer);
        class_3324 class_33242 = minecraftServer.method_3760();
        Intrinsics.checkNotNullExpressionValue((Object)class_33242, (String)"getPlayerManager(...)");
        this$0.removeNpc(uUID, class_33242);
    }

    private static final void createNpc$lambda$2(NPCConfig $newConfig, NPCService this$0, MinecraftServer $server, class_2338 $spawnPos, class_1657 $owner) {
        String name = $newConfig.getNpcName();
        this$0.checkLimit();
        Intrinsics.checkNotNull((Object)name);
        this$0.checkNpcName(name);
        NPCConfig config = this$0.updateConfig($newConfig);
        NPCSpawner.spawn(config, $server, $spawnPos, arg_0 -> NPCService.createNpc$lambda$2$lambda$0(config, this$0, $owner, name, arg_0));
        NPCEvents.ON_DEATH.register(arg_0 -> NPCService.createNpc$lambda$2$lambda$1(this$0, arg_0));
    }

    private static final Void createNpc$lambda$3(Throwable it) {
        LogUtil.errorInChat(it.getMessage());
        LogUtil.error(it);
        return null;
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0003\b\u0086\u0003\u0018\u00002\u00020\u0001B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003R\u0014\u0010\u0005\u001a\u00020\u00048\u0002X\u0082T\u00a2\u0006\u0006\n\u0004\b\u0005\u0010\u0006\u00a8\u0006\u0007"}, d2={"Lme/sailex/secondbrain/common/NPCService$Companion;", "", "<init>", "()V", "", "MAX_NUMBER_OF_NPC", "I", "1.20.1"})
    public static final class Companion {
        private Companion() {
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

