/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.config;

import io.wispforest.endec.Endec;
import io.wispforest.endec.StructEndec;
import io.wispforest.endec.impl.StructEndecBuilder;
import io.wispforest.endec.impl.StructField;
import java.util.UUID;
import me.sailex.secondbrain.config.Configurable;
import me.sailex.secondbrain.llm.LLMType;

public class NPCConfig
implements Configurable {
    private String npcName = "Steve";
    private UUID uuid = UUID.randomUUID();
    private boolean isActive = true;
    private String llmCharacter = "- young guy\n- speaks in short sentences\n- types everything in lowercase\n- slightly impatient but helpful\n- knowledgeable about mining and crafting\n- curious about exploring new areas\n";
    private LLMType llmType = LLMType.OLLAMA;
    private String ollamaUrl = "http://localhost:11434";
    private String llmModel = "llama3.2";
    private String openaiApiKey = "";
    private String voiceId = "not set";
    private String skinUrl = "";
    private boolean isTTS = false;
    public static final StructEndec<NPCConfig> ENDEC = StructEndecBuilder.of((StructField)Endec.STRING.fieldOf("npcName", NPCConfig::getNpcName), (StructField)Endec.STRING.fieldOf("uuid", config -> config.getUuid().toString()), (StructField)Endec.BOOLEAN.fieldOf("isActive", NPCConfig::isActive), (StructField)Endec.STRING.fieldOf("llmDefaultPrompt", NPCConfig::getLlmCharacter), (StructField)Endec.forEnum(LLMType.class).fieldOf("llmType", NPCConfig::getLlmType), (StructField)Endec.STRING.fieldOf("llmModel", NPCConfig::getLlmModel), (StructField)Endec.STRING.fieldOf("ollamaUrl", NPCConfig::getOllamaUrl), (StructField)Endec.STRING.fieldOf("openaiApiKey", NPCConfig::getOpenaiApiKey), (StructField)Endec.BOOLEAN.fieldOf("isTTS", NPCConfig::isTTS), (StructField)Endec.STRING.fieldOf("voiceId", NPCConfig::getVoiceId), (StructField)Endec.STRING.fieldOf("skinUrl", NPCConfig::getSkinUrl), NPCConfig::new);
    public static final String NPC_NAME = "Name of the NPC";
    public static final String EDIT_NPC = "Edit '%s'";
    public static final String LLM_CHARACTER = "Characteristics";
    public static final String LLM_TYPE = "Type";
    public static final String LLM_MODEL = "LLM Model";
    public static final String OLLAMA_URL = "Ollama URL";
    public static final String OPENAI_API_KEY = "OpenAI API Key";
    public static final String IS_TTS = "Text to Speech";

    public NPCConfig() {
    }

    public NPCConfig(String npcName) {
        this.npcName = npcName;
    }

    public NPCConfig(String npcName, String uuid, boolean isActive, String llmCharacter, LLMType llmType, String llmModel, String ollamaUrl, String openaiApiKey, boolean isTTS, String voiceId, String skinUrl) {
        this.npcName = npcName;
        this.uuid = UUID.fromString(uuid);
        this.isActive = isActive;
        this.llmCharacter = llmCharacter;
        this.llmType = llmType;
        this.llmModel = llmModel;
        this.ollamaUrl = ollamaUrl;
        this.openaiApiKey = openaiApiKey;
        this.isTTS = isTTS;
        this.voiceId = voiceId;
        this.skinUrl = skinUrl;
    }

    public static Builder builder(String npcName) {
        return new Builder(npcName);
    }

    public String getNpcName() {
        return this.npcName;
    }

    public boolean isActive() {
        return this.isActive;
    }

    public String getLlmCharacter() {
        return this.llmCharacter;
    }

    public LLMType getLlmType() {
        return this.llmType;
    }

    public String getLlmModel() {
        return this.llmModel;
    }

    public void setLlmModel(String llmModel) {
        this.llmModel = llmModel;
    }

    public String getOllamaUrl() {
        return this.ollamaUrl;
    }

    public String getOpenaiApiKey() {
        return this.openaiApiKey;
    }

    public void setLlmCharacter(String llmCharacter) {
        this.llmCharacter = llmCharacter;
    }

    public void setLlmType(LLMType llmType) {
        this.llmType = llmType;
    }

    public void setOllamaUrl(String ollamaUrl) {
        this.ollamaUrl = ollamaUrl;
    }

    public void setOpenaiApiKey(String openaiApiKey) {
        this.openaiApiKey = openaiApiKey;
    }

    public void setActive(boolean active) {
        this.isActive = active;
    }

    public void setNpcName(String npcName) {
        this.npcName = npcName;
    }

    public UUID getUuid() {
        return this.uuid;
    }

    public void setUuid(UUID uuid) {
        this.uuid = uuid;
    }

    public String getVoiceId() {
        return this.voiceId;
    }

    public void setVoiceId(String voiceId) {
        this.voiceId = voiceId;
    }

    public boolean isTTS() {
        return this.isTTS;
    }

    public void setTTS(boolean TTS) {
        this.isTTS = TTS;
    }

    public String getSkinUrl() {
        return this.skinUrl;
    }

    public void setSkinUrl(String skinUrl) {
        this.skinUrl = skinUrl;
    }

    @Override
    public String getConfigName() {
        return this.npcName.toLowerCase();
    }

    public static NPCConfig deepCopy(NPCConfig config) {
        return new NPCConfig(config.npcName, config.uuid.toString(), config.isActive, config.llmCharacter, config.llmType, config.llmModel, config.ollamaUrl, config.openaiApiKey, config.isTTS, config.voiceId, config.skinUrl);
    }

    public String toString() {
        return "NPCConfig{npcName=" + this.npcName + ",uuid=" + String.valueOf(this.uuid) + ",isActive=" + this.isActive + ",llmType=" + String.valueOf((Object)this.llmType) + ",ollamaUrl=" + this.ollamaUrl + ",openaiApiKey=***,llmCharacter=" + this.llmCharacter + ",voiceId=" + this.voiceId + "}";
    }

    public static class Builder {
        private final NPCConfig npcConfig;

        public Builder(String npcName) {
            this.npcConfig = new NPCConfig(npcName);
        }

        public Builder uuid(UUID uuid) {
            this.npcConfig.setUuid(uuid);
            return this;
        }

        public Builder llmDefaultPrompt(String llmDefaultPrompt) {
            this.npcConfig.setLlmCharacter(llmDefaultPrompt);
            return this;
        }

        public Builder llmType(LLMType llmType) {
            this.npcConfig.setLlmType(llmType);
            return this;
        }

        public Builder voiceId(String voiceId) {
            this.npcConfig.setVoiceId(voiceId);
            return this;
        }

        public Builder skinUrl(String skinUrl) {
            this.npcConfig.setSkinUrl(skinUrl);
            return this;
        }

        public NPCConfig build() {
            return this.npcConfig;
        }
    }
}

