/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.llm.openai;

import io.github.sashirestela.openai.SimpleOpenAI;
import io.github.sashirestela.openai.domain.chat.Chat;
import io.github.sashirestela.openai.domain.chat.ChatMessage;
import io.github.sashirestela.openai.domain.chat.ChatRequest;
import java.util.List;
import java.util.concurrent.TimeUnit;
import me.sailex.secondbrain.exception.LLMServiceException;
import me.sailex.secondbrain.history.Message;
import me.sailex.secondbrain.history.MessageConverter;
import me.sailex.secondbrain.llm.LLMClient;

public class OpenAiClient
implements LLMClient {
    private final SimpleOpenAI openAiService;
    private final String openAiModel;
    private final int timeout;

    public OpenAiClient(String model, String apiKey, int timeout) {
        this.openAiModel = model;
        this.openAiService = SimpleOpenAI.builder().apiKey(apiKey).build();
        this.timeout = timeout;
    }

    @Override
    public Message chat(List<Message> messages) {
        try {
            ChatRequest chatRequest = ChatRequest.builder().model(this.openAiModel).messages(messages.stream().map(MessageConverter::toChatMessage).toList()).build();
            ChatMessage.ResponseMessage responseMessage = ((Chat)this.openAiService.chatCompletions().create(chatRequest).get(this.timeout, TimeUnit.SECONDS)).firstMessage();
            return MessageConverter.toMessage(responseMessage);
        }
        catch (Exception e) {
            throw new LLMServiceException("Could not generate Response for prompt: " + messages.get(messages.size() - 1).getMessage(), e);
        }
    }

    @Override
    public void checkServiceIsReachable() {
    }

    @Override
    public void stopService() {
    }
}

