/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.util;

import me.sailex.secondbrain.config.ConfigProvider;
import net.minecraft.class_124;
import net.minecraft.class_2561;
import net.minecraft.class_2583;
import net.minecraft.class_5250;
import net.minecraft.server.MinecraftServer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class LogUtil {
    private static MinecraftServer server;
    private static ConfigProvider configProvider;
    private static final Logger LOGGER;
    private static final class_5250 PREFIX;

    public static void initialize(MinecraftServer server, ConfigProvider configProvider) {
        LogUtil.server = server;
        LogUtil.configProvider = configProvider;
    }

    private LogUtil() {
    }

    private static class_5250 formatDebug(String message) {
        return class_2561.method_43470((String)PREFIX.getString()).method_27693(message).method_10862(class_2583.field_24360.method_27706(class_124.field_1063));
    }

    public static class_5250 formatInfo(String message) {
        return class_2561.method_43470((String)"").method_10852((class_2561)PREFIX).method_27693(message);
    }

    public static class_5250 formatError(String message) {
        return class_2561.method_43470((String)"").method_10852((class_2561)PREFIX).method_27693(message).method_10862(class_2583.field_24360.method_27706(class_124.field_1061));
    }

    public static String formatExceptionMessage(String message) {
        int messageBegin = message.indexOf(": ");
        if (messageBegin != -1) {
            return message.substring(messageBegin + 1);
        }
        return message;
    }

    public static void debugInChat(String message) {
        LogUtil.log(LogUtil.formatDebug(message));
    }

    public static void infoInChat(String message) {
        LogUtil.log(LogUtil.formatInfo(message));
    }

    public static void errorInChat(String message) {
        LogUtil.log(LogUtil.formatError(LogUtil.formatExceptionMessage(message)));
    }

    public static void info(String message) {
        if (configProvider.getBaseConfig().isVerbose()) {
            LOGGER.info(LogUtil.formatInfo(message).getString());
        }
    }

    public static void error(String message) {
        LOGGER.error(LogUtil.formatError(message).getString());
    }

    public static void error(String message, Throwable e) {
        LOGGER.error(LogUtil.formatError(message).getString(), e);
    }

    public static void error(Throwable e) {
        LOGGER.error(e.getMessage(), e);
    }

    private static void log(class_5250 formattedMessage) {
        if (server != null) {
            server.method_3760().method_14571().stream().filter(player -> player.method_5687(2)).forEach(player -> player.method_7353((class_2561)formattedMessage, false));
        } else {
            LOGGER.error("{}server is null - cant log to ingame chat!", (Object)PREFIX.getString());
        }
    }

    static {
        LOGGER = LogManager.getLogger(LogUtil.class);
        PREFIX = class_2561.method_43470((String)"[SecondBrain] ").method_27692(class_124.field_1064);
    }
}

