/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.util;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import me.sailex.secondbrain.model.context.BlockData;
import me.sailex.secondbrain.model.context.EntityData;
import me.sailex.secondbrain.model.context.InventoryData;
import me.sailex.secondbrain.model.context.ItemData;
import me.sailex.secondbrain.model.context.StateData;
import me.sailex.secondbrain.model.context.WorldContext;
import net.minecraft.class_2338;

public class PromptFormatter {
    private PromptFormatter() {
    }

    public static String format(String prompt, WorldContext worldContext) {
        return "# INSTRUCTION\n%s\n\n# ENVIRONMENT\n## Nearby entities:\n%s\n## Nearest blocks:\n%s\n\n# INVENTORY\n%s\n\n# CURRENT STATE\n%s\n".formatted(prompt, PromptFormatter.formatEntities(worldContext.nearbyEntities(), 10), PromptFormatter.formatBlocks(worldContext.nearbyBlocks(), 15), PromptFormatter.formatInventory(worldContext.inventory()), PromptFormatter.formatNPCState(worldContext.state()));
    }

    public static String formatNPCState(StateData state) {
        class_2338 position = state.position();
        return String.format("- your position: %s\n- health: %s\n- hunger: %s\n- biome: %s\n", PromptFormatter.formatPosition(position), Float.valueOf(state.health()), state.food(), state.biome());
    }

    public static String formatBlocks(List<BlockData> blocks, int limit) {
        return PromptFormatter.formatList(blocks.stream().limit(limit).toList(), BlockData::type);
    }

    public static String formatEntities(List<EntityData> entities, int limit) {
        return PromptFormatter.formatList(entities.stream().distinct().limit(limit).toList(), EntityData::name);
    }

    public static String formatInventory(InventoryData inventory) {
        ArrayList<String> invParts = new ArrayList<String>();
        PromptFormatter.addInventoryPart(inventory.hotbar(), "hotbar: ", invParts);
        PromptFormatter.addInventoryPart(inventory.mainInventory(), "main inventory: ", invParts);
        PromptFormatter.addInventoryPart(inventory.armor(), "armor: ", invParts);
        PromptFormatter.addInventoryPart(inventory.offHand(), "offhand: ", invParts);
        if (invParts.isEmpty()) {
            invParts.add("<no items in inventory>");
        }
        return String.join((CharSequence)"\n", invParts);
    }

    private static void addInventoryPart(List<ItemData> items, String prefix, List<String> parts) {
        if (!items.isEmpty()) {
            parts.add(prefix + PromptFormatter.formatInventoryPart(items));
        }
    }

    private static String formatInventoryPart(List<ItemData> items) {
        return PromptFormatter.formatList(items, ItemData::type);
    }

    private static String formatPosition(class_2338 position) {
        return String.format("x: %s y: %s, z: %s", position.method_10263(), position.method_10264(), position.method_10260());
    }

    private static <T> String formatList(List<T> list, Function<T, String> formatter) {
        return list.stream().map(formatter).collect(Collectors.joining(", "));
    }
}

