/*
 * Decompiled with CFR 0.152.
 */
package me.sailex.secondbrain.config;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URL;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import me.sailex.secondbrain.util.LogUtil;
import org.apache.commons.io.FilenameUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class ResourceLoader {
    private static final Logger LOGGER = LogManager.getLogger(ResourceLoader.class);

    private ResourceLoader() {
    }

    public static Map<String, String> getAllResourcesContent(String resourcePath) {
        HashMap<String, String> contentMap = new HashMap<String, String>();
        try {
            Enumeration<URL> resources = ResourceLoader.class.getClassLoader().getResources(resourcePath);
            while (resources.hasMoreElements()) {
                URL resource = resources.nextElement();
                File folder = new File(resource.toURI());
                Optional.ofNullable(folder.listFiles()).ifPresent(files -> Arrays.stream(files).forEach(file -> {
                    String content = ResourceLoader.getResourceContent(resourcePath + "/" + file.getName());
                    if (content != null) {
                        contentMap.put(FilenameUtils.getBaseName((String)file.getName()), content);
                    }
                }));
            }
        }
        catch (Exception e) {
            LogUtil.error("Error reading resources: " + e.getMessage());
        }
        return contentMap;
    }

    private static String getResourceContent(String resourcePath) {
        String string;
        block8: {
            InputStream in = ResourceLoader.class.getClassLoader().getResourceAsStream(resourcePath);
            try {
                BufferedReader reader = new BufferedReader(new InputStreamReader(in));
                string = reader.lines().collect(Collectors.joining());
                if (in == null) break block8;
            }
            catch (Throwable throwable) {
                try {
                    if (in != null) {
                        try {
                            in.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (Exception e) {
                    LOGGER.error("Error reading resource file: {}", (Object)e.getMessage());
                    return null;
                }
            }
            in.close();
        }
        return string;
    }
}

