/*
 * Decompiled with CFR 0.152.
 */
package net.plastoid501.throwitems.util;

import com.mojang.serialization.DataResult;
import com.mojang.serialization.DynamicOps;
import com.mojang.serialization.MapLike;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Optional;
import net.minecraft.class_11352;
import net.minecraft.class_1792;
import net.minecraft.class_1799;
import net.minecraft.class_2487;
import net.minecraft.class_2499;
import net.minecraft.class_2507;
import net.minecraft.class_2509;
import net.minecraft.class_2520;
import net.minecraft.class_5455;
import net.minecraft.class_7225;
import net.minecraft.class_7923;
import net.minecraft.class_8942;
import net.plastoid501.throwitems.ThrowItems;
import net.plastoid501.throwitems.config.Configs;
import net.plastoid501.throwitems.mixin.INbtReadView;
import net.plastoid501.throwitems.util.FileUtil;

public class NbtUtil {
    private static final String THROW_ITEM_LIST_FILE = "list.nbt";
    private static final class_2487 throwItemList = new class_2487();

    public static void generateDefaultNbt() {
        Path path = FileUtil.getConfigPath().resolve("throw-items").resolve(THROW_ITEM_LIST_FILE);
        if (Files.notExists(path, new LinkOption[0])) {
            try {
                class_2507.method_10630((class_2487)throwItemList, (Path)path);
            }
            catch (IOException e) {
                throw new RuntimeException(e);
            }
        }
    }

    public static void addItemStack(class_1799 stack, class_5455 registries) {
        class_2487 nbt = NbtUtil.readItemListNbt();
        if (nbt == null) {
            return;
        }
        if (nbt.method_10545(Configs.throwItems.getSelected())) {
            Optional list = nbt.method_10554(Configs.throwItems.getSelected());
            List<class_1799> list2 = NbtUtil.toList(list.orElse(new class_2499()), false, registries);
            list2.add(stack);
            NbtUtil.sortList(list2);
            nbt.method_10566(Configs.throwItems.getSelected(), (class_2520)NbtUtil.toNbtList(list2, registries));
            NbtUtil.saveItemListNbt(nbt, registries);
        }
    }

    public static void addItemStack(class_2499 list, int index, class_1799 stack, class_5455 registries) {
        list.method_10533(index, (class_2520)NbtUtil.putItemStack(stack, registries));
    }

    public static void removeItemStack(int index, class_5455 registries) {
        class_2487 nbt = NbtUtil.readItemListNbt();
        if (nbt == null) {
            return;
        }
        if (nbt.method_10545(Configs.throwItems.getSelected())) {
            Optional list = nbt.method_10554(Configs.throwItems.getSelected());
            List<class_1799> list2 = NbtUtil.toList(list.orElse(new class_2499()), false, registries);
            list2.remove(index);
            nbt.method_10566(Configs.throwItems.getSelected(), (class_2520)NbtUtil.toNbtList(list2, registries));
            NbtUtil.saveItemListNbt(nbt, registries);
        }
    }

    public static boolean addNewNbtList(String key, class_5455 registries) {
        class_2487 nbt = NbtUtil.readItemListNbt();
        if (nbt == null) {
            return false;
        }
        if (nbt.method_10545(key = key.replace(" ", "_"))) {
            return false;
        }
        nbt.method_10566(key, (class_2520)new class_2499());
        NbtUtil.saveItemListNbt(nbt, registries);
        return true;
    }

    public static boolean removeNbtList(String key, class_5455 registries) {
        class_2487 nbt = NbtUtil.readItemListNbt();
        if (nbt == null) {
            return false;
        }
        if (!nbt.method_10545(key)) {
            return false;
        }
        nbt.method_10551(key);
        NbtUtil.saveItemListNbt(nbt, registries);
        return true;
    }

    public static List<class_1799> toList(class_2499 list, boolean sort, class_5455 registries) {
        ArrayList<class_1799> items = new ArrayList<class_1799>();
        for (class_2520 element : list) {
            if (element == null) continue;
            class_2509 ops = class_2509.field_11560;
            items.add((class_1799)ops.getMap((Object)element).flatMap(arg_0 -> NbtUtil.lambda$toList$0((DynamicOps)ops, arg_0)).getOrThrow());
        }
        return sort ? NbtUtil.sortList(items) : items;
    }

    public static class_2499 toNbtList(List<class_1799> stacks, class_5455 registries) {
        class_2499 list = new class_2499();
        for (class_1799 stack : stacks) {
            list.add((Object)NbtUtil.putItemStack(stack, registries));
        }
        return list;
    }

    public static List<class_1799> sortList(Collection<class_1799> list) {
        ArrayList<class_1799> sorted = new ArrayList<class_1799>();
        for (class_1792 item : class_7923.field_41178) {
            ArrayList<class_1799> items = new ArrayList<class_1799>();
            for (class_1799 stack : list) {
                if (!stack.method_31574(item)) continue;
                if (stack.method_57353().method_57837()) {
                    items.addLast(stack);
                    continue;
                }
                items.addFirst(stack);
            }
            sorted.addAll(items);
        }
        list.clear();
        list.addAll(sorted);
        return sorted;
    }

    private static class_2487 putItemStack(class_1799 stack, class_5455 registries) {
        class_11352 nbtReadView = (class_11352)class_11352.method_71417((class_8942)class_8942.field_60348, (class_7225.class_7874)registries, (class_2487)((class_2487)class_1799.field_24671.encodeStart((DynamicOps)registries.method_57093((DynamicOps)class_2509.field_11560), (Object)stack).getOrThrow()));
        return ((INbtReadView)nbtReadView).getNbt();
    }

    public static class_2487 readItemListNbt() {
        return NbtUtil.readNbtFile(FileUtil.getConfigPath().resolve("throw-items").resolve(THROW_ITEM_LIST_FILE));
    }

    public static class_2487 readNbtFile(Path path) {
        class_2487 nbt = null;
        try {
            nbt = class_2507.method_10633((Path)path);
        }
        catch (IOException e) {
            ThrowItems.LOGGER.info("Cannot read {}", (Object)path.getFileName().toString());
        }
        return nbt;
    }

    public static void saveItemListNbt(class_2487 nbt, class_5455 registries) {
        NbtUtil.writeNbtFile(FileUtil.getConfigPath().resolve("throw-items").resolve(THROW_ITEM_LIST_FILE), nbt);
        NbtUtil.updateNbt(registries);
    }

    public static void writeNbtFile(Path path, class_2487 nbt) {
        try {
            class_2507.method_10630((class_2487)nbt, (Path)path);
        }
        catch (IOException e) {
            ThrowItems.LOGGER.info("Cannot save {}", (Object)path.getFileName().toString());
        }
    }

    public static void updateNbt(class_5455 registries) {
        class_2487 nbt = NbtUtil.readItemListNbt();
        if (nbt == null) {
            NbtUtil.saveItemListNbt(throwItemList, registries);
            return;
        }
        LinkedHashMap<String, List<class_1799>> listMap = new LinkedHashMap<String, List<class_1799>>();
        for (String key : nbt.method_10541()) {
            listMap.put(key, NbtUtil.toList(nbt.method_10554(key).orElse(new class_2499()), true, registries));
        }
        Configs.throwItems.setStacks(listMap);
    }

    private static /* synthetic */ DataResult lambda$toList$0(DynamicOps ops, MapLike map) {
        return class_1799.field_55709.decode(ops, map);
    }

    static {
        throwItemList.method_10566("whitelist", (class_2520)new class_2499());
        throwItemList.method_10566("blacklist", (class_2520)new class_2499());
    }
}

