/*
 * Decompiled with CFR 0.152.
 */
package de.markusbordihn.easynpc.client.renderer;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Vector3f;
import de.markusbordihn.easynpc.client.renderer.EasyNPCRenderer;
import de.markusbordihn.easynpc.data.display.DisplayAttributeType;
import de.markusbordihn.easynpc.data.model.ModelPose;
import de.markusbordihn.easynpc.data.rotation.CustomRotation;
import de.markusbordihn.easynpc.entity.EasyNPCBaseEntity;
import de.markusbordihn.easynpc.entity.easynpc.EasyNPC;
import de.markusbordihn.easynpc.entity.easynpc.data.ScaleData;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.model.HumanoidModel;
import net.minecraft.client.model.geom.ModelLayerLocation;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.EntityRendererProvider;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.RenderLayerParent;
import net.minecraft.client.renderer.entity.layers.HumanoidArmorLayer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.core.BlockPos;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Pose;
import net.minecraft.world.level.LightLayer;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public interface EasyNPCModelRenderer<E extends EasyNPCBaseEntity<E>, M extends EntityModel<E>>
extends EasyNPCRenderer<E, M> {
    public static final Logger log = LogManager.getLogger((String)"Easy NPC: Core");

    public static <T extends LivingEntity, M extends HumanoidModel<T>, L extends RenderLayer<T, M>, R extends LivingEntityRenderer<T, M>> L getHumanoidArmorLayer(R mobRenderer, EntityRendererProvider.Context context, ModelLayerLocation innerArmor, ModelLayerLocation outerArmor, Class<L> armorLayerClass) {
        if (armorLayerClass != null) {
            try {
                return (L)((RenderLayer)armorLayerClass.getConstructor(RenderLayerParent.class, HumanoidModel.class, HumanoidModel.class).newInstance(mobRenderer, new HumanoidModel(context.m_174023_(innerArmor)), new HumanoidModel(context.m_174023_(outerArmor))));
            }
            catch (Exception e) {
                log.error("Failed to create custom armor layer for {} will use default armor layer instead.", mobRenderer, (Object)e);
            }
        }
        return (L)new HumanoidArmorLayer(mobRenderer, new HumanoidModel(context.m_174023_(innerArmor)), new HumanoidModel(context.m_174023_(outerArmor)));
    }

    public static void scaleEntity(EasyNPC<?> easyNPC, PoseStack poseStack) {
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        ScaleData scaleData = easyNPC.getEasyNPCScaleData();
        if (livingEntity.m_6162_()) {
            poseStack.m_85841_(scaleData.getScaleX().floatValue() * 0.5f, scaleData.getScaleY().floatValue() * 0.5f, scaleData.getScaleZ().floatValue() * 0.5f);
        } else {
            poseStack.m_85841_(scaleData.getScaleX().floatValue() * 0.9375f, scaleData.getScaleY().floatValue() * 0.9375f, scaleData.getScaleZ().floatValue() * 0.9375f);
        }
    }

    public static void renderEntityNameTag(EasyNPC<?> easyNPC, PoseStack poseStack) {
        CustomRotation rootRotation = easyNPC.getEasyNPCModelData().getModelRootRotation();
        if (rootRotation != null) {
            poseStack.m_85837_(0.0, -1.0, 0.0);
            poseStack.m_85845_(Vector3f.f_122223_.m_122270_(-rootRotation.x()));
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(-rootRotation.y()));
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(-rootRotation.z()));
            poseStack.m_85837_(0.0, 1.0, 0.0);
        }
    }

    public static int getEntityLightLevel(EasyNPC<?> easyNPC, BlockPos blockPos) {
        int entityLightLevel = easyNPC.getEasyNPCDisplayAttributeData().getDisplayIntAttribute(DisplayAttributeType.LIGHT_LEVEL);
        if (entityLightLevel > 0) {
            return entityLightLevel;
        }
        LivingEntity livingEntity = easyNPC.getLivingEntity();
        return livingEntity.f_19853_.m_45517_(LightLayer.BLOCK, blockPos);
    }

    default public void renderCustomPose(E entity, M model, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
    }

    default public void renderDefaultPose(E entity, M model, Pose pose, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
    }

    default public <N extends EasyNPC<E>> void rotateEntity(N easyNPC, PoseStack poseStack) {
        CustomRotation rootRotation = easyNPC.getEasyNPCModelData().getModelRootRotation();
        if (rootRotation != null) {
            poseStack.m_85837_(0.0, 1.0, 0.0);
            poseStack.m_85845_(Vector3f.f_122223_.m_122270_(rootRotation.x()));
            poseStack.m_85845_(Vector3f.f_122225_.m_122270_(rootRotation.y()));
            poseStack.m_85845_(Vector3f.f_122227_.m_122270_(rootRotation.z()));
            poseStack.m_85837_(0.0, -1.0, 0.0);
        }
    }

    default public void renderModel(E entity, M model, float entityYaw, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int packedLight) {
        this.rotateEntity((EasyNPC)entity, poseStack);
        ModelPose modelPose = entity.getModelPose();
        if (modelPose == ModelPose.DEFAULT) {
            this.renderDefaultPose(entity, model, entity.m_20089_(), entityYaw, partialTicks, poseStack, buffer, packedLight);
        } else if (modelPose == ModelPose.CUSTOM) {
            this.renderCustomPose(entity, model, entityYaw, partialTicks, poseStack, buffer, packedLight);
        }
    }
}

